/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.util;

import com.Polarice3.Goety.api.entities.IOwned;
import com.Polarice3.Goety.client.particles.AoEParticleOption;
import com.Polarice3.Goety.client.particles.CircleExplodeParticleOption;
import com.Polarice3.Goety.client.particles.GatherTrailParticle;
import com.Polarice3.Goety.client.particles.ModParticleTypes;
import com.Polarice3.Goety.client.particles.VerticalCircleExplodeParticleOption;
import com.Polarice3.Goety.common.effects.GoetyEffects;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.util.AbstractTrap;
import com.Polarice3.Goety.common.network.ModNetwork;
import com.Polarice3.Goety.common.network.server.SLightningBoltPacket;
import com.Polarice3.Goety.common.network.server.SLightningPacket;
import com.Polarice3.Goety.config.SpellConfig;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.ColorUtil;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.ModDamageSource;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class MagicLightningTrap
extends AbstractTrap {
    private static final EntityDataAccessor<Float> DATA_RADIUS = SynchedEntityData.m_135353_(MagicLightningTrap.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> DATA_DAMAGE = SynchedEntityData.m_135353_(MagicLightningTrap.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);

    public MagicLightningTrap(EntityType<?> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
        this.setParticle((ParticleOptions)ModParticleTypes.NONE.get());
    }

    public MagicLightningTrap(Level worldIn, double x, double y, double z) {
        this((EntityType)ModEntityType.MAGIC_LIGHTNING_TRAP.get(), worldIn);
        this.m_6034_(x, y, z);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(DATA_RADIUS, (Object)Float.valueOf(1.5f));
        this.m_20088_().m_135372_(DATA_DAMAGE, (Object)Float.valueOf(((Double)SpellConfig.ThunderboltDamage.get()).floatValue() * ((Integer)SpellConfig.SpellDamageMultiplier.get()).floatValue()));
    }

    @Override
    protected void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128350_("Radius", this.radius());
        compound.m_128350_("Damage", this.getDamage());
    }

    @Override
    protected void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("Radius")) {
            this.setRadius(compound.m_128457_("Radius"));
        }
        if (compound.m_128441_("Damage")) {
            this.setDamage(compound.m_128457_("Damage"));
        }
    }

    @Override
    public float radius() {
        return ((Float)this.f_19804_.m_135370_(DATA_RADIUS)).floatValue();
    }

    public void setRadius(float p_19713_) {
        if (!this.f_19853_.f_46443_) {
            this.m_20088_().m_135381_(DATA_RADIUS, (Object)Float.valueOf(Mth.m_14036_((float)p_19713_, (float)0.0f, (float)32.0f)));
        }
    }

    public void setDamage(float damage) {
        this.m_20088_().m_135381_(DATA_DAMAGE, (Object)Float.valueOf(damage));
    }

    public float getDamage() {
        return ((Float)this.m_20088_().m_135370_(DATA_DAMAGE)).floatValue();
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.f_19797_ == 1) {
            this.aoeIndicate();
        }
        if (this.f_19797_ >= this.getDuration()) {
            this.damageEntities();
            this.finalizeAttack();
        }
    }

    public void aoeIndicate() {
        float size = this.radius() * 2.0f;
        Level level = this.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ColorUtil colorUtil = new ColorUtil(ChatFormatting.WHITE);
            serverLevel.m_8767_((ParticleOptions)new AoEParticleOption(size, size / (float)this.getDuration(), 0.0f, this.getDuration()), this.m_20185_(), this.m_20186_() + (double)0.1f, this.m_20189_(), 0, (double)colorUtil.red(), (double)colorUtil.green(), (double)colorUtil.blue(), 1.0);
        }
    }

    public void damageEntities() {
        List list1 = this.f_19853_.m_6249_((Entity)this, new AABB(this.m_20185_() - 3.0, this.m_20186_() - 3.0, this.m_20189_() - 3.0, this.m_20185_() + 3.0, this.m_20186_() + 6.0 + 3.0, this.m_20189_() + 3.0), this::canHitEntity);
        for (Entity entity : list1) {
            LivingEntity livingEntity;
            if (!(entity instanceof LivingEntity) || !EntitySelector.f_20406_.test(livingEntity = (LivingEntity)entity)) continue;
            boolean flag = false;
            DamageSource damageSource = this.m_269291_().m_269548_();
            if (this.getOwner() != null) {
                if (!MobUtil.areAllies((Entity)this.getOwner(), (Entity)livingEntity)) {
                    flag = true;
                    damageSource = ModDamageSource.lightning(this, (Entity)this.getOwner());
                }
            } else {
                flag = true;
            }
            if (!flag || !livingEntity.m_6469_(damageSource, this.getDamage())) continue;
            this.hurtEffect(livingEntity);
        }
        this.m_216990_((SoundEvent)ModSounds.THUNDER_STRIKE_FAST.get());
    }

    public void hurtEffect(LivingEntity livingEntity) {
        float chance = 0.25f;
        if (this.f_19853_.m_46470_() && this.f_19853_.m_46758_(livingEntity.m_20183_())) {
            chance += 0.25f;
        }
        if (this.f_19853_.m_213780_().m_188501_() <= chance) {
            livingEntity.m_7292_(new MobEffectInstance((MobEffect)GoetyEffects.SPASMS.get(), MathHelper.secondsToTicks(5)));
        }
    }

    public void finalizeAttack() {
        Level level = this.f_19853_;
        if (level instanceof ServerLevel) {
            int i;
            ServerLevel serverLevel = (ServerLevel)level;
            ColorUtil colorUtil = new ColorUtil(11660252);
            ColorUtil colorUtil2 = new ColorUtil(11660252);
            serverLevel.m_8767_((ParticleOptions)new CircleExplodeParticleOption(colorUtil.red, colorUtil.green, colorUtil.blue, 3.0f, 1), this.m_20185_(), this.m_20186_(), this.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
            serverLevel.m_8767_((ParticleOptions)new VerticalCircleExplodeParticleOption(colorUtil.red, colorUtil.green, colorUtil.blue, 3.0f, 1), this.m_20185_(), this.m_20186_(), this.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
            ModNetwork.sendToALL(new SLightningBoltPacket(new Vec3(this.m_20185_(), this.m_20186_() + 250.0, this.m_20189_()), this.m_20182_(), colorUtil2, 10));
            for (i = 0; i < 8; ++i) {
                Vec3 vector3d1 = this.m_20182_().m_82520_((double)(this.f_19853_.m_213780_().m_188501_() - 0.5f) * 6.0, 3.0, (double)(this.f_19853_.m_213780_().m_188501_() - 0.5f) * 6.0);
                serverLevel.m_8767_((ParticleOptions)new GatherTrailParticle.Option(colorUtil, vector3d1), this.m_20185_(), this.m_20186_(), this.m_20189_(), 0, 0.0, 0.0, 0.0, 0.5);
            }
            for (i = 0; i < 16; ++i) {
                Vec3 vec3 = this.m_20182_().m_82520_(0.0, 1.0, 0.0);
                int random1 = this.f_19853_.m_213780_().m_216332_(-4, 4);
                int random2 = this.f_19853_.m_213780_().m_216332_(-4, 4);
                Vec3 vec31 = vec3.m_82520_(this.f_19853_.m_213780_().m_188500_() * (double)random1, this.f_19853_.m_213780_().m_188500_(), this.f_19853_.m_213780_().m_188500_() * (double)random2);
                ModNetwork.sendToALL(new SLightningPacket(vec3, vec31, colorUtil2, 12));
            }
        }
        this.m_146870_();
    }

    protected boolean canHitEntity(Entity pEntity) {
        if (this.getOwner() != null) {
            Mob mob;
            LivingEntity livingEntity = this.getOwner();
            if (livingEntity instanceof Mob && (mob = (Mob)livingEntity).m_5448_() == pEntity) {
                return pEntity.m_6084_();
            }
            if (MobUtil.areAllies((Entity)this.getOwner(), pEntity)) {
                return false;
            }
            if (this.getOwner() instanceof Enemy && pEntity instanceof Enemy) {
                return false;
            }
            if (pEntity instanceof IOwned) {
                IOwned owned0 = (IOwned)pEntity;
                LivingEntity livingEntity2 = this.getOwner();
                if (livingEntity2 instanceof IOwned) {
                    IOwned owned1 = (IOwned)livingEntity2;
                    return !MobUtil.ownerStack(owned0, owned1);
                }
            }
        }
        return pEntity.m_6084_();
    }
}

