/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.items.armor;

import com.Polarice3.Goety.Goety;
import com.Polarice3.Goety.api.items.IPersist;
import com.Polarice3.Goety.api.items.armor.ISoulDiscount;
import com.Polarice3.Goety.client.render.ModModelLayer;
import com.Polarice3.Goety.client.render.model.BlackIronArmorModel;
import com.Polarice3.Goety.common.items.ModItems;
import com.Polarice3.Goety.common.items.armor.ModArmorMaterials;
import com.Polarice3.Goety.config.ItemConfig;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;

public class BlackIronArmor
extends ArmorItem
implements ISoulDiscount,
IPersist {
    public BlackIronArmor(ArmorItem.Type p_40387_) {
        super((ArmorMaterial)ModArmorMaterials.BLACK_IRON, p_40387_, ModItems.baseProperties());
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String layer) {
        if (slot == EquipmentSlot.LEGS) {
            return Goety.location("textures/models/armor/black_iron_armor_layer.png").toString();
        }
        return Goety.location("textures/models/armor/black_iron_armor.png").toString();
    }

    public boolean m_142522_(ItemStack stack) {
        return this.isDamaged(stack);
    }

    public int m_142159_(ItemStack stack) {
        if (this.isBroken(stack)) {
            return 0x800000;
        }
        return super.m_142159_(stack);
    }

    public int m_142158_(ItemStack stack) {
        if (this.isBroken(stack)) {
            return 13;
        }
        return super.m_142158_(stack);
    }

    @Override
    public int getSoulDiscount(EquipmentSlot equipmentSlot, ItemStack stack) {
        if (this.isNotBroken(stack)) {
            if (equipmentSlot == EquipmentSlot.CHEST) {
                return 2;
            }
            return 1;
        }
        return 0;
    }

    @Override
    public boolean isBroken(ItemStack stack) {
        return IPersist.super.isBroken(stack) && (Boolean)ItemConfig.BlackIronPersist.get() != false;
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
        if (((Boolean)ItemConfig.BlackIronPersist.get()).booleanValue() && stack.m_41773_() + amount >= stack.m_41776_()) {
            if (stack.m_41773_() != stack.m_41776_() - 1) {
                stack.m_41721_(stack.m_41776_() - 1);
                onBroken.accept(entity);
            }
            return 0;
        }
        return super.damageItem(stack, amount, entity, onBroken);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        if (this.isNotBroken(stack) || !((Boolean)ItemConfig.BlackIronPersist.get()).booleanValue()) {
            return super.getAttributeModifiers(slot, stack);
        }
        return ImmutableMultimap.of();
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        super.initializeClient(consumer);
        consumer.accept(new IClientItemExtensions(){

            public HumanoidModel<?> getHumanoidArmorModel(LivingEntity livingEntity, ItemStack itemStack, EquipmentSlot equipmentSlot, HumanoidModel<?> original) {
                EntityModelSet modelSet = Minecraft.m_91087_().m_167973_();
                ModelPart root = modelSet.m_171103_(equipmentSlot == EquipmentSlot.LEGS ? ModModelLayer.BLACK_IRON_ARMOR_INNER : ModModelLayer.BLACK_IRON_ARMOR_OUTER);
                BlackIronArmorModel model = new BlackIronArmorModel(root);
                model.f_102809_.f_104207_ = equipmentSlot == EquipmentSlot.HEAD;
                model.body.f_104207_ = equipmentSlot == EquipmentSlot.CHEST;
                model.rightArm.f_104207_ = equipmentSlot == EquipmentSlot.CHEST;
                model.leftArm.f_104207_ = equipmentSlot == EquipmentSlot.CHEST;
                model.rightLeg.f_104207_ = equipmentSlot == EquipmentSlot.FEET;
                model.leftLeg.f_104207_ = equipmentSlot == EquipmentSlot.FEET;
                model.f_102610_ = original.f_102610_;
                model.f_102817_ = original.f_102817_;
                model.f_102609_ = original.f_102609_;
                model.f_102816_ = original.f_102816_;
                model.f_102815_ = original.f_102815_;
                return model;
            }
        });
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        int discount = this.getSoulDiscount(LivingEntity.m_147233_((ItemStack)stack), stack);
        if (discount > 0) {
            tooltip.add(this.soulDiscountTooltip(stack));
        }
        if (((Boolean)ItemConfig.BlackIronPersist.get()).booleanValue() && this.isBroken(stack)) {
            tooltip.add((Component)Component.m_237115_((String)"info.goety.armor.broken").m_130940_(ChatFormatting.DARK_RED));
        }
    }
}

