/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.items.magic;

import com.Polarice3.Goety.api.entities.ally.IServant;
import com.Polarice3.Goety.api.items.IPersist;
import com.Polarice3.Goety.common.network.ModNetwork;
import com.Polarice3.Goety.common.network.server.SPlayPlayerSoundPacket;
import com.Polarice3.Goety.config.ItemConfig;
import com.Polarice3.Goety.init.ModTags;
import com.Polarice3.Goety.utils.BlockFinder;
import com.Polarice3.Goety.utils.ItemHelper;
import com.Polarice3.Goety.utils.ServerParticleUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class EsotericTesseract
extends Item
implements IPersist {
    public static String BIG = "Big";
    public static String LARGE = "Large";
    public static String HUGE = "Huge";

    public EsotericTesseract() {
        super(new Item.Properties().m_41487_(1).m_41486_().m_41503_((Integer)ItemConfig.TesseractDurability.get() + 1).m_41497_(Rarity.RARE));
    }

    public boolean m_142522_(ItemStack stack) {
        return this.isDamaged(stack);
    }

    public int m_142159_(ItemStack stack) {
        if (this.isBroken(stack)) {
            return 0x800000;
        }
        return super.m_142159_(stack);
    }

    public int m_142158_(ItemStack stack) {
        if (this.isBroken(stack)) {
            return 13;
        }
        return super.m_142158_(stack);
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
        if (stack.m_41773_() + amount >= stack.m_41776_()) {
            if (stack.m_41773_() != stack.m_41776_() - 1) {
                stack.m_41721_(stack.m_41776_() - 1);
                onBroken.accept(entity);
            }
            return 0;
        }
        return super.damageItem(stack, amount, entity, onBroken);
    }

    public static boolean isSmall(Mob mob) {
        return mob.m_6095_().m_204039_(ModTags.EntityTypes.TESSERACT_SMALL) || mob.m_20191_().m_82309_() >= 2.0;
    }

    public static boolean isMedium(Mob mob) {
        return mob.m_6095_().m_204039_(ModTags.EntityTypes.TESSERACT_MEDIUM) || mob.m_20191_().m_82309_() >= 3.0;
    }

    public static boolean isLarge(Mob mob) {
        return mob.m_6095_().m_204039_(ModTags.EntityTypes.TESSERACT_LARGE) || mob.m_20191_().m_82309_() >= 4.0;
    }

    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity target) {
        OwnableEntity owned;
        Mob mob;
        if (target instanceof Mob && (mob = (Mob)target).m_6084_() && mob instanceof OwnableEntity && (owned = (OwnableEntity)mob).m_269323_() == player && mob.m_6072_()) {
            if (stack.m_41720_() == this && this.isNotBroken(stack) && !player.f_19853_.f_46443_ && EsotericTesseract.getServantsInTesseract(stack) < (Integer)ItemConfig.TesseractCapacity.get()) {
                boolean flag = true;
                if (EsotericTesseract.isLarge(mob)) {
                    if (EsotericTesseract.getServantsInTesseract(stack) > 0) {
                        flag = false;
                    }
                } else if (EsotericTesseract.isMedium(mob)) {
                    if (EsotericTesseract.getServantsInTesseract(stack) > (Integer)ItemConfig.TesseractCapacity.get() - 4) {
                        flag = false;
                    }
                } else if (EsotericTesseract.isSmall(mob) && EsotericTesseract.getServantsInTesseract(stack) > (Integer)ItemConfig.TesseractCapacity.get() - 2) {
                    flag = false;
                }
                if (flag) {
                    EsotericTesseract.putServantIntoTesseract(stack, mob, EsotericTesseract.getServantsInTesseract(stack) + 1);
                    player.m_5496_(SoundEvents.f_11771_, 1.0f, 0.75f);
                    ModNetwork.sendTo(player, new SPlayPlayerSoundPacket(SoundEvents.f_11771_, 1.0f, 0.75f));
                    mob.m_146870_();
                }
            }
            return true;
        }
        return false;
    }

    public int m_8105_(ItemStack p_41454_) {
        return 72000;
    }

    public UseAnim m_6164_(ItemStack p_41452_) {
        return UseAnim.BOW;
    }

    public void m_5929_(Level worldIn, LivingEntity livingEntityIn, ItemStack stack, int count) {
        super.m_5929_(worldIn, livingEntityIn, stack, count);
        if (!worldIn.f_46443_ && stack.m_150930_((Item)this)) {
            if (EsotericTesseract.getServantsInTesseract(stack) > 0) {
                int servantCount;
                int time = this.m_8105_(stack) - count;
                if (time > 0 && time % 20 == 0 && (servantCount = EsotericTesseract.ejectSingleServant(stack, worldIn, livingEntityIn.m_20183_())) > 0) {
                    worldIn.m_5594_(null, livingEntityIn.m_20183_(), SoundEvents.f_11852_, livingEntityIn.m_5720_(), 1.0f, 1.0f);
                    ItemHelper.hurtAndBreak(stack, servantCount, livingEntityIn);
                }
            } else {
                livingEntityIn.m_5810_();
            }
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack itemstack = playerIn.m_21120_(handIn);
        if (EsotericTesseract.getServantsInTesseract(itemstack) > 0) {
            playerIn.m_6672_(handIn);
            return InteractionResultHolder.m_19096_((Object)itemstack);
        }
        return super.m_7203_(worldIn, playerIn, handIn);
    }

    public static void putServantIntoTesseract(ItemStack tesseract, Mob mob, int count) {
        CompoundTag tag = tesseract.m_41783_();
        if (tag == null) {
            tag = new CompoundTag();
        }
        CompoundTag servantTag = new CompoundTag();
        ResourceLocation typesKey = ForgeRegistries.ENTITY_TYPES.getKey((Object)mob.m_6095_());
        if (typesKey != null) {
            servantTag.m_128359_("ServantType", typesKey.toString());
            if (mob.f_19840_) {
                servantTag.m_128379_("Invulnerable", true);
            }
            if (mob.m_20067_()) {
                servantTag.m_128379_("Silent", mob.m_20067_());
            }
            if (mob.m_20068_()) {
                servantTag.m_128379_("NoGravity", mob.m_20068_());
            }
            if (!mob.canUpdate()) {
                servantTag.m_128379_("CanUpdate", mob.canUpdate());
            }
            if (!mob.m_19880_().isEmpty()) {
                ListTag listtag = new ListTag();
                for (String s : mob.m_19880_()) {
                    listtag.add((Object)StringTag.m_129297_((String)s));
                }
                servantTag.m_128365_("Tags", (Tag)listtag);
            }
            if (!mob.getPersistentData().m_128456_()) {
                servantTag.m_128365_("ForgeData", (Tag)mob.getPersistentData().m_6426_());
            }
            mob.m_7380_(servantTag);
            if (mob.m_8077_()) {
                servantTag.m_128359_("CustomName", Component.Serializer.m_130703_((Component)mob.m_7770_()));
            }
            if (EsotericTesseract.isLarge(mob)) {
                servantTag.m_128379_(HUGE, true);
            } else if (EsotericTesseract.isMedium(mob)) {
                servantTag.m_128379_(LARGE, true);
            } else if (EsotericTesseract.isSmall(mob)) {
                servantTag.m_128379_(BIG, true);
            }
            String mainName = "Servant_";
            if (!tag.m_128431_().isEmpty()) {
                String name;
                for (int i = 0; i < tag.m_128431_().size() && tag.m_128441_(name = mainName + count); ++i) {
                    ++count;
                }
            }
            String finalName = mainName + count;
            tag.m_128365_(finalName, (Tag)servantTag);
        }
        tesseract.m_41751_(tag);
    }

    public static int getServantsInTesseract(ItemStack stack) {
        int servantCount = 0;
        if (stack.m_41783_() != null) {
            for (String tagInfo : stack.m_41783_().m_128431_()) {
                if (!tagInfo.contains("Servant")) continue;
                CompoundTag servantTag = stack.m_41783_().m_128469_(tagInfo);
                if (servantTag.m_128441_(HUGE)) {
                    servantCount += ((Integer)ItemConfig.TesseractCapacity.get()).intValue();
                    continue;
                }
                if (servantTag.m_128441_(LARGE)) {
                    servantCount += 4;
                    continue;
                }
                if (servantTag.m_128441_(BIG)) {
                    servantCount += 2;
                    continue;
                }
                ++servantCount;
            }
        }
        return servantCount;
    }

    public static int ejectSingleServant(ItemStack stack, Level level, BlockPos pos) {
        String tagInfo;
        Optional<String> optional;
        int servantCount = 0;
        if (stack.m_41783_() != null && (optional = stack.m_41783_().m_128431_().stream().filter(string -> string.contains("Servant")).findFirst()).isPresent() && (tagInfo = optional.get()).contains("Servant")) {
            Entity entity;
            CompoundTag servantTag = stack.m_41783_().m_128469_(tagInfo);
            servantCount = servantTag.m_128441_(HUGE) ? (Integer)ItemConfig.TesseractCapacity.get() : (servantTag.m_128441_(LARGE) ? (servantCount += 4) : (servantTag.m_128441_(BIG) ? (servantCount += 2) : ++servantCount));
            EntityType entityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(servantTag.m_128461_("ServantType")));
            if (entityType != null && (entity = entityType.m_20615_(level)) instanceof Mob) {
                Mob servant = (Mob)entity;
                if (entity instanceof OwnableEntity) {
                    if (servantTag.m_128441_("Invulnerable")) {
                        servant.f_19840_ = servantTag.m_128471_("Invulnerable");
                    }
                    if (servantTag.m_128441_("Silent")) {
                        servant.m_20225_(servantTag.m_128471_("Silent"));
                    }
                    if (servantTag.m_128441_("NoGravity")) {
                        servant.m_20242_(servantTag.m_128471_("NoGravity"));
                    }
                    if (servantTag.m_128441_("CanUpdate")) {
                        servant.canUpdate(servantTag.m_128471_("CanUpdate"));
                    }
                    if (servantTag.m_128425_("Tags", 9)) {
                        servant.m_19880_().clear();
                        ListTag listtag3 = servantTag.m_128437_("Tags", 8);
                        int i = Math.min(listtag3.size(), 1024);
                        for (int j = 0; j < i; ++j) {
                            servant.m_19880_().add(listtag3.m_128778_(j));
                        }
                    }
                    if (servantTag.m_128425_("ForgeData", 10)) {
                        servant.getPersistentData().m_128391_(servantTag.m_128469_("ForgeData"));
                    }
                    servant.m_7378_(servantTag);
                    if (!servantTag.m_128461_("CustomName").isEmpty()) {
                        servant.m_6593_((Component)Component.Serializer.m_130701_((String)servantTag.m_128461_("CustomName")));
                    }
                    BlockPos blockPos = BlockFinder.SummonRadius(pos, (Entity)servant, level, 4);
                    servant.m_7678_((double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_(), (double)blockPos.m_123343_() + 0.5, 0.0f, 0.0f);
                    if (level instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)level;
                        level.m_7967_((Entity)servant);
                        if (servant instanceof IServant) {
                            IServant servant1 = (IServant)servant;
                            servant1.setFollowing();
                        }
                        ServerParticleUtil.addParticlesAroundMiddleSelf(serverLevel, (ParticleOptions)ParticleTypes.f_123760_, (Entity)servant);
                    }
                    if (!stack.m_41619_()) {
                        stack.m_41783_().m_128473_(tagInfo);
                    }
                }
            }
        }
        return servantCount;
    }

    public static int ejectAllServants(ItemStack stack, Level level, BlockPos pos) {
        int servantCount = 0;
        if (stack.m_41783_() != null) {
            for (String tagInfo : stack.m_41783_().m_128431_()) {
                Entity entity;
                if (!tagInfo.contains("Servant")) continue;
                ++servantCount;
                CompoundTag servantTag = stack.m_41783_().m_128469_(tagInfo);
                EntityType entityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(servantTag.m_128461_("ServantType")));
                if (entityType == null || !((entity = entityType.m_20615_(level)) instanceof Mob)) continue;
                Mob servant = (Mob)entity;
                if (!(entity instanceof OwnableEntity)) continue;
                if (servantTag.m_128441_("Invulnerable")) {
                    servant.f_19840_ = servantTag.m_128471_("Invulnerable");
                }
                if (servantTag.m_128441_("Silent")) {
                    servant.m_20225_(servantTag.m_128471_("Silent"));
                }
                if (servantTag.m_128441_("NoGravity")) {
                    servant.m_20242_(servantTag.m_128471_("NoGravity"));
                }
                if (servantTag.m_128441_("CanUpdate")) {
                    servant.canUpdate(servantTag.m_128471_("CanUpdate"));
                }
                if (servantTag.m_128425_("Tags", 9)) {
                    servant.m_19880_().clear();
                    ListTag listtag3 = servantTag.m_128437_("Tags", 8);
                    int i = Math.min(listtag3.size(), 1024);
                    for (int j = 0; j < i; ++j) {
                        servant.m_19880_().add(listtag3.m_128778_(j));
                    }
                }
                if (servantTag.m_128425_("ForgeData", 10)) {
                    servant.getPersistentData().m_128391_(servantTag.m_128469_("ForgeData"));
                }
                servant.m_7378_(servantTag);
                if (!servantTag.m_128461_("CustomName").isEmpty()) {
                    servant.m_6593_((Component)Component.Serializer.m_130701_((String)servantTag.m_128461_("CustomName")));
                }
                BlockPos blockPos = pos;
                if (servantCount > 1) {
                    blockPos = BlockFinder.SummonRadius(pos, (Entity)servant, level, 3);
                }
                servant.m_7678_((double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_(), (double)blockPos.m_123343_() + 0.5, 0.0f, 0.0f);
                if (level.m_5776_()) continue;
                level.m_7967_((Entity)servant);
                if (!(servant instanceof IServant)) continue;
                IServant servant1 = (IServant)servant;
                servant1.setFollowing();
            }
        }
        if (!stack.m_41619_()) {
            stack.m_41751_(new CompoundTag());
        }
        return servantCount;
    }

    public void onDestroyed(ItemEntity entity, DamageSource source) {
        ItemStack stack = entity.m_32055_();
        if (EsotericTesseract.getServantsInTesseract(stack) > 0) {
            EsotericTesseract.ejectAllServants(stack, entity.f_19853_, entity.m_20183_());
            entity.f_19853_.m_5594_(null, entity.m_20183_(), (SoundEvent)SoundEvents.f_12377_.get(), entity.m_5720_(), 1.0f, 1.0f);
        }
    }

    public boolean m_6832_(ItemStack pToRepair, ItemStack pRepair) {
        return pRepair.m_204117_(Tags.Items.ENDER_PEARLS) || super.m_6832_(pToRepair, pRepair);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        int servantCount = 0;
        ArrayList<String> servantNames = new ArrayList<String>();
        if (stack.m_41783_() != null) {
            for (String tagInfo : stack.m_41783_().m_128431_()) {
                MutableComponent servantNameTag;
                if (!tagInfo.contains("Servant")) continue;
                CompoundTag servantTag = stack.m_41783_().m_128469_(tagInfo);
                servantCount = servantTag.m_128441_(HUGE) ? (Integer)ItemConfig.TesseractCapacity.get() : (servantTag.m_128441_(LARGE) ? (servantCount += 4) : (servantTag.m_128441_(BIG) ? (servantCount += 2) : ++servantCount));
                EntityType entityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(servantTag.m_128461_("ServantType")));
                String servantName = Component.m_237115_((String)"info.goety.servant").toString();
                if (entityType != null) {
                    servantName = I18n.m_118938_((String)entityType.m_20675_(), (Object[])new Object[0]);
                }
                if (!servantTag.m_128461_("CustomName").isEmpty() && (servantNameTag = Component.Serializer.m_130701_((String)servantTag.m_128461_("CustomName"))) != null) {
                    servantName = servantNameTag.getString();
                }
                servantNames.add(servantName);
            }
        }
        if (this.isBroken(stack)) {
            tooltip.add((Component)Component.m_237115_((String)"info.goety.armor.broken").m_130940_(ChatFormatting.DARK_RED));
        }
        if (servantCount <= 0) {
            tooltip.add((Component)Component.m_237115_((String)"item.goety.tesseract").m_130940_(ChatFormatting.DARK_PURPLE));
            tooltip.add((Component)Component.m_237115_((String)"item.goety.tesseract.empty").m_130940_(ChatFormatting.BLUE));
        } else {
            tooltip.add((Component)Component.m_237115_((String)"item.goety.tesseract.unleash").m_130940_(ChatFormatting.DARK_PURPLE));
        }
        tooltip.add((Component)Component.m_237110_((String)"item.goety.tesseract.contains", (Object[])new Object[]{servantCount, ItemConfig.TesseractCapacity.get()}).m_130940_(ChatFormatting.GRAY));
        if (!servantNames.isEmpty()) {
            for (int i = 0; i < servantNames.size() && i < 3; ++i) {
                tooltip.add((Component)Component.m_237113_((String)((String)servantNames.get(i))).m_130940_(ChatFormatting.GRAY));
            }
            if (servantNames.size() > 3) {
                tooltip.add((Component)Component.m_237110_((String)"item.goety.tesseract.more", (Object[])new Object[]{servantNames.size() - 3}).m_130940_(ChatFormatting.GRAY));
            }
        }
    }
}

