/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.listeners;

import com.Polarice3.Goety.Goety;
import com.Polarice3.Goety.common.events.IllagerSpawner;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.registries.ForgeRegistries;

public class IllagerAssaultListener
extends SimpleJsonResourceReloadListener {
    public static Map<ResourceLocation, IllagerSpawner.IllagerDataType> ILLAGER_LIST = new HashMap<ResourceLocation, IllagerSpawner.IllagerDataType>();
    private static final Gson GSON = new GsonBuilder().create();
    private final ICondition.IContext context;

    public IllagerAssaultListener(ICondition.IContext context) {
        super(GSON, "illager_assault");
        this.context = context;
    }

    protected void apply(Map<ResourceLocation, JsonElement> objectIn, ResourceManager resourceManagerIn, ProfilerFiller profilerIn) {
        ILLAGER_LIST.clear();
        for (int i = 0; i < objectIn.size(); ++i) {
            ResourceLocation location = (ResourceLocation)objectIn.keySet().toArray()[i];
            JsonObject object = objectIn.get(location).getAsJsonObject();
            if (!CraftingHelper.processConditions((JsonObject)object, (String)"conditions", (ICondition.IContext)this.context)) {
                Goety.LOGGER.debug("Skipping loading illager entry {} as it's conditions were not met", (Object)location);
                continue;
            }
            String name = object.getAsJsonPrimitive("entity_type").getAsString();
            ResourceLocation resourceLocation = new ResourceLocation(name);
            JsonObject data = object.getAsJsonObject("registry");
            float thresholdTimes = data.getAsJsonPrimitive("threshold_times").getAsFloat();
            int max = data.getAsJsonPrimitive("max").getAsInt();
            int extra = data.getAsJsonPrimitive("extra").getAsInt();
            float chance = data.getAsJsonPrimitive("chance").getAsFloat();
            JsonObject data2 = data.getAsJsonObject("riding");
            ResourceLocation resourceLocation1 = null;
            float chance2 = 0.0f;
            if (data2 != null) {
                resourceLocation1 = new ResourceLocation(data2.getAsJsonPrimitive("mount_type").getAsString());
                if (!ForgeRegistries.ENTITY_TYPES.containsKey(resourceLocation1)) {
                    resourceLocation1 = null;
                }
                chance2 = data2.getAsJsonPrimitive("ride_chance").getAsFloat();
            }
            ILLAGER_LIST.put(location, new IllagerSpawner.IllagerDataType(resourceLocation, thresholdTimes, max, extra, chance, resourceLocation1, chance2));
        }
    }
}

