/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.magic;

import com.Polarice3.Goety.api.entities.IOwned;
import com.Polarice3.Goety.api.magic.ISummonSpell;
import com.Polarice3.Goety.client.particles.MagicSmokeParticle;
import com.Polarice3.Goety.common.effects.GoetyEffects;
import com.Polarice3.Goety.common.items.ModItems;
import com.Polarice3.Goety.common.magic.Spell;
import com.Polarice3.Goety.common.magic.SpellStat;
import com.Polarice3.Goety.config.SpellConfig;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.ColorUtil;
import com.Polarice3.Goety.utils.CuriosFinder;
import com.Polarice3.Goety.utils.EffectsUtil;
import com.Polarice3.Goety.utils.SEHelper;
import com.Polarice3.Goety.utils.ServerParticleUtil;
import java.util.function.Predicate;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public abstract class SummonSpell
extends Spell
implements ISummonSpell {
    @Override
    public SpellStat defaultStats() {
        return super.defaultStats().setDuration(1).setRadius(0.0).setBurning(0);
    }

    @Override
    public abstract int SummonDownDuration();

    public boolean NecroPower(LivingEntity entityLiving) {
        return CuriosFinder.hasUndeadCape(entityLiving);
    }

    public boolean FrostPower(LivingEntity entityLiving) {
        return CuriosFinder.hasFrostRobes(entityLiving);
    }

    public boolean WildPower(LivingEntity entityLiving) {
        return CuriosFinder.hasWildRobe(entityLiving);
    }

    public boolean NetherPower(LivingEntity entityLiving) {
        return CuriosFinder.hasNetherRobe(entityLiving);
    }

    public int summonLimit() {
        return 64;
    }

    public Predicate<LivingEntity> summonPredicate() {
        return livingEntity -> livingEntity instanceof IOwned;
    }

    @Override
    public boolean conditionsMet(ServerLevel worldIn, LivingEntity caster) {
        int count = 0;
        for (Entity entity : worldIn.m_8583_()) {
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity livingEntity = (LivingEntity)entity;
            if (!(entity instanceof IOwned)) continue;
            IOwned owned = (IOwned)entity;
            if (!this.summonPredicate().test(livingEntity) || owned.getTrueOwner() != caster || !livingEntity.m_6084_()) continue;
            ++count;
        }
        if (count >= this.summonLimit() && !this.isShifting(caster)) {
            if (caster instanceof Player) {
                Player player = (Player)caster;
                player.m_5661_((Component)Component.m_237115_((String)"info.goety.summon.limit"), true);
            }
            return false;
        }
        return super.conditionsMet(worldIn, caster);
    }

    @Override
    public void commonResult(ServerLevel worldIn, LivingEntity caster) {
        if (this.isShifting(caster)) {
            for (Entity entity : worldIn.m_8583_()) {
                if (!(entity instanceof LivingEntity)) continue;
                LivingEntity livingEntity = (LivingEntity)entity;
                if (!this.summonPredicate().test(livingEntity)) continue;
                this.teleportServants(caster, entity);
            }
            this.commonResultHit(worldIn, caster);
        }
    }

    public void commonResultHit(ServerLevel worldIn, LivingEntity caster) {
        for (int i = 0; i < caster.f_19853_.f_46441_.m_188503_(35) + 10; ++i) {
            worldIn.m_8767_((ParticleOptions)ParticleTypes.f_123759_, caster.m_20185_(), caster.m_20188_(), caster.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
        }
        this.playSound(worldIn, (Entity)caster, (SoundEvent)ModSounds.SUMMON_SPELL.get());
    }

    public void summonAdvancement(LivingEntity summoner, LivingEntity summoned) {
        if (summoner instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)summoner;
            CriteriaTriggers.f_10580_.m_68256_(serverPlayer, (Entity)summoned);
        }
    }

    public void buffSummon(LivingEntity caster, LivingEntity summoned, int potency) {
        if (potency > 0 && !this.hasSummonDown(caster)) {
            int boost = Mth.m_14045_((int)(potency - 1), (int)0, (int)10);
            summoned.m_7292_(new MobEffectInstance((MobEffect)GoetyEffects.BUFF.get(), EffectsUtil.infiniteEffect(), boost, false, false));
        }
    }

    @Override
    public void SummonDown(LivingEntity entityLiving) {
        if (((Boolean)SpellConfig.SummonDown.get()).booleanValue()) {
            ISummonSpell.super.SummonDown(entityLiving);
        }
    }

    public void teleportServants(LivingEntity owner, Entity servant) {
        if (servant instanceof IOwned) {
            IOwned servant1 = (IOwned)servant;
            if (servant instanceof LivingEntity) {
                LivingEntity servant2 = (LivingEntity)servant;
                if (servant1.getTrueOwner() == owner && !SEHelper.isGrounded(owner, servant2)) {
                    servant.m_20219_(owner.m_20182_());
                }
            }
        }
    }

    public void summonParticles(ServerLevel worldIn, LivingEntity caster, ItemStack staff, LivingEntity summoned) {
        ColorUtil colorUtil = new ColorUtil(2804175);
        int colorFrom = 1552608;
        int colorTo = 0xFFFFFF;
        if (staff.m_150930_((Item)ModItems.NAMELESS_STAFF.get())) {
            colorUtil = new ColorUtil(11009086);
            colorFrom = 11009086;
            colorTo = 13630615;
        }
        ServerParticleUtil.windShockwaveParticle(worldIn, colorUtil, 0.1f, 0.1f, 0.05f, -1, summoned.m_20182_());
        for (int i2 = 0; i2 < worldIn.m_213780_().m_188503_(10) + 10; ++i2) {
            worldIn.m_8767_((ParticleOptions)new MagicSmokeParticle.Option(colorFrom, colorTo, 10 + worldIn.m_213780_().m_188503_(10), 0.2f), summoned.m_20208_(1.5), summoned.m_20187_(), summoned.m_20262_(1.5), 0, 0.0, 0.0, 0.0, 1.0);
        }
    }
}

