/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.magic.construct;

import com.Polarice3.Goety.api.magic.IMold;
import com.Polarice3.Goety.common.blocks.ModBlocks;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.ally.golem.RedstoneCube;
import com.Polarice3.Goety.common.entities.ally.golem.RedstoneGolem;
import com.Polarice3.Goety.common.research.ResearchList;
import com.Polarice3.Goety.config.SpellConfig;
import com.Polarice3.Goety.utils.SEHelper;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.Tags;

public class RedstoneGolemMold
implements IMold {
    private static final List<BlockPos> BOTTOM_STONE_LOCATIONS = ImmutableList.of((Object)new BlockPos(0, -1, 0), (Object)new BlockPos(0, -1, 1), (Object)new BlockPos(0, -1, -1), (Object)new BlockPos(1, -1, 0), (Object)new BlockPos(-1, -1, 0), (Object)new BlockPos(1, -1, 1), (Object)new BlockPos(1, -1, -1), (Object)new BlockPos(-1, -1, 1), (Object)new BlockPos(-1, -1, -1), (Object)new BlockPos(2, -1, 1), (Object)new BlockPos(2, -1, -1), (Object)new BlockPos(-2, -1, 1), (Object[])new BlockPos[]{new BlockPos(-2, -1, -1), new BlockPos(1, -1, 2), new BlockPos(-1, -1, 2), new BlockPos(1, -1, -2), new BlockPos(-1, -1, -2)});
    private static final List<BlockPos> ABOVE_STONE_LOCATIONS = ImmutableList.of((Object)new BlockPos(1, 0, 3), (Object)new BlockPos(-1, 0, 3), (Object)new BlockPos(1, 0, -3), (Object)new BlockPos(-1, 0, -3), (Object)new BlockPos(3, 0, 1), (Object)new BlockPos(3, 0, -1), (Object)new BlockPos(-3, 0, 1), (Object)new BlockPos(-3, 0, -1));
    private static final List<BlockPos> STONE_LOCATIONS = Stream.of(BOTTOM_STONE_LOCATIONS, ABOVE_STONE_LOCATIONS).flatMap(Collection::stream).toList();
    private static final List<BlockPos> BOTTOM_DIAMOND_LOCATIONS = ImmutableList.of((Object)new BlockPos(2, -1, 0), (Object)new BlockPos(-2, -1, 0), (Object)new BlockPos(0, -1, 2), (Object)new BlockPos(0, -1, -2));
    private static final List<BlockPos> ABOVE_DIAMOND_LOCATIONS = ImmutableList.of((Object)new BlockPos(0, 0, 3), (Object)new BlockPos(0, 0, -3), (Object)new BlockPos(3, 0, 0), (Object)new BlockPos(-3, 0, 0), (Object)new BlockPos(-2, 0, 2), (Object)new BlockPos(2, 0, 2), (Object)new BlockPos(2, 0, -2), (Object)new BlockPos(-2, 0, -2));
    private static final List<BlockPos> DIAMOND_LOCATIONS = Stream.of(BOTTOM_DIAMOND_LOCATIONS, ABOVE_DIAMOND_LOCATIONS).flatMap(Collection::stream).toList();
    private static final List<BlockPos> LAVA_LOCATIONS = ImmutableList.of((Object)new BlockPos(3, -1, 1), (Object)new BlockPos(3, -1, 0), (Object)new BlockPos(3, -1, -1), (Object)new BlockPos(-3, -1, 1), (Object)new BlockPos(-3, -1, 0), (Object)new BlockPos(-3, -1, -1), (Object)new BlockPos(1, -1, 3), (Object)new BlockPos(0, -1, 3), (Object)new BlockPos(-1, -1, 3), (Object)new BlockPos(1, -1, -3), (Object)new BlockPos(0, -1, -3), (Object)new BlockPos(-1, -1, -3), (Object[])new BlockPos[]{new BlockPos(-2, -1, 2), new BlockPos(2, -1, 2), new BlockPos(2, -1, -2), new BlockPos(-2, -1, -2), new BlockPos(4, 0, 1), new BlockPos(4, 0, 0), new BlockPos(4, 0, -1), new BlockPos(1, 0, 4), new BlockPos(0, 0, 4), new BlockPos(-1, 0, 4), new BlockPos(-4, 0, 1), new BlockPos(-4, 0, 0), new BlockPos(-4, 0, -1), new BlockPos(1, 0, -4), new BlockPos(0, 0, -4), new BlockPos(-1, 0, -4), new BlockPos(3, 0, 2), new BlockPos(3, 0, -2), new BlockPos(-3, 0, 2), new BlockPos(-3, 0, -2), new BlockPos(2, 0, 3), new BlockPos(2, 0, -3), new BlockPos(-2, 0, 3), new BlockPos(-2, 0, -3)});
    private static final List<BlockPos> REDSTONE_LOCATIONS = ImmutableList.of((Object)new BlockPos(0, 0, 0), (Object)new BlockPos(1, 0, 0), (Object)new BlockPos(0, 0, 1), (Object)new BlockPos(-1, 0, 0), (Object)new BlockPos(0, 0, -1), (Object)new BlockPos(1, 0, 1), (Object)new BlockPos(-1, 0, 1), (Object)new BlockPos(1, 0, -1), (Object)new BlockPos(-1, 0, -1), (Object)new BlockPos(0, 0, 2), (Object)new BlockPos(1, 0, 2), (Object)new BlockPos(-1, 0, 2), (Object[])new BlockPos[]{new BlockPos(0, 0, -2), new BlockPos(1, 0, -2), new BlockPos(-1, 0, -2), new BlockPos(2, 0, 0), new BlockPos(2, 0, 1), new BlockPos(2, 0, -1), new BlockPos(-2, 0, 0), new BlockPos(-2, 0, 1), new BlockPos(-2, 0, -1)});

    private static List<BlockPos> checkStones(Level level, BlockPos blockPos) {
        ArrayList<BlockPos> invalid = new ArrayList<BlockPos>();
        for (BlockPos blockPos1 : STONE_LOCATIONS) {
            BlockPos blockPos2 = blockPos.m_121955_((Vec3i)blockPos1);
            BlockState blockState = level.m_8055_(blockPos2);
            if (!blockState.m_60734_().m_7705_().contains("bricks")) {
                invalid.add(blockPos1);
            }
            if (blockState.m_60838_((BlockGetter)level, blockPos2)) continue;
            invalid.add(blockPos1);
        }
        return invalid;
    }

    private static List<BlockPos> checkDiamonds(Level level, BlockPos blockPos) {
        ArrayList<BlockPos> invalid = new ArrayList<BlockPos>();
        for (BlockPos blockPos1 : DIAMOND_LOCATIONS) {
            BlockPos blockPos2 = blockPos.m_121955_((Vec3i)blockPos1);
            if (level.m_8055_(blockPos2).m_60713_((Block)ModBlocks.DIAMOND_MOLD_BLOCK.get())) continue;
            invalid.add(blockPos1);
        }
        return invalid;
    }

    private static List<BlockPos> checkLava(Level level, BlockPos blockPos) {
        ArrayList<BlockPos> invalid = new ArrayList<BlockPos>();
        for (BlockPos blockPos1 : LAVA_LOCATIONS) {
            BlockPos blockPos2 = blockPos.m_121955_((Vec3i)blockPos1);
            if (level.m_8055_(blockPos2).m_60713_(Blocks.f_49991_)) continue;
            invalid.add(blockPos1);
        }
        return invalid;
    }

    private static List<BlockPos> checkRedstone(Level level, BlockPos blockPos) {
        ArrayList<BlockPos> invalid = new ArrayList<BlockPos>();
        for (BlockPos blockPos1 : REDSTONE_LOCATIONS) {
            BlockPos blockPos2 = blockPos.m_121955_((Vec3i)blockPos1);
            if (level.m_8055_(blockPos2).m_204336_(Tags.Blocks.STORAGE_BLOCKS_REDSTONE)) continue;
            invalid.add(blockPos1);
        }
        return invalid;
    }

    public static boolean checkBlocks(Level level, BlockPos blockPos) {
        return RedstoneGolemMold.checkStones(level, blockPos).isEmpty() && RedstoneGolemMold.checkDiamonds(level, blockPos).isEmpty() && RedstoneGolemMold.checkLava(level, blockPos).isEmpty() && RedstoneGolemMold.checkRedstone(level, blockPos).isEmpty();
    }

    public static boolean conditionsMet(Level worldIn, LivingEntity entityLiving) {
        int count = 0;
        if (worldIn instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)worldIn;
            for (Entity entity : serverLevel.m_8583_()) {
                RedstoneGolem servant;
                if (!(entity instanceof RedstoneGolem) || (servant = (RedstoneGolem)entity).getTrueOwner() != entityLiving || !servant.m_6084_()) continue;
                ++count;
            }
        }
        return count < (Integer)SpellConfig.RedstoneGolemLimit.get();
    }

    @Override
    public boolean spawnServant(Player player, ItemStack stack, Level level, BlockPos blockPos) {
        if (!level.f_46443_ && level.m_8055_(blockPos).m_204336_(Tags.Blocks.STORAGE_BLOCKS_REDSTONE)) {
            if (RedstoneGolemMold.checkBlocks(level, blockPos)) {
                if (SEHelper.hasResearch(player, ResearchList.WARRED)) {
                    if (RedstoneGolemMold.conditionsMet(level, (LivingEntity)player)) {
                        RedstoneGolem redstoneGolem1 = (RedstoneGolem)((EntityType)ModEntityType.REDSTONE_GOLEM.get()).m_20615_(level);
                        if (redstoneGolem1 != null) {
                            redstoneGolem1.setTrueOwner((LivingEntity)player);
                            redstoneGolem1.m_6518_((ServerLevelAccessor)level, level.m_6436_(redstoneGolem1.m_20183_()), MobSpawnType.MOB_SUMMONED, null, null);
                            redstoneGolem1.m_7678_((double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_() + 0.05, (double)blockPos.m_123343_() + 0.5, 0.0f, 0.0f);
                            if (level.m_7967_((Entity)redstoneGolem1)) {
                                RedstoneGolemMold.removeBlocks(level, blockPos);
                                stack.m_41774_(1);
                                if (player instanceof ServerPlayer) {
                                    ServerPlayer serverPlayer = (ServerPlayer)player;
                                    CriteriaTriggers.f_10580_.m_68256_(serverPlayer, (Entity)redstoneGolem1);
                                }
                                return true;
                            }
                        }
                    } else {
                        player.m_5661_((Component)Component.m_237115_((String)"info.goety.summon.limit"), true);
                    }
                } else {
                    player.m_5661_((Component)Component.m_237115_((String)"info.goety.research.fail"), true);
                }
            } else {
                RedstoneCube redstoneCube = (RedstoneCube)((EntityType)ModEntityType.REDSTONE_CUBE.get()).m_20615_(level);
                if (redstoneCube != null) {
                    redstoneCube.m_6518_((ServerLevelAccessor)level, level.m_6436_(redstoneCube.m_20183_()), MobSpawnType.MOB_SUMMONED, null, null);
                    redstoneCube.setTrueOwner((LivingEntity)player);
                    redstoneCube.m_7678_((double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_() + 0.05, (double)blockPos.m_123343_() + 0.5, 0.0f, 0.0f);
                    if (level.m_7967_((Entity)redstoneCube)) {
                        level.m_46796_(2001, blockPos, Block.m_49956_((BlockState)level.m_8055_(blockPos)));
                        level.m_46597_(blockPos, Blocks.f_50016_.m_49966_());
                        stack.m_41774_(1);
                        if (player instanceof ServerPlayer) {
                            ServerPlayer serverPlayer = (ServerPlayer)player;
                            CriteriaTriggers.f_10580_.m_68256_(serverPlayer, (Entity)redstoneCube);
                        }
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public static void removeBlocks(Level level, BlockPos blockPos) {
        if (!level.f_46443_) {
            BlockPos blockPos2;
            for (BlockPos blockPos1 : LAVA_LOCATIONS) {
                blockPos2 = blockPos.m_121955_((Vec3i)blockPos1);
                if (!level.m_8055_(blockPos2).m_60713_(Blocks.f_49991_)) continue;
                level.m_46796_(2001, blockPos2, Block.m_49956_((BlockState)level.m_8055_(blockPos2)));
                level.m_46597_(blockPos2, Blocks.f_50016_.m_49966_());
            }
            for (BlockPos blockPos1 : REDSTONE_LOCATIONS) {
                blockPos2 = blockPos.m_121955_((Vec3i)blockPos1);
                if (!level.m_8055_(blockPos2).m_204336_(Tags.Blocks.STORAGE_BLOCKS_REDSTONE)) continue;
                level.m_46796_(2001, blockPos2, Block.m_49956_((BlockState)level.m_8055_(blockPos2)));
                level.m_46597_(blockPos2, Blocks.f_50016_.m_49966_());
            }
        }
    }
}

