/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.magic.spells;

import com.Polarice3.Goety.client.particles.RisingCircleParticleOption;
import com.Polarice3.Goety.client.particles.SoulShockwaveParticleOption;
import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.common.magic.Spell;
import com.Polarice3.Goety.common.magic.SpellStat;
import com.Polarice3.Goety.config.SpellConfig;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.ColorUtil;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.RandomUtil;
import com.Polarice3.Goety.utils.WandUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;

public class SoulHealSpell
extends Spell {
    @Override
    public SpellStat defaultStats() {
        return super.defaultStats().setPotency(1).setRadius(0.0);
    }

    @Override
    public int defaultSoulCost() {
        return (Integer)SpellConfig.SoulHealCost.get();
    }

    @Override
    public int defaultCastDuration() {
        return (Integer)SpellConfig.SoulHealDuration.get();
    }

    @Override
    public int defaultSpellCooldown() {
        return (Integer)SpellConfig.SoulHealCoolDown.get();
    }

    @Override
    public SoundEvent CastingSound() {
        return (SoundEvent)ModSounds.PREPARE_SPELL.get();
    }

    @Override
    public List<Enchantment> acceptedEnchantments() {
        ArrayList<Enchantment> list = new ArrayList<Enchantment>();
        list.add((Enchantment)ModEnchantments.POTENCY.get());
        list.add((Enchantment)ModEnchantments.RADIUS.get());
        return list;
    }

    @Override
    public boolean conditionsMet(ServerLevel worldIn, LivingEntity caster) {
        if (caster instanceof Mob) {
            Mob mob = (Mob)caster;
            return mob.m_21223_() < mob.m_21233_();
        }
        return super.conditionsMet(worldIn, caster);
    }

    @Override
    public void SpellResult(ServerLevel worldIn, LivingEntity caster, ItemStack staff, SpellStat spellStat) {
        int potency = spellStat.getPotency();
        double radius = spellStat.getRadius();
        if (WandUtil.enchantedFocus(caster)) {
            potency += WandUtil.getLevels((Enchantment)ModEnchantments.POTENCY.get(), caster);
            radius += (double)WandUtil.getLevels((Enchantment)ModEnchantments.RADIUS.get(), caster);
        }
        float heal = (float)RandomUtil.nextInt(worldIn.m_213780_(), (Integer)SpellConfig.SoulHealAmount.get() * Math.max(1, potency)) + 1.0f;
        caster.m_5634_(heal);
        if (radius > 0.0) {
            for (LivingEntity livingEntity : worldIn.m_45976_(LivingEntity.class, caster.m_20191_().m_82400_(8.0 * radius))) {
                if (MobUtil.getOwner((Entity)livingEntity) == null || MobUtil.getOwner((Entity)livingEntity) != caster) continue;
                livingEntity.m_5634_(heal);
                this.healParticles(livingEntity, worldIn);
            }
        }
        worldIn.m_8767_((ParticleOptions)new SoulShockwaveParticleOption(), caster.m_20185_(), caster.m_20186_() + 0.5, caster.m_20189_(), 0, 0.0, 0.0, 0.0, 0.0);
        this.healParticles(caster, worldIn);
        this.playSound(worldIn, (Entity)caster, (SoundEvent)ModSounds.SOUL_HEAL.get());
    }

    public void healParticles(LivingEntity livingEntity, ServerLevel worldIn) {
        ColorUtil colorUtil = new ColorUtil(2804175);
        worldIn.m_8767_((ParticleOptions)new RisingCircleParticleOption(0), livingEntity.m_20185_(), livingEntity.m_20186_(), livingEntity.m_20189_(), 0, (double)colorUtil.red(), (double)colorUtil.green(), (double)colorUtil.blue(), 1.0);
        worldIn.m_8767_((ParticleOptions)new RisingCircleParticleOption(5), livingEntity.m_20185_(), livingEntity.m_20186_(), livingEntity.m_20189_(), 0, (double)colorUtil.red(), (double)colorUtil.green(), (double)colorUtil.blue(), 1.0);
        worldIn.m_8767_((ParticleOptions)new RisingCircleParticleOption(10), livingEntity.m_20185_(), livingEntity.m_20186_(), livingEntity.m_20189_(), 0, (double)colorUtil.red(), (double)colorUtil.green(), (double)colorUtil.blue(), 1.0);
    }
}

