/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.magic.spells.nether;

import com.Polarice3.Goety.api.magic.SpellType;
import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.common.entities.projectiles.HellBolt;
import com.Polarice3.Goety.common.entities.projectiles.ModFireball;
import com.Polarice3.Goety.common.magic.Spell;
import com.Polarice3.Goety.common.magic.SpellStat;
import com.Polarice3.Goety.config.SpellConfig;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.CuriosFinder;
import com.Polarice3.Goety.utils.WandUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class FireballSpell
extends Spell {
    @Override
    public int defaultSoulCost() {
        return (Integer)SpellConfig.FireballCost.get();
    }

    @Override
    public int defaultCastDuration() {
        return (Integer)SpellConfig.FireballDuration.get();
    }

    @Override
    public SoundEvent CastingSound(LivingEntity caster) {
        if (CuriosFinder.hasUnholySet(caster)) {
            return (SoundEvent)ModSounds.HELL_BOLT_SHOOT.get();
        }
        return SoundEvents.f_11705_;
    }

    @Override
    public int defaultSpellCooldown() {
        return (Integer)SpellConfig.FireballCoolDown.get();
    }

    @Override
    public SpellType getSpellType() {
        return SpellType.NETHER;
    }

    @Override
    public List<Enchantment> acceptedEnchantments() {
        ArrayList<Enchantment> list = new ArrayList<Enchantment>();
        list.add((Enchantment)ModEnchantments.POTENCY.get());
        list.add((Enchantment)ModEnchantments.BURNING.get());
        return list;
    }

    @Override
    public void SpellResult(ServerLevel worldIn, LivingEntity caster, ItemStack staff, SpellStat spellStat) {
        int potency = spellStat.getPotency();
        int burning = spellStat.getBurning();
        if (WandUtil.enchantedFocus(caster)) {
            potency += WandUtil.getLevels((Enchantment)ModEnchantments.POTENCY.get(), caster);
            burning += WandUtil.getLevels((Enchantment)ModEnchantments.BURNING.get(), caster);
        }
        Vec3 vector3d = caster.m_20252_(1.0f);
        Object smallFireballEntity = new ModFireball((Level)worldIn, caster.m_20185_() + vector3d.f_82479_ / 2.0, caster.m_20188_() - 0.2, caster.m_20189_() + vector3d.f_82481_ / 2.0, vector3d.f_82479_, vector3d.f_82480_, vector3d.f_82481_);
        if (CuriosFinder.hasUnholySet(caster)) {
            smallFireballEntity = new HellBolt(caster.m_20185_() + vector3d.f_82479_ / 2.0, caster.m_20188_() - 0.2, caster.m_20189_() + vector3d.f_82481_ / 2.0, vector3d.f_82479_, vector3d.f_82480_, vector3d.f_82481_, (Level)worldIn);
        }
        smallFireballEntity.m_5602_((Entity)caster);
        if (smallFireballEntity instanceof ModFireball) {
            ModFireball fireball = smallFireballEntity;
            if (this.isShifting(caster)) {
                fireball.setDangerous(false);
            }
            fireball.setExtraDamage(potency);
            fireball.setFiery(burning);
        } else if (smallFireballEntity instanceof HellBolt) {
            HellBolt hellBolt = (HellBolt)((Object)smallFireballEntity);
            hellBolt.setDamage(hellBolt.getDamage() + (float)potency);
            hellBolt.setFiery(burning);
        }
        worldIn.m_7967_((Entity)smallFireballEntity);
        if (this.rightStaff(staff)) {
            for (int i = 0; i < 2; ++i) {
                Object smallFireballEntity2 = new ModFireball((Level)worldIn, caster.m_20185_() + vector3d.f_82479_ / 2.0 + worldIn.f_46441_.m_188583_(), caster.m_20188_() - 0.2, caster.m_20189_() + vector3d.f_82481_ / 2.0 + worldIn.f_46441_.m_188583_(), vector3d.f_82479_, vector3d.f_82480_, vector3d.f_82481_);
                if (CuriosFinder.hasUnholySet(caster)) {
                    smallFireballEntity2 = new HellBolt(caster.m_20185_() + vector3d.f_82479_ / 2.0 + worldIn.f_46441_.m_188583_(), caster.m_20188_() - 0.2, caster.m_20189_() + vector3d.f_82481_ / 2.0 + worldIn.f_46441_.m_188583_(), vector3d.f_82479_, vector3d.f_82480_, vector3d.f_82481_, (Level)worldIn);
                }
                smallFireballEntity2.m_5602_((Entity)caster);
                if (smallFireballEntity2 instanceof ModFireball) {
                    ModFireball fireball = smallFireballEntity2;
                    if (this.isShifting(caster)) {
                        fireball.setDangerous(false);
                    }
                    fireball.setExtraDamage(potency);
                    fireball.setFiery(burning);
                } else if (smallFireballEntity2 instanceof HellBolt) {
                    HellBolt hellBolt = (HellBolt)((Object)smallFireballEntity2);
                    hellBolt.setDamage(hellBolt.getDamage() + (float)potency);
                    hellBolt.setFiery(burning);
                }
                worldIn.m_7967_((Entity)smallFireballEntity2);
            }
        }
        this.playSound(worldIn, caster, 2.0f, this.projPitch(worldIn.m_213780_()));
    }
}

