/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.magic.spells.storm;

import com.Polarice3.Goety.api.magic.SpellType;
import com.Polarice3.Goety.client.particles.ShockwaveParticleOption;
import com.Polarice3.Goety.client.particles.VerticalCircleExplodeParticleOption;
import com.Polarice3.Goety.common.effects.GoetyEffects;
import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.common.magic.Spell;
import com.Polarice3.Goety.common.magic.SpellStat;
import com.Polarice3.Goety.config.SpellConfig;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.ColorUtil;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.ModDamageSource;
import com.Polarice3.Goety.utils.RandomUtil;
import com.Polarice3.Goety.utils.SpellExplosion;
import com.Polarice3.Goety.utils.WandUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;

public class DischargeSpell
extends Spell {
    @Override
    public SpellStat defaultStats() {
        return super.defaultStats().setRadius(3.0);
    }

    @Override
    public int defaultSoulCost() {
        return (Integer)SpellConfig.DischargeCost.get();
    }

    @Override
    public int defaultCastDuration() {
        return (Integer)SpellConfig.DischargeDuration.get();
    }

    @Override
    public int defaultSpellCooldown() {
        return (Integer)SpellConfig.DischargeCoolDown.get();
    }

    @Override
    public SoundEvent CastingSound() {
        return (SoundEvent)ModSounds.PREPARE_SPELL.get();
    }

    @Override
    public SpellType getSpellType() {
        return SpellType.STORM;
    }

    @Override
    public List<Enchantment> acceptedEnchantments() {
        ArrayList<Enchantment> list = new ArrayList<Enchantment>();
        list.add((Enchantment)ModEnchantments.POTENCY.get());
        list.add((Enchantment)ModEnchantments.RADIUS.get());
        return list;
    }

    @Override
    public void SpellResult(final ServerLevel worldIn, final LivingEntity caster, final ItemStack staff, SpellStat spellStat) {
        int radius = (int)spellStat.getRadius();
        float potency = spellStat.getPotency();
        float damage = ((Double)SpellConfig.DischargeDamage.get()).floatValue() * (float)((Integer)SpellConfig.SpellDamageMultiplier.get()).intValue();
        float maxDamage = ((Double)SpellConfig.DischargeMaxDamage.get()).floatValue() * (float)((Integer)SpellConfig.SpellDamageMultiplier.get()).intValue();
        if (WandUtil.enchantedFocus(caster)) {
            radius += WandUtil.getLevels((Enchantment)ModEnchantments.RADIUS.get(), caster);
            potency += (float)WandUtil.getLevels((Enchantment)ModEnchantments.POTENCY.get(), caster) / 2.0f;
        }
        damage += potency;
        maxDamage += potency;
        ColorUtil colorUtil = new ColorUtil(16709015);
        worldIn.m_8767_((ParticleOptions)new ShockwaveParticleOption(colorUtil.red(), colorUtil.green(), colorUtil.blue()), caster.m_20185_(), caster.m_20186_() + 0.5, caster.m_20189_(), 0, 0.0, 0.0, 0.0, 0.0);
        worldIn.m_8767_((ParticleOptions)new VerticalCircleExplodeParticleOption(colorUtil.red(), colorUtil.green(), colorUtil.blue(), radius, 1), caster.m_20185_(), caster.m_20186_() + 0.5, caster.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
        float trueDamage = Mth.m_14036_((float)(damage + (float)RandomUtil.nextInt(worldIn.m_213780_(), (int)(maxDamage - damage))), (float)damage, (float)maxDamage);
        new SpellExplosion((Level)worldIn, (Entity)caster, ModDamageSource.directShock(caster), caster.m_20183_(), radius, trueDamage){

            @Override
            public void explodeHurt(Entity target, DamageSource damageSource, double x, double y, double z, double seen, float actualDamage) {
                if (target instanceof LivingEntity) {
                    LivingEntity target1 = (LivingEntity)target;
                    super.explodeHurt(target, damageSource, x, y, z, seen, actualDamage);
                    float chance = DischargeSpell.this.rightStaff(staff) ? 0.25f : 0.05f;
                    float chainDamage = actualDamage / 2.0f;
                    if (worldIn.m_46470_() && worldIn.m_46758_(target1.m_20183_())) {
                        chance += 0.25f;
                        chainDamage = actualDamage;
                    }
                    if (worldIn.f_46441_.m_188501_() <= chance) {
                        target1.m_7292_(new MobEffectInstance((MobEffect)GoetyEffects.SPASMS.get(), MathHelper.secondsToTicks(5)));
                    }
                    if (DischargeSpell.this.rightStaff(staff)) {
                        WandUtil.chainLightning(target1, caster, 6.0, chainDamage);
                    }
                }
            }
        };
        this.playSound(worldIn, (Entity)caster, (SoundEvent)ModSounds.REDSTONE_EXPLODE.get(), 2.0f, 1.0f);
    }
}

