/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.magic.spells.void_spells;

import com.Polarice3.Goety.api.magic.SpellType;
import com.Polarice3.Goety.common.blocks.ModBlocks;
import com.Polarice3.Goety.common.blocks.entities.HoleBlockEntity;
import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.common.magic.BlockSpell;
import com.Polarice3.Goety.common.magic.SpellStat;
import com.Polarice3.Goety.config.SpellConfig;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.init.ModTags;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.WandUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class TunnelSpell
extends BlockSpell {
    @Override
    public SpellStat defaultStats() {
        return super.defaultStats().setRange((Integer)SpellConfig.TunnelDefaultDistance.get());
    }

    @Override
    public int defaultSoulCost() {
        return (Integer)SpellConfig.TunnelCost.get();
    }

    @Override
    @Nullable
    public SoundEvent CastingSound() {
        return (SoundEvent)ModSounds.PREPARE_SPELL.get();
    }

    @Override
    public int defaultSpellCooldown() {
        return (Integer)SpellConfig.TunnelCoolDown.get();
    }

    @Override
    public SpellType getSpellType() {
        return SpellType.VOID;
    }

    @Override
    public List<Enchantment> acceptedEnchantments() {
        ArrayList<Enchantment> list = new ArrayList<Enchantment>();
        list.add((Enchantment)ModEnchantments.RANGE.get());
        list.add((Enchantment)ModEnchantments.DURATION.get());
        return list;
    }

    @Override
    public boolean rightBlock(ServerLevel worldIn, LivingEntity caster, BlockPos target, Direction direction, SpellStat spellStat) {
        BlockState blockState = worldIn.m_8055_(target);
        BlockState blockState2 = worldIn.m_8055_(target.m_121945_(direction));
        return !blockState.m_155947_() && blockState2.m_60734_() != ModBlocks.HOLE.get() && !blockState.m_204336_(ModTags.Blocks.TUNNEL_BLACKLIST) && blockState.m_60800_((BlockGetter)worldIn, target) != -1.0f;
    }

    @Override
    public void blockResult(ServerLevel worldIn, LivingEntity caster, ItemStack staff, BlockPos target, Direction direction, SpellStat spellStat) {
        BlockState blockState;
        BlockHitResult blockHitResult = MobUtil.rayTrace((Entity)caster, 8.0, false);
        BlockPos blockPos = new BlockPos((Vec3i)blockHitResult.m_82425_());
        int totalDistance = spellStat.getRange();
        int extraLife = spellStat.getDuration();
        if (WandUtil.enchantedFocus(caster)) {
            totalDistance += WandUtil.getLevels((Enchantment)ModEnchantments.RANGE.get(), caster);
            extraLife += WandUtil.getLevels((Enchantment)ModEnchantments.DURATION.get(), caster);
        }
        for (int distance = 0; distance < totalDistance && !(blockState = worldIn.m_8055_(blockPos)).m_204336_(ModTags.Blocks.TUNNEL_BLACKLIST) && blockState.m_60819_().m_76178_() && blockState.m_60734_() != ModBlocks.HOLE.get() && !blockState.m_60795_() && blockState.m_60800_((BlockGetter)worldIn, blockPos) != -1.0f; ++distance) {
            blockPos = blockPos.m_121945_(direction.m_122424_());
        }
        TunnelSpell.createHole((Level)worldIn, blockHitResult.m_82425_(), direction, (byte)Math.round(totalDistance + 1), this.rightStaff(staff), (Integer)SpellConfig.TunnelDefaultLifespan.get() + extraLife * 20);
        this.playSound(worldIn, (Entity)caster, (SoundEvent)ModSounds.CAST_SPELL.get());
    }

    public static boolean createHole(Level world, BlockPos blockPos, Direction direction, int count, boolean staff, int lifespan) {
        HoleBlockEntity newHole;
        BlockState blockState = world.m_8055_(blockPos);
        if (!world.f_46443_ && world.m_7702_(blockPos) == null && !blockState.m_204336_(ModTags.Blocks.TUNNEL_BLACKLIST) && blockState.m_60819_().m_76178_() && blockState.m_60734_() != ModBlocks.HOLE.get() && blockState.m_60800_((BlockGetter)world, blockPos) != -1.0f && world.m_46597_(blockPos, ((Block)ModBlocks.HOLE.get()).m_49966_()) && (newHole = (HoleBlockEntity)world.m_7702_(blockPos)) != null) {
            newHole.setStats(blockState, lifespan, count, staff ? 5 : 3, direction);
            return true;
        }
        return false;
    }
}

