/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.magic.spells.void_spells;

import com.Polarice3.Goety.api.magic.SpellType;
import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.common.entities.projectiles.VoidShockBomb;
import com.Polarice3.Goety.common.magic.Spell;
import com.Polarice3.Goety.common.magic.SpellStat;
import com.Polarice3.Goety.config.SpellConfig;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.WandUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class VoidBombSpell
extends Spell {
    @Override
    public SpellStat defaultStats() {
        return super.defaultStats().setVelocity(1.0f);
    }

    @Override
    public int defaultSoulCost() {
        return (Integer)SpellConfig.VoidBombCost.get();
    }

    @Override
    public int defaultCastDuration() {
        return (Integer)SpellConfig.VoidBombDuration.get();
    }

    @Override
    @Nullable
    public SoundEvent CastingSound() {
        return (SoundEvent)ModSounds.VOID_PREPARE_SPELL.get();
    }

    @Override
    public int defaultSpellCooldown() {
        return (Integer)SpellConfig.VoidBombCoolDown.get();
    }

    @Override
    public SpellType getSpellType() {
        return SpellType.VOID;
    }

    @Override
    public List<Enchantment> acceptedEnchantments() {
        ArrayList<Enchantment> list = new ArrayList<Enchantment>();
        list.add((Enchantment)ModEnchantments.POTENCY.get());
        list.add((Enchantment)ModEnchantments.VELOCITY.get());
        return list;
    }

    @Override
    public void SpellResult(ServerLevel worldIn, LivingEntity caster, ItemStack staff, SpellStat spellStat) {
        int potency = spellStat.getPotency();
        float velocity = spellStat.getVelocity();
        if (WandUtil.enchantedFocus(caster)) {
            potency += WandUtil.getLevels((Enchantment)ModEnchantments.POTENCY.get(), caster);
            velocity += (float)WandUtil.getLevels((Enchantment)ModEnchantments.VELOCITY.get(), caster) / 3.0f;
        }
        Vec3 vec3 = caster.m_20182_().m_82520_(0.0, (double)(caster.m_20206_() + 1.0f), 0.0);
        VoidShockBomb bomb = new VoidShockBomb(caster, (Level)worldIn);
        bomb.m_146884_(vec3);
        bomb.setExtraDamage(potency);
        bomb.m_37251_((Entity)caster, caster.m_146909_(), caster.m_146908_(), 0.0f, velocity, 1.0f);
        worldIn.m_7967_((Entity)bomb);
        this.playSound(worldIn, (Entity)caster, (SoundEvent)ModSounds.HEAVY_WOOSH.get(), 3.0f, caster.m_6100_());
        this.playSound(worldIn, (Entity)caster, (SoundEvent)ModSounds.TELEPORT_ORB_THROW.get(), 3.0f, caster.m_6100_() - 0.5f);
        if (this.rightStaff(staff)) {
            for (int i = 0; i < 2; ++i) {
                VoidShockBomb bomb2 = new VoidShockBomb(caster, (Level)worldIn);
                bomb2.m_146884_(vec3);
                bomb2.setExtraDamage(potency);
                bomb2.m_37251_((Entity)caster, caster.m_146909_(), caster.m_146908_(), 0.0f, velocity / 2.0f + worldIn.m_213780_().m_188501_(), 8.0f);
                worldIn.m_7967_((Entity)bomb2);
            }
        }
    }
}

