/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.magic.spells.wild;

import com.Polarice3.Goety.api.magic.SpellType;
import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.common.entities.projectiles.VineHook;
import com.Polarice3.Goety.common.magic.Spell;
import com.Polarice3.Goety.common.magic.SpellStat;
import com.Polarice3.Goety.config.SpellConfig;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.SEHelper;
import com.Polarice3.Goety.utils.WandUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class GrappleSpell
extends Spell {
    public int trueCooldown = this.defaultSpellCooldown();

    @Override
    public int defaultSoulCost() {
        return (Integer)SpellConfig.GrappleCost.get();
    }

    @Override
    public int soulCost(LivingEntity caster, ItemStack staff) {
        Player player;
        Projectile projectile;
        if (caster instanceof Player && (projectile = SEHelper.getGrappling(player = (Player)caster)) != null) {
            return 0;
        }
        return super.soulCost(caster, staff);
    }

    @Override
    public int defaultCastDuration() {
        return (Integer)SpellConfig.GrappleDuration.get();
    }

    @Override
    @Nullable
    public SoundEvent CastingSound() {
        return (SoundEvent)ModSounds.WILD_PREPARE_SPELL.get();
    }

    @Override
    public int defaultSpellCooldown() {
        return (Integer)SpellConfig.GrappleCoolDown.get();
    }

    @Override
    public int spellCooldown(LivingEntity caster) {
        return this.trueCooldown;
    }

    @Override
    public SpellType getSpellType() {
        return SpellType.WILD;
    }

    @Override
    public List<Enchantment> acceptedEnchantments() {
        ArrayList<Enchantment> list = new ArrayList<Enchantment>();
        list.add((Enchantment)ModEnchantments.VELOCITY.get());
        return list;
    }

    @Override
    public void SpellResult(ServerLevel worldIn, LivingEntity caster, ItemStack staff, SpellStat spellStat) {
        float velocity = spellStat.getVelocity();
        if (WandUtil.enchantedFocus(caster)) {
            velocity = (float)WandUtil.getLevels((Enchantment)ModEnchantments.VELOCITY.get(), caster) / 2.0f;
        }
        if (caster instanceof Player) {
            Player player = (Player)caster;
            Projectile projectile = SEHelper.getGrappling(player);
            if (projectile != null) {
                projectile.m_146870_();
                SEHelper.setGrappling(player, null);
                this.playSound(worldIn, (Entity)player, SoundEvents.f_11939_, 1.0f, 0.4f / (worldIn.m_213780_().m_188501_() * 0.4f + 0.8f));
                worldIn.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11939_, this.getSoundSource(), 1.0f, 0.4f / (worldIn.m_213780_().m_188501_() * 0.4f + 0.8f));
                this.trueCooldown = this.defaultSpellCooldown();
            } else {
                VineHook vineHook = new VineHook((Level)worldIn, player, 2.5f + velocity);
                vineHook.setStaff(this.rightStaff(staff));
                worldIn.m_7967_((Entity)vineHook);
                this.playSound(worldIn, (Entity)player, SoundEvents.f_11941_, 0.5f, 0.4f / (worldIn.m_213780_().m_188501_() * 0.4f + 0.8f));
                this.trueCooldown = 0;
            }
        }
    }
}

