/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.network.server;

import com.Polarice3.Goety.Goety;
import com.Polarice3.Goety.client.audio.LoopSoundPlayer;
import java.util.function.Supplier;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class SPlayEffectLoopSoundPacket {
    private final SoundEvent soundEvent;
    private final int entity;
    private final MobEffect effect;
    private final float volume;
    private final float pitch;

    public SPlayEffectLoopSoundPacket(Entity entity, SoundEvent soundEvent, MobEffect mobEffect, float volume, float pitch) {
        this.entity = entity.m_19879_();
        this.soundEvent = soundEvent;
        this.effect = mobEffect;
        this.volume = volume;
        this.pitch = pitch;
    }

    public SPlayEffectLoopSoundPacket(int entity, SoundEvent soundEvent, MobEffect mobEffect, float volume, float pitch) {
        this.entity = entity;
        this.soundEvent = soundEvent;
        this.effect = mobEffect;
        this.volume = volume;
        this.pitch = pitch;
    }

    public static void encode(SPlayEffectLoopSoundPacket packet, FriendlyByteBuf buffer) {
        buffer.writeInt(packet.entity);
        buffer.m_130085_(packet.soundEvent.m_11660_());
        buffer.writeInt(MobEffect.m_19459_((MobEffect)packet.effect));
        buffer.writeFloat(packet.volume);
        buffer.writeFloat(packet.pitch);
    }

    public static SPlayEffectLoopSoundPacket decode(FriendlyByteBuf buffer) {
        return new SPlayEffectLoopSoundPacket(buffer.readInt(), SoundEvent.m_262824_((ResourceLocation)buffer.m_130281_()), MobEffect.m_19453_((int)buffer.readInt()), buffer.readFloat(), buffer.readFloat());
    }

    public static void consume(SPlayEffectLoopSoundPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Level level;
            if (((NetworkEvent.Context)ctx.get()).getDirection() == NetworkDirection.PLAY_TO_CLIENT && (level = Goety.PROXY.getLevel()) instanceof ClientLevel) {
                Entity entity;
                ClientLevel clientWorld = (ClientLevel)level;
                if (packet.entity >= 0 && (entity = clientWorld.m_6815_(packet.entity)) instanceof LivingEntity) {
                    LivingEntity livingEntity = (LivingEntity)entity;
                    LoopSoundPlayer.playEffectSound(livingEntity, packet.soundEvent, packet.effect, packet.volume, packet.pitch);
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

