/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.world.features.utils;

import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public final class ModFeatureLogic {
    public static final Predicate<BlockState> IS_REPLACEABLE_AIR = state -> state.m_247087_() || state.m_60795_();

    public static boolean hasEmptyHorizontalNeighbor(LevelSimulatedReader worldReader, BlockPos pos) {
        return worldReader.m_7433_(pos.m_122012_(), IS_REPLACEABLE_AIR) || worldReader.m_7433_(pos.m_122019_(), IS_REPLACEABLE_AIR) || worldReader.m_7433_(pos.m_122024_(), IS_REPLACEABLE_AIR) || worldReader.m_7433_(pos.m_122029_(), IS_REPLACEABLE_AIR);
    }

    public static boolean hasSolidNeighbor(LevelSimulatedReader worldReader, BlockPos pos) {
        return !worldReader.m_7433_(pos.m_7495_(), IS_REPLACEABLE_AIR) || !worldReader.m_7433_(pos.m_122012_(), IS_REPLACEABLE_AIR) || !worldReader.m_7433_(pos.m_122019_(), IS_REPLACEABLE_AIR) || !worldReader.m_7433_(pos.m_122024_(), IS_REPLACEABLE_AIR) || !worldReader.m_7433_(pos.m_122029_(), IS_REPLACEABLE_AIR) || !worldReader.m_7433_(pos.m_7494_(), IS_REPLACEABLE_AIR);
    }

    public static boolean canRootGrowIn(LevelSimulatedReader worldReader, BlockPos pos) {
        if (worldReader.m_7433_(pos, IS_REPLACEABLE_AIR)) {
            return ModFeatureLogic.hasSolidNeighbor(worldReader, pos);
        }
        return worldReader.m_7433_(pos, ModFeatureLogic::worldGenReplaceable);
    }

    public static boolean worldGenReplaceable(BlockState state) {
        return (state.m_247087_() || state.m_204336_(BlockTags.f_144277_) || state.m_204336_(BlockTags.f_278411_)) && !state.m_204336_(BlockTags.f_144287_);
    }

    public static BlockPos translate(BlockPos pos, double distance, double angle, double tilt) {
        double rangle = angle * 2.0 * Math.PI;
        double rtilt = tilt * Math.PI;
        return pos.m_7918_((int)Math.round(Math.sin(rangle) * Math.sin(rtilt) * distance), (int)Math.round(Math.cos(rtilt) * distance), (int)Math.round(Math.cos(rangle) * Math.sin(rtilt) * distance));
    }

    @Deprecated
    public static BlockState randStone(RandomSource rand, int howMuch) {
        return rand.m_188503_(howMuch) >= 1 ? Blocks.f_50652_.m_49966_() : Blocks.f_50079_.m_49966_();
    }

    public static boolean isAreaClear(BlockGetter world, BlockPos min, BlockPos max) {
        for (BlockPos pos : BlockPos.m_121940_((BlockPos)min, (BlockPos)max)) {
            BlockState state = world.m_8055_(pos);
            if (state.m_247087_() || !state.m_280296_() || state.m_278721_()) continue;
            return false;
        }
        return true;
    }

    public static boolean isBlockOk(BlockState state) {
        return state.m_280296_();
    }

    public static boolean isBlockNotOk(BlockState state) {
        return state.m_278721_() || state.m_60713_(Blocks.f_50752_);
    }
}

