/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.mixin;

import com.Polarice3.Goety.api.entities.IAutoRideable;
import com.Polarice3.Goety.api.entities.IOwned;
import com.Polarice3.Goety.common.effects.GoetyEffects;
import com.Polarice3.Goety.config.MainConfig;
import com.Polarice3.Goety.init.ModTags;
import com.Polarice3.Goety.utils.LichdomHelper;
import com.Polarice3.Goety.utils.NoKnockBackDamageSource;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends Entity {
    @Shadow
    @Nullable
    private LivingEntity f_20949_;
    @Shadow
    protected int f_20889_;

    @Shadow
    public abstract boolean m_21023_(MobEffect var1);

    @Shadow
    public abstract MobType m_6336_();

    @Shadow
    public abstract float m_21233_();

    @Shadow
    public abstract boolean m_217046_();

    @Shadow
    public abstract int m_213860_();

    @Shadow
    protected abstract boolean m_6124_();

    protected LivingEntityMixin(EntityType<? extends Entity> p_20966_, Level p_20967_) {
        super(p_20966_, p_20967_);
    }

    @Inject(method={"getMobType()Lnet/minecraft/world/entity/MobType;"}, at={@At(value="HEAD")}, cancellable=true)
    public void getMobType(CallbackInfoReturnable<MobType> cir) {
        if (LichdomHelper.isLich(this)) {
            cir.setReturnValue((Object)MobType.f_21641_);
        }
    }

    @Inject(method={"dropExperience"}, at={@At(value="HEAD")})
    public void dropExperience(CallbackInfo callbackInfo) {
        Level level = this.f_19853_;
        if (level instanceof ServerLevel) {
            LivingEntity livingEntity;
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.f_20889_ <= 0 && !this.m_6124_() && (livingEntity = this.f_20949_) instanceof IOwned) {
                LivingEntity livingEntity2;
                IOwned owned = (IOwned)livingEntity;
                if (!this.m_217046_() && this.f_19853_.m_46469_().m_46207_(GameRules.f_46135_) && (livingEntity2 = owned.getMasterOwner()) instanceof Player) {
                    Player player = (Player)livingEntity2;
                    int reward = ForgeEventFactory.getExperienceDrop((LivingEntity)((LivingEntity)this), (Player)player, (int)this.m_213860_());
                    ExperienceOrb.m_147082_((ServerLevel)serverLevel, (Vec3)this.m_20182_(), (int)reward);
                }
            }
        }
    }

    @Inject(method={"canAttack(Lnet/minecraft/world/entity/LivingEntity;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    public void canAttack(LivingEntity target, CallbackInfoReturnable<Boolean> callbackInfoReturnable) {
        if (((Boolean)MainConfig.LichUndeadFriends.get()).booleanValue() && (this.m_6336_() == MobType.f_21641_ || this.m_6095_().m_204039_(ModTags.EntityTypes.LICH_NEUTRAL)) && LichdomHelper.isLich((Entity)target)) {
            if (((Boolean)MainConfig.LichPowerfulFoes.get()).booleanValue()) {
                if ((double)this.m_21233_() <= (Double)MainConfig.LichPowerfulFoesHealth.get()) {
                    callbackInfoReturnable.setReturnValue((Object)false);
                }
            } else {
                callbackInfoReturnable.setReturnValue((Object)false);
            }
        }
    }

    @Inject(method={"isSensitiveToWater"}, at={@At(value="HEAD")}, cancellable=true)
    public void isSensitiveToWater(CallbackInfoReturnable<Boolean> callbackInfoReturnable) {
        if (this.m_21023_((MobEffect)GoetyEffects.SNOW_SKIN.get())) {
            callbackInfoReturnable.setReturnValue((Object)true);
        }
    }

    @Inject(method={"randomTeleport"}, at={@At(value="HEAD")}, cancellable=true)
    public void randomTeleport(CallbackInfoReturnable<Boolean> callbackInfoReturnable) {
        if (this.m_21023_((MobEffect)GoetyEffects.ENDER_GROUND.get())) {
            callbackInfoReturnable.setReturnValue((Object)false);
        }
    }

    @Inject(method={"jumpFromGround"}, at={@At(value="HEAD")}, cancellable=true)
    public void jumpFromGround(CallbackInfo callbackInfo) {
        if (this.m_21023_((MobEffect)GoetyEffects.STUNNED.get()) || this.m_21023_((MobEffect)GoetyEffects.TANGLED.get())) {
            callbackInfo.cancel();
        }
    }

    @Inject(method={"travelRidden"}, at={@At(value="HEAD")}, cancellable=true)
    public void travelRidden(Player player, Vec3 vec3, CallbackInfo callbackInfo) {
        IAutoRideable rideable;
        LivingEntityMixin livingEntityMixin = this;
        if (livingEntityMixin instanceof IAutoRideable && (rideable = (IAutoRideable)((Object)livingEntityMixin)).isAutonomous()) {
            callbackInfo.cancel();
        }
    }

    @Inject(method={"updateInvisibilityStatus"}, at={@At(value="TAIL")})
    public void updateInvisibilityStatus(CallbackInfo callbackInfo) {
        if (this.m_21023_((MobEffect)GoetyEffects.SHADOW_WALK.get())) {
            this.m_6842_(true);
        }
    }

    @Inject(method={"isDamageSourceBlocked"}, at={@At(value="HEAD")}, cancellable=true)
    public void isDamageSourceBlocked(DamageSource damageSource, CallbackInfoReturnable<Boolean> callbackInfoReturnable) {
        Vec3 vec32;
        NoKnockBackDamageSource damageSource1;
        LivingEntity livingEntity = (LivingEntity)this;
        if (damageSource instanceof NoKnockBackDamageSource && !(damageSource1 = (NoKnockBackDamageSource)damageSource).m_269533_(DamageTypeTags.f_276146_) && livingEntity.m_21254_() && (vec32 = damageSource1.m_7270_()) != null) {
            Vec3 vec3 = livingEntity.m_20252_(1.0f);
            Vec3 vec31 = vec32.m_82505_(livingEntity.m_20182_()).m_82541_();
            vec31 = new Vec3(vec31.f_82479_, 0.0, vec31.f_82481_);
            if (vec31.m_82526_(vec3) < 0.0) {
                callbackInfoReturnable.setReturnValue((Object)true);
            }
        }
    }
}

