/*
 * Decompiled with CFR 0.152.
 */
package com.mineblock.exposuredetective.block;

import com.mineblock.exposuredetective.block.entity.BoardBlockEntity;
import com.mineblock.exposuredetective.init.ExposuredetectiveModItems;
import io.github.mortuusars.exposure.client.gui.ClientGUI;
import io.github.mortuusars.exposure.world.item.PhotographItem;
import io.github.mortuusars.exposure.world.item.util.ItemAndStack;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.fml.loading.FMLEnvironment;

public class BoardBlock
extends Block
implements EntityBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    private static final ResourceLocation PHOTOGRAPH_ID = ResourceLocation.fromNamespaceAndPath((String)"exposure", (String)"photograph");
    private static final int GRID_SIZE = 3;
    private static final Map<UUID, Selection> RED_STRING_SELECTIONS = new HashMap<UUID, Selection>();
    @Nullable
    private static Item cachedPhotographItem;

    public BoardBlock() {
        super(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(1.0f, 10.0f).noOcclusion().isRedstoneConductor((bs, br, bp) -> false).instrument(NoteBlockInstrument.BASS));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    public int getLightBlock(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 0;
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            default -> BoardBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0);
            case Direction.NORTH -> BoardBlock.box((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0);
            case Direction.EAST -> BoardBlock.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0);
            case Direction.WEST -> BoardBlock.box((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        if (context.getClickedFace().getAxis() == Direction.Axis.Y) {
            return (BlockState)super.getStateForPlacement(context).setValue((Property)FACING, (Comparable)Direction.NORTH);
        }
        return (BlockState)super.getStateForPlacement(context).setValue((Property)FACING, (Comparable)context.getClickedFace());
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue((Property)FACING)));
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BoardAction action = BoardBlock.handleInteraction(state, level, pos, player, hand, stack, hit);
        if (action == BoardAction.NONE) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        BoardAction action = BoardBlock.handleInteraction(state, level, pos, player, null, ItemStack.EMPTY, hit);
        if (action == BoardAction.NONE) {
            return InteractionResult.PASS;
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    public MenuProvider getMenuProvider(BlockState state, Level worldIn, BlockPos pos) {
        MenuProvider menuProvider;
        BlockEntity tileEntity = worldIn.getBlockEntity(pos);
        return tileEntity instanceof MenuProvider ? (menuProvider = (MenuProvider)tileEntity) : null;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new BoardBlockEntity(pos, state);
    }

    public boolean triggerEvent(BlockState state, Level world, BlockPos pos, int eventID, int eventParam) {
        super.triggerEvent(state, world, pos, eventID, eventParam);
        BlockEntity blockEntity = world.getBlockEntity(pos);
        return blockEntity != null && blockEntity.triggerEvent(eventID, eventParam);
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.getBlock() != newState.getBlock()) {
            BlockEntity blockEntity = world.getBlockEntity(pos);
            if (blockEntity instanceof BoardBlockEntity) {
                BoardBlockEntity be = (BoardBlockEntity)blockEntity;
                int removedStrings = be.removeAllConnections(world);
                BoardBlock.dropStrings(world, pos, removedStrings);
                Containers.dropContents((Level)world, (BlockPos)pos, (Container)be);
                world.updateNeighbourForOutputSignal(pos, (Block)this);
            }
            super.onRemove(state, world, pos, newState, isMoving);
        }
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState blockState, Level world, BlockPos pos) {
        BlockEntity tileentity = world.getBlockEntity(pos);
        if (tileentity instanceof BoardBlockEntity) {
            BoardBlockEntity be = (BoardBlockEntity)tileentity;
            return AbstractContainerMenu.getRedstoneSignalFromContainer((Container)be);
        }
        return 0;
    }

    private static boolean isPhotograph(ItemStack stack) {
        Item photograph = BoardBlock.resolvePhotographItem();
        return photograph != null && stack.is(photograph);
    }

    private static boolean isRedString(ItemStack stack) {
        return !stack.isEmpty() && stack.is((Item)ExposuredetectiveModItems.RED_STRING.get());
    }

    @Nullable
    private static Item resolvePhotographItem() {
        if (cachedPhotographItem == null) {
            cachedPhotographItem = BuiltInRegistries.ITEM.getOptional(PHOTOGRAPH_ID).orElse(null);
        }
        return cachedPhotographItem;
    }

    private static int getSlotFromHit(BlockState state, BlockHitResult hit) {
        Vec3 location = hit.getLocation().subtract((double)hit.getBlockPos().getX(), (double)hit.getBlockPos().getY(), (double)hit.getBlockPos().getZ());
        double horizontal = BoardBlock.getHorizontalCoordinate((Direction)state.getValue((Property)FACING), location);
        double vertical = 1.0 - BoardBlock.clamp01(location.y);
        int column = Mth.clamp((int)((int)(horizontal * 3.0)), (int)0, (int)2);
        int row = Mth.clamp((int)((int)(vertical * 3.0)), (int)0, (int)2);
        return row * 3 + column;
    }

    private static double getHorizontalCoordinate(Direction facing, Vec3 location) {
        return switch (facing) {
            case Direction.NORTH -> 1.0 - BoardBlock.clamp01(location.x);
            case Direction.SOUTH -> BoardBlock.clamp01(location.x);
            case Direction.EAST -> 1.0 - BoardBlock.clamp01(location.z);
            case Direction.WEST -> BoardBlock.clamp01(location.z);
            default -> BoardBlock.clamp01(location.x);
        };
    }

    private static double clamp01(double value) {
        return Mth.clamp((double)value, (double)0.0, (double)0.999);
    }

    private static BoardAction handleInteraction(BlockState state, Level level, BlockPos pos, Player player, @Nullable InteractionHand hand, ItemStack held, BlockHitResult hit) {
        BlockEntity entity = level.getBlockEntity(pos);
        if (!(entity instanceof BoardBlockEntity)) {
            return BoardAction.NONE;
        }
        BoardBlockEntity board = (BoardBlockEntity)entity;
        int slot = BoardBlock.getSlotFromHit(state, hit);
        if (slot < 0 || slot >= board.getContainerSize()) {
            return BoardAction.NONE;
        }
        boolean holdingPhotograph = BoardBlock.isPhotograph(held);
        boolean holdingRedString = BoardBlock.isRedString(held);
        ItemStack stored = board.getItem(slot);
        if (holdingRedString) {
            return BoardBlock.handleRedStringInteraction(state, level, pos, player, hand, board, slot);
        }
        if (holdingPhotograph && stored.isEmpty()) {
            if (!level.isClientSide) {
                ItemStack placed = held.copy();
                placed.setCount(1);
                board.setItem(slot, placed);
                board.setRotation(slot, BoardBlock.randomRotation(level));
                board.setChanged();
                BoardBlock.sync(level, pos, state);
                if (hand != null && !player.getAbilities().instabuild) {
                    held.shrink(1);
                }
            }
            return BoardAction.PLACED;
        }
        if (!stored.isEmpty()) {
            boolean emptyHand;
            boolean bl = emptyHand = hand == null || held.isEmpty();
            if (emptyHand && player.isShiftKeyDown() && board.hasConnections(slot)) {
                if (!level.isClientSide) {
                    int removed = board.clearConnections(level, slot);
                    BoardBlock.dropStrings(level, pos, removed);
                    BoardBlock.sync(level, pos, state);
                }
                return BoardAction.STRING_REMOVED;
            }
            if (BoardBlock.canRemovePhoto(player, hand, held, board, slot)) {
                if (!level.isClientSide) {
                    ItemStack extracted = stored.copy();
                    if (!player.addItem(extracted)) {
                        player.drop(extracted, false);
                    }
                    board.setItem(slot, ItemStack.EMPTY);
                    board.setRotation(slot, 0.0f);
                    board.setChanged();
                    BoardBlock.sync(level, pos, state);
                }
                return BoardAction.REMOVED;
            }
            if (level.isClientSide) {
                BoardBlock.openPhotographScreen(stored);
            }
            return BoardAction.VIEWED;
        }
        return BoardAction.NONE;
    }

    private static BoardAction handleRedStringInteraction(BlockState state, Level level, BlockPos pos, Player player, @Nullable InteractionHand hand, BoardBlockEntity board, int slot) {
        ItemStack stored = board.getItem(slot);
        if (stored.isEmpty()) {
            return BoardAction.NONE;
        }
        if (player.isShiftKeyDown()) {
            if (!level.isClientSide) {
                int removed = board.clearConnections(level, slot);
                BoardBlock.dropStrings(level, pos, removed);
                BoardBlock.sync(level, pos, state);
            }
            BoardBlock.clearSelection(player);
            return BoardAction.STRING_REMOVED;
        }
        if (level.isClientSide) {
            return BoardAction.LINKING;
        }
        Selection selection = RED_STRING_SELECTIONS.get(player.getUUID());
        if (selection == null) {
            RED_STRING_SELECTIONS.put(player.getUUID(), new Selection(pos, slot));
            return BoardAction.LINKING;
        }
        if (selection.slot() == slot) {
            BoardBlock.clearSelection(player);
            return BoardAction.LINKING;
        }
        BlockEntity otherEntity = level.getBlockEntity(selection.pos());
        if (!(otherEntity instanceof BoardBlockEntity)) {
            BoardBlock.clearSelection(player);
            return BoardAction.NONE;
        }
        BoardBlockEntity other = (BoardBlockEntity)otherEntity;
        if (board.getItem(slot).isEmpty() || other.getItem(selection.slot()).isEmpty()) {
            BoardBlock.clearSelection(player);
            return BoardAction.NONE;
        }
        if (!BoardBlock.canLinkBoards(state, board, pos, selection.pos(), other)) {
            BoardBlock.clearSelection(player);
            return BoardAction.NONE;
        }
        boolean linked = board.addConnection(slot, selection.pos(), selection.slot());
        if (linked |= other.addConnection(selection.slot(), pos, slot)) {
            BoardBlock.consumeRedString(player, hand);
            BoardBlock.sync(level, pos, state);
            BlockState otherState = other.getBlockState();
            if (otherState == null) {
                otherState = level.getBlockState(selection.pos());
            }
            BoardBlock.sync(level, selection.pos(), otherState);
        }
        BoardBlock.clearSelection(player);
        return linked ? BoardAction.LINKED : BoardAction.NONE;
    }

    private static boolean canLinkBoards(BlockState state, BoardBlockEntity first, BlockPos firstPos, BlockPos secondPos, BoardBlockEntity second) {
        if (firstPos.equals((Object)secondPos)) {
            return true;
        }
        BlockState secondState = second.getBlockState();
        if (secondState == null) {
            return false;
        }
        if (state.getValue((Property)FACING) != secondState.getValue((Property)FACING)) {
            return false;
        }
        return firstPos.distSqr((Vec3i)secondPos) < 9.0;
    }

    private static void clearSelection(Player player) {
        RED_STRING_SELECTIONS.remove(player.getUUID());
    }

    private static void sync(Level level, BlockPos pos, BlockState state) {
        level.sendBlockUpdated(pos, state, state, 2);
    }

    private static float randomRotation(Level level) {
        return level.random.nextFloat() * 10.0f - 5.0f;
    }

    private static boolean canRemovePhoto(Player player, @Nullable InteractionHand hand, ItemStack held, BoardBlockEntity board, int slot) {
        boolean emptyHand = hand == null || held.isEmpty();
        return emptyHand && player.isShiftKeyDown() && !board.hasConnections(slot) && !board.getItem(slot).isEmpty();
    }

    private static void consumeRedString(Player player, @Nullable InteractionHand hand) {
        if (hand == null || player.getAbilities().instabuild) {
            return;
        }
        ItemStack stack = player.getItemInHand(hand);
        if (!BoardBlock.isRedString(stack)) {
            return;
        }
        stack.shrink(1);
        if (stack.isEmpty()) {
            player.setItemInHand(hand, ItemStack.EMPTY);
        }
    }

    private static void dropStrings(Level level, BlockPos pos, int count) {
        if (count <= 0 || level.isClientSide) {
            return;
        }
        ItemStack drop = new ItemStack((ItemLike)ExposuredetectiveModItems.RED_STRING.get(), count);
        Containers.dropItemStack((Level)level, (double)((double)pos.getX() + 0.5), (double)((double)pos.getY() + 0.5), (double)((double)pos.getZ() + 0.5), (ItemStack)drop);
    }

    private static void openPhotographScreen(ItemStack stack) {
        if (!FMLEnvironment.dist.isClient()) {
            return;
        }
        if (!(stack.getItem() instanceof PhotographItem)) {
            return;
        }
        BoardBlock.openPhotographScreenClient(stack.copy());
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void openPhotographScreenClient(ItemStack stack) {
        ItemAndStack entry = new ItemAndStack(stack);
        ClientGUI.openPhotographScreen(List.of(entry));
    }

    private static enum BoardAction {
        NONE,
        PLACED,
        REMOVED,
        VIEWED,
        LINKING,
        LINKED,
        STRING_REMOVED;

    }

    private record Selection(BlockPos pos, int slot) {
    }
}

