/*
 * Decompiled with CFR 0.152.
 */
package com.mineblock.exposuredetective.block.entity;

import com.mineblock.exposuredetective.init.ExposuredetectiveModBlockEntities;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class BoardBlockEntity
extends RandomizableContainerBlockEntity
implements WorldlyContainer {
    private static final String ROTATION_TAG = "Rotations";
    private static final String CONNECTIONS_TAG = "Connections";
    private NonNullList<ItemStack> stacks = NonNullList.withSize((int)9, (Object)ItemStack.EMPTY);
    private final float[] rotations = new float[9];
    private final List<PhotoConnection>[] connections = this.createConnectionLists();

    public BoardBlockEntity(BlockPos position, BlockState state) {
        super((BlockEntityType)ExposuredetectiveModBlockEntities.BOARD.get(), position, state);
    }

    public void loadAdditional(CompoundTag compound, HolderLookup.Provider lookupProvider) {
        super.loadAdditional(compound, lookupProvider);
        if (!this.tryLoadLootTable(compound)) {
            this.stacks = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        }
        ContainerHelper.loadAllItems((CompoundTag)compound, this.stacks, (HolderLookup.Provider)lookupProvider);
        this.loadRotations(compound);
        this.loadConnections(compound);
    }

    public void saveAdditional(CompoundTag compound, HolderLookup.Provider lookupProvider) {
        super.saveAdditional(compound, lookupProvider);
        if (!this.trySaveLootTable(compound)) {
            ContainerHelper.saveAllItems((CompoundTag)compound, this.stacks, (HolderLookup.Provider)lookupProvider);
        }
        this.saveRotations(compound);
        this.saveConnections(compound);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider lookupProvider) {
        return this.saveWithFullMetadata(lookupProvider);
    }

    public int getContainerSize() {
        return this.stacks.size();
    }

    public boolean isEmpty() {
        for (ItemStack itemstack : this.stacks) {
            if (itemstack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public Component getDefaultName() {
        return Component.literal((String)"board");
    }

    public AbstractContainerMenu createMenu(int id, Inventory inventory) {
        return ChestMenu.threeRows((int)id, (Inventory)inventory);
    }

    public Component getDisplayName() {
        return Component.literal((String)"Board");
    }

    protected NonNullList<ItemStack> getItems() {
        return this.stacks;
    }

    protected void setItems(NonNullList<ItemStack> stacks) {
        this.stacks = stacks;
    }

    public boolean canPlaceItem(int index, ItemStack stack) {
        return true;
    }

    public int[] getSlotsForFace(Direction side) {
        return IntStream.range(0, this.getContainerSize()).toArray();
    }

    public boolean canPlaceItemThroughFace(int index, ItemStack itemstack, @Nullable Direction direction) {
        return this.canPlaceItem(index, itemstack);
    }

    public boolean canTakeItemThroughFace(int index, ItemStack itemstack, Direction direction) {
        return true;
    }

    public float getRotation(int index) {
        return index >= 0 && index < this.rotations.length ? this.rotations[index] : 0.0f;
    }

    public void setRotation(int index, float rotation) {
        if (index >= 0 && index < this.rotations.length) {
            this.rotations[index] = rotation;
            this.setChanged();
        }
    }

    public List<PhotoConnection> getConnections(int slot) {
        return slot >= 0 && slot < this.connections.length ? Collections.unmodifiableList(this.connections[slot]) : Collections.emptyList();
    }

    public boolean hasConnections(int slot) {
        return slot >= 0 && slot < this.connections.length && !this.connections[slot].isEmpty();
    }

    public boolean addConnection(int slot, BlockPos pos, int otherSlot) {
        if (!this.isValidSlot(slot)) {
            return false;
        }
        PhotoConnection connection = new PhotoConnection(pos.immutable(), otherSlot);
        if (this.connections[slot].contains(connection)) {
            return false;
        }
        this.connections[slot].add(connection);
        this.setChanged();
        return true;
    }

    public boolean removeConnection(int slot, BlockPos pos, int otherSlot) {
        if (!this.isValidSlot(slot)) {
            return false;
        }
        boolean removed = this.connections[slot].remove(new PhotoConnection(pos.immutable(), otherSlot));
        if (removed) {
            this.setChanged();
        }
        return removed;
    }

    public int clearConnections(Level level, int slot) {
        if (!this.isValidSlot(slot) || level.isClientSide) {
            return 0;
        }
        int removed = this.connections[slot].size();
        for (PhotoConnection connection : List.copyOf(this.connections[slot])) {
            this.removeConnectionFromOther(level, connection.pos(), connection.slot(), slot);
        }
        this.connections[slot].clear();
        if (removed > 0) {
            this.setChanged();
        }
        return removed;
    }

    public int removeAllConnections(Level level) {
        if (level.isClientSide) {
            return 0;
        }
        int total = 0;
        for (int slot = 0; slot < this.connections.length; ++slot) {
            total += this.clearConnections(level, slot);
        }
        return total;
    }

    private void loadRotations(CompoundTag tag) {
        Arrays.fill(this.rotations, 0.0f);
        ListTag list = tag.getList(ROTATION_TAG, 5);
        for (int i = 0; i < this.rotations.length && i < list.size(); ++i) {
            this.rotations[i] = list.getFloat(i);
        }
    }

    private void saveRotations(CompoundTag tag) {
        ListTag list = new ListTag();
        for (float rotation : this.rotations) {
            list.add((Object)FloatTag.valueOf((float)rotation));
        }
        tag.put(ROTATION_TAG, (Tag)list);
    }

    private void loadConnections(CompoundTag tag) {
        for (List<PhotoConnection> list : this.connections) {
            list.clear();
        }
        ListTag slotsTag = tag.getList(CONNECTIONS_TAG, 10);
        for (int i = 0; i < slotsTag.size(); ++i) {
            CompoundTag slotTag = slotsTag.getCompound(i);
            int slot = slotTag.getInt("Slot");
            if (!this.isValidSlot(slot)) continue;
            ListTag linkList = slotTag.getList("Links", 10);
            for (int j = 0; j < linkList.size(); ++j) {
                CompoundTag entry = linkList.getCompound(j);
                BlockPos pos = new BlockPos(entry.getInt("X"), entry.getInt("Y"), entry.getInt("Z"));
                int otherSlot = entry.getInt("Slot");
                this.connections[slot].add(new PhotoConnection(pos, otherSlot));
            }
        }
    }

    private void saveConnections(CompoundTag tag) {
        ListTag slotsTag = new ListTag();
        for (int slot = 0; slot < this.connections.length; ++slot) {
            CompoundTag slotTag = new CompoundTag();
            slotTag.putInt("Slot", slot);
            ListTag linkList = new ListTag();
            for (PhotoConnection connection : this.connections[slot]) {
                CompoundTag entry = new CompoundTag();
                entry.putInt("X", connection.pos().getX());
                entry.putInt("Y", connection.pos().getY());
                entry.putInt("Z", connection.pos().getZ());
                entry.putInt("Slot", connection.slot());
                linkList.add((Object)entry);
            }
            slotTag.put("Links", (Tag)linkList);
            slotsTag.add((Object)slotTag);
        }
        tag.put(CONNECTIONS_TAG, (Tag)slotsTag);
    }

    private boolean isValidSlot(int slot) {
        return slot >= 0 && slot < this.connections.length;
    }

    private List<PhotoConnection>[] createConnectionLists() {
        List[] lists = new List[9];
        for (int i = 0; i < lists.length; ++i) {
            lists[i] = new ArrayList();
        }
        return lists;
    }

    private void removeConnectionFromOther(Level level, BlockPos otherPos, int otherSlot, int thisSlot) {
        BoardBlockEntity other;
        if (level == null) {
            return;
        }
        BlockEntity blockEntity = level.getBlockEntity(otherPos);
        if (blockEntity instanceof BoardBlockEntity && (other = (BoardBlockEntity)blockEntity).removeConnection(otherSlot, this.getBlockPos(), thisSlot)) {
            BlockState otherState = level.getBlockState(otherPos);
            BoardBlockEntity.syncBoard(level, otherPos, otherState);
        }
    }

    private static void syncBoard(Level level, BlockPos pos, BlockState state) {
        if (level == null || state == null) {
            return;
        }
        level.sendBlockUpdated(pos, state, state, 2);
    }

    public record PhotoConnection(BlockPos pos, int slot) {
    }
}

