/*
 * Decompiled with CFR 0.152.
 */
package com.mineblock.exposuredetective.client.ink;

import com.mineblock.exposuredetective.init.ExposuredetectiveModItems;
import com.mineblock.exposuredetective.item.InkItem;
import com.mineblock.exposuredetective.network.InvisibleInkDrawPayload;
import com.mineblock.exposuredetective.util.InvisibleInkData;
import com.mojang.blaze3d.systems.RenderSystem;
import io.github.mortuusars.exposure.client.gui.component.SteppedZoom;
import io.github.mortuusars.exposure.client.gui.screen.PhotographScreen;
import io.github.mortuusars.exposure.world.item.PhotographItem;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec2;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ScreenEvent;
import net.neoforged.neoforge.network.PacketDistributor;

@OnlyIn(value=Dist.CLIENT)
@EventBusSubscriber(modid="exposuredetective", value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.GAME)
public final class PhotographInkClient {
    private static final ResourceLocation MAGNIFIER_ICON = ResourceLocation.fromNamespaceAndPath((String)"exposuredetective", (String)"textures/gui/magnifier_overlay.png");
    private static final int BASE_ICON_SIZE = 64;
    private static final double MAGNIFIER_BASE_SCALE = 1.5;
    private static final double VECTOR_EPSILON = 1.0E-5;
    private static final long TRANSIENT_DURATION_MS = 1500L;
    private static boolean drawing;
    private static boolean draggingMagnifier;
    private static double dragOffsetX;
    private static double dragOffsetY;
    private static double magnifierX;
    private static double magnifierY;
    private static Vec2 lastDrawPoint;
    private static ItemStack trackedStack;
    private static int lastKnownServerCount;
    private static final List<ClientInkMark> pendingPoints;
    private static final List<TransientInk> transientMarks;
    private static final Field X_FIELD;
    private static final Field Y_FIELD;
    private static final Field ZOOM_FIELD;

    private PhotographInkClient() {
    }

    @SubscribeEvent
    public static void onScreenOpening(ScreenEvent.Opening event) {
        if (event.getNewScreen() instanceof PhotographScreen) {
            PhotographInkClient.resetState();
        }
    }

    @SubscribeEvent
    public static void onScreenClosing(ScreenEvent.Closing event) {
        if (event.getScreen() instanceof PhotographScreen) {
            PhotographInkClient.resetState();
        }
    }

    @SubscribeEvent
    public static void onMousePressed(ScreenEvent.MouseButtonPressed.Pre event) {
        PhotographScreen screen;
        block9: {
            block8: {
                Screen screen2 = event.getScreen();
                if (!(screen2 instanceof PhotographScreen)) break block8;
                screen = (PhotographScreen)screen2;
                if (event.getButton() == 1) break block9;
            }
            return;
        }
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        if (PhotographInkClient.hasMagnifier((Player)player) && PhotographInkClient.isOverMagnifier(event.getMouseX(), event.getMouseY(), screen)) {
            PhotographInkClient.startDraggingMagnifier(event.getMouseX(), event.getMouseY());
            event.setCanceled(true);
            return;
        }
        if (!PhotographInkClient.canDraw((Player)player, screen)) {
            return;
        }
        InkProperties ink = PhotographInkClient.getInkProperties((Player)player);
        if (!ink.isValid()) {
            return;
        }
        Optional<Vec2> uv = PhotographInkClient.mouseToPhoto(screen, event.getMouseX(), event.getMouseY());
        if (uv.isEmpty()) {
            return;
        }
        PhotographInkClient.beginDrawing(screen, uv.get(), ink);
        event.setCanceled(true);
    }

    @SubscribeEvent
    public static void onMouseReleased(ScreenEvent.MouseButtonReleased.Pre event) {
        if (!(event.getScreen() instanceof PhotographScreen) || event.getButton() != 1) {
            return;
        }
        drawing = false;
        draggingMagnifier = false;
        lastDrawPoint = null;
    }

    @SubscribeEvent
    public static void onMouseDragged(ScreenEvent.MouseDragged.Pre event) {
        Screen screen = event.getScreen();
        if (!(screen instanceof PhotographScreen)) {
            return;
        }
        PhotographScreen screen2 = (PhotographScreen)screen;
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        if (draggingMagnifier) {
            PhotographInkClient.moveMagnifier(event.getMouseX(), event.getMouseY(), screen2);
            event.setCanceled(true);
            return;
        }
        if (!drawing || !PhotographInkClient.canDraw((Player)player, screen2)) {
            return;
        }
        InkProperties ink = PhotographInkClient.getInkProperties((Player)player);
        if (!ink.isValid()) {
            return;
        }
        Optional<Vec2> uv = PhotographInkClient.mouseToPhoto(screen2, event.getMouseX(), event.getMouseY());
        if (uv.isEmpty()) {
            return;
        }
        if (lastDrawPoint != null && PhotographInkClient.distanceSq(lastDrawPoint, uv.get()) < 4.0E-4f) {
            return;
        }
        PhotographInkClient.queueInkPoint(screen2, uv.get(), ink);
        event.setCanceled(true);
    }

    @SubscribeEvent
    public static void onScreenRender(ScreenEvent.Render.Post event) {
        Screen screen = event.getScreen();
        if (!(screen instanceof PhotographScreen)) {
            return;
        }
        PhotographScreen screen2 = (PhotographScreen)screen;
        GuiGraphics graphics = event.getGuiGraphics();
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        ItemStack photoStack = screen2.getCurrentPhotograph().getItemStack();
        PhotographInkClient.updateTracking(photoStack);
        PhotographInkClient.renderAlwaysVisibleInk(graphics, screen2, photoStack);
        PhotographInkClient.renderTransientInk(graphics, screen2);
        if (PhotographInkClient.hasMagnifier((Player)player)) {
            PhotographInkClient.ensureMagnifierPosition(screen2);
            PhotographInkClient.renderRevealedInk(graphics, screen2, photoStack);
            PhotographInkClient.renderMagnifierIcon(graphics, screen2);
        }
        PhotographInkClient.renderInkCursor(graphics, event.getMouseX(), event.getMouseY());
    }

    private static void renderRevealedInk(GuiGraphics graphics, PhotographScreen screen, ItemStack stack) {
        List<InkRenderMark> marks = PhotographInkClient.collectMarks(stack);
        if (marks.isEmpty()) {
            return;
        }
        double scale = PhotographInkClient.computeScale(screen);
        if (scale < 1.0E-5) {
            return;
        }
        int iconSize = PhotographInkClient.currentIconSize(screen);
        int scissorX = (int)Math.round(magnifierX);
        int scissorY = (int)Math.round(magnifierY);
        double centerX = magnifierX + (double)iconSize / 2.0;
        double centerY = magnifierY + (double)iconSize / 2.0;
        Optional<Vec2> centerUv = PhotographInkClient.mouseToPhoto(screen, centerX, centerY);
        if (centerUv.isEmpty()) {
            return;
        }
        double radius = (double)iconSize / 2.0 / scale;
        graphics.pose().pushPose();
        graphics.pose().translate(0.0f, 0.0f, 500.0f);
        graphics.enableScissor(scissorX, scissorY, scissorX + iconSize, scissorY + iconSize);
        for (InkRenderMark mark : marks) {
            if (mark.alwaysVisible()) continue;
            Vec2 uv = mark.uv();
            if ((double)Math.abs(uv.x - centerUv.get().x) > radius || (double)Math.abs(uv.y - centerUv.get().y) > radius) continue;
            Vec2 screenPos = PhotographInkClient.photoToScreen(screen, uv);
            double pixelRadius = Math.max(2.0, scale * 0.01);
            PhotographInkClient.drawPixel(graphics, screenPos, pixelRadius, mark.color() & 0xFFFFFF | 0xAA000000);
        }
        graphics.disableScissor();
        graphics.pose().popPose();
    }

    private static void renderMagnifierIcon(GuiGraphics graphics, PhotographScreen screen) {
        int size = PhotographInkClient.currentIconSize(screen);
        double scale = (double)size / 64.0;
        int x = (int)Math.round(magnifierX);
        int y = (int)Math.round(magnifierY);
        graphics.pose().pushPose();
        graphics.pose().translate((float)x, (float)y, 600.0f);
        graphics.pose().scale((float)scale, (float)scale, 1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        graphics.blit(MAGNIFIER_ICON, 0, 0, 0.0f, 0.0f, 64, 64, 64, 64);
        RenderSystem.disableBlend();
        graphics.pose().popPose();
    }

    private static void renderAlwaysVisibleInk(GuiGraphics graphics, PhotographScreen screen, ItemStack stack) {
        if (stack.isEmpty()) {
            return;
        }
        List<InkRenderMark> marks = PhotographInkClient.collectMarks(stack);
        if (marks.isEmpty()) {
            return;
        }
        double scale = PhotographInkClient.computeScale(screen);
        if (scale < 1.0E-5) {
            return;
        }
        graphics.pose().pushPose();
        graphics.pose().translate(0.0f, 0.0f, 480.0f);
        for (InkRenderMark mark : marks) {
            if (!mark.alwaysVisible()) continue;
            Vec2 screenPos = PhotographInkClient.photoToScreen(screen, mark.uv());
            double pixelRadius = Math.max(2.0, scale * 0.01);
            PhotographInkClient.drawPixel(graphics, screenPos, pixelRadius, mark.color());
        }
        graphics.pose().popPose();
    }

    private static void renderTransientInk(GuiGraphics graphics, PhotographScreen screen) {
        if (transientMarks.isEmpty()) {
            return;
        }
        double scale = PhotographInkClient.computeScale(screen);
        if (scale < 1.0E-5) {
            return;
        }
        long now = System.currentTimeMillis();
        boolean hasVisible = false;
        for (TransientInk mark2 : transientMarks) {
            if (now - mark2.createdAt() >= 1500L) continue;
            hasVisible = true;
            break;
        }
        if (!hasVisible) {
            transientMarks.clear();
            return;
        }
        graphics.pose().pushPose();
        graphics.pose().translate(0.0f, 0.0f, 490.0f);
        transientMarks.removeIf(mark -> now - mark.createdAt() >= 1500L);
        for (TransientInk mark2 : transientMarks) {
            float progress = (float)(now - mark2.createdAt()) / 1500.0f;
            progress = Mth.clamp((float)progress, (float)0.0f, (float)1.0f);
            float alpha = 1.0f - progress;
            if ((alpha *= alpha) <= 0.0f) continue;
            Vec2 screenPos = PhotographInkClient.photoToScreen(screen, mark2.uv());
            double pixelRadius = Math.max(2.0, scale * 0.012);
            int base = mark2.color();
            int color = (int)(alpha * 255.0f) << 24 | base & 0xFFFFFF;
            PhotographInkClient.drawPixel(graphics, screenPos, pixelRadius, color);
        }
        graphics.pose().popPose();
    }

    private static void ensureMagnifierPosition(PhotographScreen screen) {
        int size = PhotographInkClient.currentIconSize(screen);
        if (Double.isNaN(magnifierX) || Double.isNaN(magnifierY)) {
            magnifierX = (double)(screen.width - size) - 12.0;
            magnifierY = (double)(screen.height - size) / 2.0;
        }
        magnifierX = PhotographInkClient.clamp(magnifierX, 4.0, (double)(screen.width - size) - 4.0);
        magnifierY = PhotographInkClient.clamp(magnifierY, 4.0, (double)(screen.height - size) - 4.0);
    }

    private static void moveMagnifier(double mouseX, double mouseY, PhotographScreen screen) {
        int size = PhotographInkClient.currentIconSize(screen);
        magnifierX = PhotographInkClient.clamp(mouseX + dragOffsetX, 4.0, (double)(screen.width - size) - 4.0);
        magnifierY = PhotographInkClient.clamp(mouseY + dragOffsetY, 4.0, (double)(screen.height - size) - 4.0);
    }

    private static void startDraggingMagnifier(double mouseX, double mouseY) {
        draggingMagnifier = true;
        dragOffsetX = magnifierX - mouseX;
        dragOffsetY = magnifierY - mouseY;
    }

    private static boolean isOverMagnifier(double mouseX, double mouseY, PhotographScreen screen) {
        int size = PhotographInkClient.currentIconSize(screen);
        return mouseX >= magnifierX && mouseX <= magnifierX + (double)size && mouseY >= magnifierY && mouseY <= magnifierY + (double)size;
    }

    private static void addTransientMark(Vec2 uv, int color) {
        transientMarks.add(new TransientInk(new Vec2(uv.x, uv.y), color, System.currentTimeMillis()));
    }

    private static void beginDrawing(PhotographScreen screen, Vec2 uv, InkProperties ink) {
        drawing = true;
        PhotographInkClient.queueInkPoint(screen, uv, ink);
    }

    private static void queueInkPoint(PhotographScreen screen, Vec2 uv, InkProperties ink) {
        if (lastDrawPoint == null) {
            PhotographInkClient.submitInkPoint(screen, uv, ink);
            return;
        }
        float distance = (float)Math.sqrt(PhotographInkClient.distanceSq(lastDrawPoint, uv));
        int steps = Math.max(1, Mth.ceil((float)(distance / 0.01f)));
        for (int i = 1; i <= steps; ++i) {
            float t = (float)i / (float)steps;
            Vec2 point = new Vec2(Mth.lerp((float)t, (float)PhotographInkClient.lastDrawPoint.x, (float)uv.x), Mth.lerp((float)t, (float)PhotographInkClient.lastDrawPoint.y, (float)uv.y));
            PhotographInkClient.submitInkPoint(screen, point, ink);
        }
    }

    private static void submitInkPoint(PhotographScreen screen, Vec2 uv, InkProperties ink) {
        boolean sameItem;
        ItemStack stack = screen.getCurrentPhotograph().getItemStack();
        boolean bl = sameItem = !trackedStack.isEmpty() && ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)trackedStack);
        if (sameItem) {
            pendingPoints.add(new ClientInkMark(new Vec2(uv.x, uv.y), ink.color(), ink.alwaysVisible()));
        }
        PhotographInkClient.addTransientMark(new Vec2(uv.x, uv.y), ink.color());
        PacketDistributor.sendToServer((CustomPacketPayload)new InvisibleInkDrawPayload(InteractionHand.MAIN_HAND, uv.x, uv.y), (CustomPacketPayload[])new CustomPacketPayload[0]);
        lastDrawPoint = new Vec2(uv.x, uv.y);
        if (ink.alwaysVisible && stack.getItem() instanceof PhotographItem) {
            trackedStack = stack.copy();
        }
    }

    private static Optional<Vec2> mouseToPhoto(PhotographScreen screen, double mouseX, double mouseY) {
        double scale = PhotographInkClient.computeScale(screen);
        if (scale < 1.0E-5) {
            return Optional.empty();
        }
        double centerX = (double)screen.width / 2.0 + (double)PhotographInkClient.getOffsetX(screen);
        double centerY = (double)screen.height / 2.0 + (double)PhotographInkClient.getOffsetY(screen);
        float u = (float)((mouseX - centerX) / scale + 0.5);
        float v = (float)((mouseY - centerY) / scale + 0.5);
        if (u < 0.0f || u > 1.0f || v < 0.0f || v > 1.0f) {
            return Optional.empty();
        }
        return Optional.of(new Vec2(u, v));
    }

    private static Vec2 photoToScreen(PhotographScreen screen, Vec2 uv) {
        double scale = PhotographInkClient.computeScale(screen);
        double centerX = (double)screen.width / 2.0 + (double)PhotographInkClient.getOffsetX(screen);
        double centerY = (double)screen.height / 2.0 + (double)PhotographInkClient.getOffsetY(screen);
        float screenX = (float)((double)(uv.x - 0.5f) * scale + centerX);
        float screenY = (float)((double)(uv.y - 0.5f) * scale + centerY);
        return new Vec2(screenX, screenY);
    }

    private static double computeScale(PhotographScreen screen) {
        double zoom = PhotographInkClient.getZoom(screen);
        return (double)screen.height * 0.8 * zoom;
    }

    private static void renderInkCursor(GuiGraphics graphics, double mouseX, double mouseY) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        ItemStack ink = PhotographInkClient.findInkStack((Player)player);
        if (ink.isEmpty()) {
            return;
        }
        float scale = 1.5f;
        float size = 16.0f * scale;
        graphics.pose().pushPose();
        graphics.pose().translate((float)mouseX, (float)mouseY - size, 700.0f);
        graphics.pose().scale(scale, scale, 1.0f);
        graphics.renderItem(ink, 0, 0);
        graphics.pose().popPose();
    }

    private static int currentIconSize(PhotographScreen screen) {
        if (screen == null) {
            return (int)Math.round(96.0);
        }
        double zoom = PhotographInkClient.getZoom(screen);
        return (int)Math.max(32.0, 96.0 * zoom);
    }

    private static boolean canDraw(Player player, PhotographScreen screen) {
        if (!(player.getMainHandItem().getItem() instanceof PhotographItem)) {
            return false;
        }
        if (!PhotographInkClient.getInkProperties(player).isValid()) {
            return false;
        }
        ItemStack current = screen.getCurrentPhotograph().getItemStack();
        return ItemStack.isSameItemSameComponents((ItemStack)player.getMainHandItem(), (ItemStack)current);
    }

    private static boolean hasMagnifier(Player player) {
        return player.getMainHandItem().is((Item)ExposuredetectiveModItems.MAGNIFIER.get()) || player.getOffhandItem().is((Item)ExposuredetectiveModItems.MAGNIFIER.get());
    }

    private static void updateTracking(ItemStack stack) {
        if (stack.isEmpty()) {
            trackedStack = ItemStack.EMPTY;
            lastKnownServerCount = 0;
            pendingPoints.clear();
            transientMarks.clear();
            return;
        }
        boolean same = !trackedStack.isEmpty() && ItemStack.isSameItemSameComponents((ItemStack)trackedStack, (ItemStack)stack);
        int serverCount = InvisibleInkData.count(stack);
        if (!same) {
            trackedStack = stack.copy();
            lastKnownServerCount = serverCount;
            pendingPoints.clear();
            transientMarks.clear();
            return;
        }
        if (serverCount != lastKnownServerCount) {
            lastKnownServerCount = serverCount;
            trackedStack = stack.copy();
            pendingPoints.clear();
        }
    }

    private static void resetState() {
        drawing = false;
        draggingMagnifier = false;
        lastDrawPoint = null;
        trackedStack = ItemStack.EMPTY;
        pendingPoints.clear();
        transientMarks.clear();
        lastKnownServerCount = 0;
        magnifierX = Double.NaN;
        magnifierY = Double.NaN;
    }

    private static double clamp(double value, double min, double max) {
        return Math.max(min, Math.min(max, value));
    }

    private static Field findField(String name) {
        try {
            Field field = PhotographScreen.class.getDeclaredField(name);
            field.setAccessible(true);
            return field;
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalStateException("Unable to access PhotographScreen field: " + name, e);
        }
    }

    private static float getOffsetX(PhotographScreen screen) {
        try {
            return X_FIELD.getFloat(screen);
        }
        catch (IllegalAccessException e) {
            return 0.0f;
        }
    }

    private static float getOffsetY(PhotographScreen screen) {
        try {
            return Y_FIELD.getFloat(screen);
        }
        catch (IllegalAccessException e) {
            return 0.0f;
        }
    }

    private static double getZoom(PhotographScreen screen) {
        try {
            SteppedZoom zoom = (SteppedZoom)ZOOM_FIELD.get(screen);
            return zoom != null ? zoom.get() : 1.0;
        }
        catch (IllegalAccessException e) {
            return 1.0;
        }
    }

    private static float distanceSq(Vec2 first, Vec2 second) {
        float dx = first.x - second.x;
        float dy = first.y - second.y;
        return dx * dx + dy * dy;
    }

    private static void drawPixel(GuiGraphics graphics, Vec2 screenPos, double radius, int color) {
        int left = (int)Math.round((double)screenPos.x - radius);
        int top = (int)Math.round((double)screenPos.y - radius);
        int right = (int)Math.round((double)screenPos.x + radius);
        int bottom = (int)Math.round((double)screenPos.y + radius);
        graphics.fill(left, top, right, bottom, color);
    }

    private static List<InkRenderMark> collectMarks(ItemStack stack) {
        if (stack.isEmpty()) {
            return Collections.emptyList();
        }
        List<InvisibleInkData.InkMark> stored = InvisibleInkData.getMarks(stack);
        ArrayList<InkRenderMark> marks = new ArrayList<InkRenderMark>(stored.size() + pendingPoints.size());
        for (InvisibleInkData.InkMark mark : stored) {
            marks.add(new InkRenderMark(mark.uv(), mark.color(), mark.alwaysVisible()));
        }
        if (!trackedStack.isEmpty() && ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)trackedStack)) {
            for (ClientInkMark pending : pendingPoints) {
                marks.add(new InkRenderMark(pending.uv(), pending.color(), pending.alwaysVisible()));
            }
        }
        return marks;
    }

    private static InkProperties getInkProperties(Player player) {
        ItemStack stack = player.getOffhandItem();
        Item item = stack.getItem();
        if (item instanceof InkItem) {
            InkItem ink = (InkItem)item;
            return new InkProperties(stack, ink.getColor(), ink.isAlwaysVisible());
        }
        return InkProperties.EMPTY;
    }

    private static ItemStack findInkStack(Player player) {
        ItemStack offhand = player.getOffhandItem();
        return offhand.getItem() instanceof InkItem ? offhand : ItemStack.EMPTY;
    }

    static {
        magnifierX = Double.NaN;
        magnifierY = Double.NaN;
        trackedStack = ItemStack.EMPTY;
        pendingPoints = new ArrayList<ClientInkMark>();
        transientMarks = new ArrayList<TransientInk>();
        X_FIELD = PhotographInkClient.findField("x");
        Y_FIELD = PhotographInkClient.findField("y");
        ZOOM_FIELD = PhotographInkClient.findField("zoom");
    }

    private record InkProperties(ItemStack stack, int color, boolean alwaysVisible) {
        private static final InkProperties EMPTY = new InkProperties(ItemStack.EMPTY, 0, false);

        boolean isValid() {
            return !this.stack.isEmpty();
        }
    }

    private record InkRenderMark(Vec2 uv, int color, boolean alwaysVisible) {
    }

    private record TransientInk(Vec2 uv, int color, long createdAt) {
    }

    private record ClientInkMark(Vec2 uv, int color, boolean alwaysVisible) {
    }
}

