/*
 * Decompiled with CFR 0.152.
 */
package com.mineblock.exposuredetective.client.render;

import com.mineblock.exposuredetective.block.BoardBlock;
import com.mineblock.exposuredetective.block.entity.BoardBlockEntity;
import com.mineblock.exposuredetective.util.InvisibleInkData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import io.github.mortuusars.exposure.ExposureClient;
import io.github.mortuusars.exposure.client.render.texture.TextureRenderer;
import io.github.mortuusars.exposure.world.item.AgedPhotographItem;
import io.github.mortuusars.exposure.world.item.PhotographItem;
import java.util.List;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector4f;

public class BoardBlockEntityRenderer
implements BlockEntityRenderer<BoardBlockEntity> {
    private static final int GRID_SIZE = 3;
    private static final float BOARD_MARGIN = 0.0625f;
    private static final float BOARD_SURFACE = 0.0625f;
    private static final float SURFACE_CLEARANCE = 5.0E-4f;
    private static final float SLOT_PADDING = 0.03125f;
    private static final float PHOTO_TEXTURE_INSET = 0.015625f;
    private static final float PHOTO_EXTRA_INSET = 0.0078125f;
    private static final float PHOTO_LAYER_OFFSET = 3.0E-4f;
    private static final float OVERLAY_LAYER_OFFSET = 4.0E-4f;
    private static final float INK_LAYER_OFFSET = 1.0E-4f;
    private static final float STRING_LAYER_OFFSET = 0.0015f;
    private static final float STRING_PIXEL = 0.0625f;
    private static final float PHOTO_SIZE_SCALE = 0.94f;
    private static final double VECTOR_EPSILON = 1.0E-6;
    private static final ResourceLocation OVERLAY_PHOTOGRAPH = ResourceLocation.fromNamespaceAndPath((String)"exposure", (String)"textures/photograph/photograph.png");
    private static final ResourceLocation OVERLAY_AGED = ResourceLocation.fromNamespaceAndPath((String)"exposure", (String)"textures/photograph/aged_photograph.png");
    private static final ResourceLocation WHITE_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/misc/white.png");

    public BoardBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(BoardBlockEntity entity, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        if (entity == null || entity.isRemoved()) {
            return;
        }
        Direction facing = (Direction)entity.getBlockState().getValue((Property)BoardBlock.FACING);
        poseStack.pushPose();
        this.orientToFacing(poseStack, facing);
        poseStack.translate(0.0, 0.0, (double)0.063f);
        for (int slot = 0; slot < entity.getContainerSize(); ++slot) {
            ItemStack stack = entity.getItem(slot);
            if (stack.isEmpty()) continue;
            this.renderSlot(entity, stack, slot, poseStack, buffer, packedLight, packedOverlay);
        }
        poseStack.popPose();
        this.renderConnections(entity, poseStack, buffer);
    }

    private void orientToFacing(PoseStack poseStack, Direction facing) {
        poseStack.translate(0.5, 0.5, 0.5);
        poseStack.mulPose(Axis.YP.rotationDegrees(-facing.toYRot()));
        poseStack.translate(-0.5, -0.5, -0.5);
    }

    private void renderSlot(BoardBlockEntity entity, ItemStack stack, int slot, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        int row = slot / 3;
        int column = slot % 3;
        float cellSize = 0.29166666f;
        float overlaySize = Math.max(cellSize - 0.03125f, 0.01f);
        float photoSize = Math.max(overlaySize - 0.015625f - 0.0078125f, 0.01f) * 0.94f;
        float x = 0.0625f + (float)column * cellSize;
        float y = 0.0625f + (float)row * cellSize;
        float rotation = entity.getRotation(slot);
        poseStack.pushPose();
        poseStack.translate(x + cellSize / 2.0f, 1.0f - (y + cellSize / 2.0f), 0.0f);
        poseStack.mulPose(Axis.XP.rotationDegrees(180.0f));
        poseStack.mulPose(Axis.ZP.rotationDegrees(rotation));
        this.renderPhotographLayer(stack, poseStack, buffer, packedLight, photoSize);
        this.renderOverlayLayer(stack, poseStack, buffer, packedLight, overlaySize);
        this.renderInkLayer(stack, poseStack, buffer, packedLight, photoSize);
        poseStack.popPose();
    }

    private void renderPhotographLayer(ItemStack stack, PoseStack poseStack, MultiBufferSource buffer, int packedLight, float cellSize) {
        if (!(stack.getItem() instanceof PhotographItem)) {
            return;
        }
        poseStack.pushPose();
        poseStack.translate(0.0, 0.0, (double)3.0E-4f);
        poseStack.scale(cellSize, cellSize, 1.0f);
        poseStack.translate(-0.5f, -0.5f, 0.0f);
        ExposureClient.photographRenderer().render(stack, false, false, poseStack, buffer, packedLight);
        poseStack.popPose();
    }

    private void renderOverlayLayer(ItemStack stack, PoseStack poseStack, MultiBufferSource buffer, int packedLight, float cellSize) {
        ResourceLocation overlay = this.getOverlay(stack);
        if (overlay == null) {
            return;
        }
        poseStack.pushPose();
        poseStack.translate(0.0, 0.0, (double)4.0E-4f);
        poseStack.scale(cellSize, cellSize, 1.0f);
        poseStack.translate(-0.5f, -0.5f, 0.0f);
        TextureRenderer.render((PoseStack)poseStack, (MultiBufferSource)buffer, (ResourceLocation)overlay, (int)packedLight, (int)255, (int)255, (int)255, (int)255);
        poseStack.popPose();
    }

    private void renderInkLayer(ItemStack stack, PoseStack poseStack, MultiBufferSource buffer, int packedLight, float cellSize) {
        if (stack.isEmpty()) {
            return;
        }
        List<InvisibleInkData.InkMark> marks = InvisibleInkData.getMarks(stack);
        if (marks.isEmpty()) {
            return;
        }
        poseStack.pushPose();
        poseStack.translate(0.0, 0.0, (double)1.0E-4f);
        poseStack.scale(cellSize, cellSize, 1.0f);
        poseStack.translate(-0.5f, -0.5f, 0.0f);
        PoseStack.Pose pose = poseStack.last();
        Matrix4f matrix = pose.pose();
        VertexConsumer consumer = buffer.getBuffer(RenderType.entityTranslucent((ResourceLocation)WHITE_TEXTURE));
        float pixelSize = 0.04f;
        float half = pixelSize / 2.0f;
        for (InvisibleInkData.InkMark mark : marks) {
            if (!mark.alwaysVisible()) continue;
            float left = mark.uv().x - half;
            float right = mark.uv().x + half;
            float top = mark.uv().y - half;
            float bottom = mark.uv().y + half;
            this.drawInkQuad(consumer, matrix, left, top, right, bottom, mark.color(), packedLight);
        }
        poseStack.popPose();
    }

    private void renderConnections(BoardBlockEntity entity, PoseStack poseStack, MultiBufferSource buffer) {
        Level level = entity.getLevel();
        if (level == null) {
            return;
        }
        float overlaySize = Math.max(0.26041666f, 0.01f);
        BlockPos origin = entity.getBlockPos();
        poseStack.pushPose();
        poseStack.translate((float)(-origin.getX()), (float)(-origin.getY()), (float)(-origin.getZ()));
        PoseStack.Pose pose = poseStack.last();
        VertexConsumer consumer = buffer.getBuffer(RenderType.entityTranslucent((ResourceLocation)WHITE_TEXTURE));
        int light = LightTexture.pack((int)15, (int)15);
        for (int slot = 0; slot < entity.getContainerSize(); ++slot) {
            AnchorPoint start;
            if (entity.getItem(slot).isEmpty() || (start = this.getAnchor(entity, slot, overlaySize)) == null) continue;
            for (BoardBlockEntity.PhotoConnection connection : entity.getConnections(slot)) {
                AnchorPoint end;
                BoardBlockEntity other;
                if (!this.shouldRenderConnection(origin, slot, connection.pos(), connection.slot()) || (other = this.getBoardEntity(level, connection.pos())) == null || other.getItem(connection.slot()).isEmpty() || (end = this.getAnchor(other, connection.slot(), overlaySize)) == null) continue;
                this.drawString(pose, consumer, start, end, light);
            }
        }
        poseStack.popPose();
    }

    private void drawString(PoseStack.Pose pose, VertexConsumer consumer, AnchorPoint start, AnchorPoint end, int light) {
        Vec3 startPos = start.position();
        Vec3 endPos = end.position();
        Vec3 diff = endPos.subtract(startPos);
        double length = diff.length();
        if (length < 1.0E-6) {
            return;
        }
        Vec3 tangent = diff.normalize();
        Vec3 planeNormal = start.normal().normalize();
        Vec3 side = planeNormal.cross(tangent);
        if (side.lengthSqr() < 1.0E-6) {
            side = this.orthogonalVector(planeNormal);
        }
        side = side.normalize();
        Vec3 step = tangent.scale(0.0625);
        int segments = Math.max(1, (int)Math.ceil(length / 0.0625));
        Vec3 current = startPos;
        for (int i = 0; i < segments; ++i) {
            this.renderPixel(pose, consumer, current, tangent, side, planeNormal, light);
            current = current.add(step);
        }
    }

    private void renderPixel(PoseStack.Pose pose, VertexConsumer consumer, Vec3 center, Vec3 tangent, Vec3 side, Vec3 planeNormal, int light) {
        Vec3 halfForward = tangent.scale(0.03125);
        Vec3 halfSide = side.scale(0.03125);
        Vec3 v0 = center.subtract(halfForward).subtract(halfSide);
        Vec3 v1 = center.add(halfForward).subtract(halfSide);
        Vec3 v2 = center.add(halfForward).add(halfSide);
        Vec3 v3 = center.subtract(halfForward).add(halfSide);
        this.emitQuad(consumer, pose, v0, v1, v2, v3, planeNormal, light);
        this.emitQuad(consumer, pose, v3, v2, v1, v0, planeNormal.scale(-1.0), light);
    }

    private void emitQuad(VertexConsumer consumer, PoseStack.Pose pose, Vec3 v0, Vec3 v1, Vec3 v2, Vec3 v3, Vec3 normal, int light) {
        this.emitVertex(consumer, pose, v0, normal, light, 0.0f, 0.0f);
        this.emitVertex(consumer, pose, v1, normal, light, 1.0f, 0.0f);
        this.emitVertex(consumer, pose, v2, normal, light, 1.0f, 1.0f);
        this.emitVertex(consumer, pose, v3, normal, light, 0.0f, 1.0f);
    }

    private void emitVertex(VertexConsumer consumer, PoseStack.Pose pose, Vec3 position, Vec3 normal, int light, float u, float v) {
        consumer.addVertex(pose, (float)position.x, (float)position.y, (float)position.z).setColor(255, 0, 0, 255).setUv(u, v).setUv1(0, 0).setUv2(light & 0xFFFF, light >> 16).setNormal(pose, (float)normal.x, (float)normal.y, (float)normal.z);
    }

    private Vec3 orthogonalVector(Vec3 direction) {
        Vec3 reference = Math.abs(direction.x) < 0.5 ? new Vec3(1.0, 0.0, 0.0) : new Vec3(0.0, 1.0, 0.0);
        Vec3 orthogonal = direction.cross(reference);
        if (orthogonal.lengthSqr() < 1.0E-6) {
            reference = new Vec3(0.0, 0.0, 1.0);
            orthogonal = direction.cross(reference);
        }
        return orthogonal.normalize();
    }

    private void drawInkQuad(VertexConsumer consumer, Matrix4f poseMatrix, float left, float top, float right, float bottom, int argb, int light) {
        float adjLeft = left;
        float adjRight = right;
        float adjTop = top;
        float adjBottom = bottom;
        int a = argb >> 24 & 0xFF;
        int r = argb >> 16 & 0xFF;
        int g = argb >> 8 & 0xFF;
        int b = argb & 0xFF;
        consumer.addVertex(poseMatrix, adjLeft, adjBottom, 0.0f).setColor(r, g, b, a).setUv(0.0f, 0.0f).setUv1(0, 0).setUv2(light & 0xFFFF, light >> 16).setNormal(0.0f, 0.0f, 1.0f);
        consumer.addVertex(poseMatrix, adjRight, adjBottom, 0.0f).setColor(r, g, b, a).setUv(1.0f, 0.0f).setUv1(0, 0).setUv2(light & 0xFFFF, light >> 16).setNormal(0.0f, 0.0f, 1.0f);
        consumer.addVertex(poseMatrix, adjRight, adjTop, 0.0f).setColor(r, g, b, a).setUv(1.0f, 1.0f).setUv1(0, 0).setUv2(light & 0xFFFF, light >> 16).setNormal(0.0f, 0.0f, 1.0f);
        consumer.addVertex(poseMatrix, adjLeft, adjTop, 0.0f).setColor(r, g, b, a).setUv(0.0f, 1.0f).setUv1(0, 0).setUv2(light & 0xFFFF, light >> 16).setNormal(0.0f, 0.0f, 1.0f);
    }

    private AnchorPoint getAnchor(BoardBlockEntity entity, int slot, float overlaySize) {
        Level level = entity.getLevel();
        if (level == null) {
            return null;
        }
        PoseStack stack = new PoseStack();
        BlockPos pos = entity.getBlockPos();
        stack.translate((float)pos.getX(), (float)pos.getY(), (float)pos.getZ());
        this.orientToFacing(stack, (Direction)entity.getBlockState().getValue((Property)BoardBlock.FACING));
        stack.translate(0.0, 0.0, (double)0.063f);
        float cellSize = 0.29166666f;
        float x = 0.0625f + (float)(slot % 3) * cellSize;
        float y = 0.0625f + (float)(slot / 3) * cellSize;
        stack.translate(x + cellSize / 2.0f, 1.0f - (y + cellSize / 2.0f), 0.0f);
        stack.mulPose(Axis.XP.rotationDegrees(180.0f));
        stack.mulPose(Axis.ZP.rotationDegrees(entity.getRotation(slot)));
        stack.translate(0.0, 0.0, (double)4.0E-4f);
        stack.scale(overlaySize, overlaySize, 1.0f);
        stack.translate(-0.5f, -0.5f, 0.0f);
        Vector4f vector = new Vector4f(0.5f, 0.0f, 0.0f, 1.0f);
        vector.mul((Matrix4fc)stack.last().pose());
        Vec3 normal = this.getSurfaceNormal(entity);
        Vec3 anchor = new Vec3((double)vector.x(), (double)vector.y(), (double)vector.z()).add(normal.scale((double)0.0015f));
        return new AnchorPoint(anchor, normal);
    }

    private Vec3 getSurfaceNormal(BoardBlockEntity entity) {
        BlockState state = entity.getBlockState();
        Direction facing = state != null ? (Direction)state.getValue((Property)BoardBlock.FACING) : Direction.NORTH;
        Vec3 normal = Vec3.atLowerCornerOf((Vec3i)facing.getNormal());
        double length = normal.length();
        return length < 1.0E-6 ? Vec3.ZERO : normal.scale(1.0 / length);
    }

    private boolean shouldRenderConnection(BlockPos current, int slot, BlockPos other, int otherSlot) {
        int comparison = current.compareTo((Vec3i)other);
        if (comparison < 0) {
            return true;
        }
        if (comparison > 0) {
            return false;
        }
        return slot < otherSlot;
    }

    private BoardBlockEntity getBoardEntity(Level level, BlockPos pos) {
        BoardBlockEntity board;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        return blockEntity instanceof BoardBlockEntity ? (board = (BoardBlockEntity)blockEntity) : null;
    }

    private ResourceLocation getOverlay(ItemStack stack) {
        if (stack.getItem() instanceof AgedPhotographItem) {
            return OVERLAY_AGED;
        }
        if (stack.getItem() instanceof PhotographItem) {
            return OVERLAY_PHOTOGRAPH;
        }
        return null;
    }

    private record AnchorPoint(Vec3 position, Vec3 normal) {
    }
}

