/*
 * Decompiled with CFR 0.152.
 */
package com.mineblock.exposuredetective.network;

import com.mineblock.exposuredetective.item.InkItem;
import com.mineblock.exposuredetective.util.InvisibleInkData;
import io.github.mortuusars.exposure.world.item.PhotographItem;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record InvisibleInkDrawPayload(InteractionHand hand, float u, float v) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<InvisibleInkDrawPayload> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"exposuredetective", (String)"ink_draw"));
    public static final StreamCodec<FriendlyByteBuf, InvisibleInkDrawPayload> STREAM_CODEC = StreamCodec.of(InvisibleInkDrawPayload::encode, InvisibleInkDrawPayload::decode);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    private static void encode(FriendlyByteBuf buf, InvisibleInkDrawPayload payload) {
        buf.writeEnum((Enum)payload.hand);
        buf.writeFloat(payload.u);
        buf.writeFloat(payload.v);
    }

    private static InvisibleInkDrawPayload decode(FriendlyByteBuf buf) {
        InteractionHand hand = (InteractionHand)buf.readEnum(InteractionHand.class);
        float u = buf.readFloat();
        float v = buf.readFloat();
        return new InvisibleInkDrawPayload(hand, u, v);
    }

    public static void handle(InvisibleInkDrawPayload payload, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player player = context.player();
            if (player == null) {
                return;
            }
            ItemStack inkStack = player.getOffhandItem();
            Item patt0$temp = inkStack.getItem();
            if (!(patt0$temp instanceof InkItem)) {
                return;
            }
            InkItem inkItem = (InkItem)patt0$temp;
            ItemStack photo = player.getItemInHand(payload.hand());
            if (!(photo.getItem() instanceof PhotographItem)) {
                return;
            }
            InvisibleInkData.addMark(photo, payload.u(), payload.v(), inkItem.getColor(), inkItem.isAlwaysVisible());
        });
    }
}

