/*
 * Decompiled with CFR 0.152.
 */
package com.mineblock.exposuredetective.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.phys.Vec2;

public final class InvisibleInkData {
    private static final String INK_TAG = "exposuredetective:invisible_ink";
    private static final String X_KEY = "X";
    private static final String Y_KEY = "Y";
    private static final String COLOR_KEY = "Color";
    private static final String VISIBLE_KEY = "Visible";
    private static final int MAX_POINTS = 2048;

    private InvisibleInkData() {
    }

    public static List<InkMark> getMarks(ItemStack stack) {
        if (stack == null || stack.isEmpty()) {
            return Collections.emptyList();
        }
        CustomData data = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
        if (data == null || data.isEmpty()) {
            return Collections.emptyList();
        }
        CompoundTag tag = data.copyTag();
        if (!tag.contains(INK_TAG, 9)) {
            return Collections.emptyList();
        }
        ListTag list = tag.getList(INK_TAG, 10);
        ArrayList<InkMark> points = new ArrayList<InkMark>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag entry = list.getCompound(i);
            float x = InvisibleInkData.clamp01(entry.getFloat(X_KEY));
            float y = InvisibleInkData.clamp01(entry.getFloat(Y_KEY));
            int color = entry.contains(COLOR_KEY) ? entry.getInt(COLOR_KEY) : -10040065;
            boolean visible = entry.contains(VISIBLE_KEY) && entry.getBoolean(VISIBLE_KEY);
            points.add(new InkMark(new Vec2(x, y), color, visible));
        }
        return points;
    }

    public static int count(ItemStack stack) {
        CustomData data = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
        if (data == null || data.isEmpty()) {
            return 0;
        }
        CompoundTag tag = data.copyTag();
        return tag.contains(INK_TAG, 9) ? tag.getList(INK_TAG, 10).size() : 0;
    }

    public static void addMark(ItemStack stack, float u, float v, int color, boolean alwaysVisible) {
        if (stack == null || stack.isEmpty()) {
            return;
        }
        CustomData.update((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)stack, tag -> {
            ListTag list;
            ListTag listTag = list = tag.contains(INK_TAG, 9) ? tag.getList(INK_TAG, 10) : new ListTag();
            if (list.size() >= 2048) {
                list.remove(0);
            }
            CompoundTag entry = new CompoundTag();
            entry.putFloat(X_KEY, InvisibleInkData.clamp01(u));
            entry.putFloat(Y_KEY, InvisibleInkData.clamp01(v));
            entry.putInt(COLOR_KEY, color);
            entry.putBoolean(VISIBLE_KEY, alwaysVisible);
            list.add((Object)entry);
            tag.put(INK_TAG, (Tag)list);
        });
    }

    private static float clamp01(float value) {
        if (value < 0.0f) {
            return 0.0f;
        }
        if (value > 1.0f) {
            return 1.0f;
        }
        return value;
    }

    public record InkMark(Vec2 uv, int color, boolean alwaysVisible) {
    }
}

