/*
 * Decompiled with CFR 0.152.
 */
package net.redstonegames.visitingvillagers.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.redstonegames.visitingvillagers.entity.ModEntities;
import net.redstonegames.visitingvillagers.entity.custom.BabyVisitorEntity;
import net.redstonegames.visitingvillagers.entity.custom.VisitorEntity;
import net.redstonegames.visitingvillagers.entity.custom.WanderingVisitorEntity;
import net.redstonegames.visitingvillagers.util.ModTags;

@Mod.EventBusSubscriber(modid="visitingvillagers")
public class VisitorCommands {
    @SubscribeEvent
    public static void onCommandsRegister(RegisterCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"visitors").then(Commands.literal((String)"check").executes(VisitorCommands::runCheckCommand))).then(((LiteralArgumentBuilder)Commands.literal((String)"clear").requires(source -> source.hasPermission(2))).then(Commands.argument((String)"radius", (ArgumentType)IntegerArgumentType.integer((int)1, (int)512)).executes(context -> VisitorCommands.runClearCommand((CommandContext<CommandSourceStack>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"radius")))))).then(((LiteralArgumentBuilder)Commands.literal((String)"population").requires(source -> source.hasPermission(2))).then(Commands.argument((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1, (int)250)).then(Commands.argument((String)"radius", (ArgumentType)IntegerArgumentType.integer((int)10, (int)500)).executes(context -> VisitorCommands.runPopulationCommand((CommandContext<CommandSourceStack>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"amount"), IntegerArgumentType.getInteger((CommandContext)context, (String)"radius")))))));
    }

    private static int runPopulationCommand(CommandContext<CommandSourceStack> context, int amount, int radius) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ServerPlayer player = source.getPlayerOrException();
        ServerLevel level = player.serverLevel();
        RandomSource random = level.getRandom();
        int visitorsSpawned = 0;
        int maxTriesPerVisitor = 10;
        block0: for (int i = 0; i < amount; ++i) {
            for (int tryNum = 0; tryNum < maxTriesPerVisitor; ++tryNum) {
                double z;
                int y;
                double angle = random.nextDouble() * 2.0 * Math.PI;
                double distance = Math.sqrt(random.nextDouble()) * (double)radius;
                double x = player.getX() + distance * Math.cos(angle);
                BlockPos groundPos = new BlockPos((int)x, (y = level.getHeight(Heightmap.Types.WORLD_SURFACE, (int)x, (int)(z = player.getZ() + distance * Math.sin(angle)))) - 1, (int)z);
                if (!level.getBlockState(groundPos).is(ModTags.Blocks.VISITORS_SPAWNABLE_ON)) continue;
                BlockPos spawnPos = groundPos.above();
                VisitorEntity visitor = (VisitorEntity)((EntityType)ModEntities.VISITOR.get()).create((Level)level);
                if (visitor == null || !level.noCollision(visitor.getBoundingBox().move((double)spawnPos.getX() + 0.5, (double)spawnPos.getY(), (double)spawnPos.getZ() + 0.5))) continue;
                visitor.moveTo((double)spawnPos.getX() + 0.5, spawnPos.getY(), (double)spawnPos.getZ() + 0.5, random.nextFloat() * 360.0f, 0.0f);
                visitor.finalizeSpawn((ServerLevelAccessor)level, level.getCurrentDifficultyAt(spawnPos), MobSpawnType.COMMAND, null);
                level.addFreshEntity((Entity)visitor);
                ++visitorsSpawned;
                continue block0;
            }
        }
        MutableComponent message = Component.literal((String)("\u00a7a" + visitorsSpawned + "\u00a7f visitor(s) spawned on valid blocks within a radius of \u00a7e" + radius + "\u00a7f blocks."));
        source.sendSuccess(() -> VisitorCommands.lambda$runPopulationCommand$4((Component)message), true);
        return visitorsSpawned;
    }

    private static int runCheckCommand(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ServerPlayer player = source.getPlayerOrException();
        ServerLevel level = player.serverLevel();
        AABB searchBox = new AABB(player.blockPosition()).inflate(128.0);
        List villagers = level.getEntitiesOfClass(Villager.class, searchBox, e -> true);
        List golems = level.getEntitiesOfClass(IronGolem.class, searchBox, e -> true);
        List allVisitors = level.getEntitiesOfClass(VisitorEntity.class, searchBox, e -> true);
        List wanderingVisitors = level.getEntitiesOfClass(WanderingVisitorEntity.class, searchBox, e -> true);
        ArrayList<VisitorEntity> adultVisitors = new ArrayList<VisitorEntity>();
        ArrayList<BabyVisitorEntity> babyVisitors = new ArrayList<BabyVisitorEntity>();
        for (VisitorEntity visitor : allVisitors) {
            if (visitor instanceof BabyVisitorEntity) {
                babyVisitors.add((BabyVisitorEntity)visitor);
                continue;
            }
            adultVisitors.add(visitor);
        }
        MutableComponent message = Component.literal((String)(" \u00a7bVisitor: \u00a7e" + adultVisitors.size() + "\u00a7f \u00a7aVillager: \u00a7e" + villagers.size() + "\u00a7f \u00a7bBaby: \u00a7e" + babyVisitors.size() + "\u00a7f \u00a7aGolem: \u00a7e" + golems.size() + "\u00a7f \u00a7bWander: \u00a7e" + wanderingVisitors.size() + "\u00a7f"));
        source.sendSuccess(() -> VisitorCommands.lambda$runCheckCommand$9((Component)message), false);
        return 1;
    }

    private static int runClearCommand(CommandContext<CommandSourceStack> context, int radius) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ServerPlayer player = source.getPlayerOrException();
        ServerLevel level = player.serverLevel();
        AABB searchBox = new AABB(player.blockPosition()).inflate((double)radius);
        List villageVisitors = level.getEntitiesOfClass(VisitorEntity.class, searchBox, e -> true);
        List wanderingVisitors = level.getEntitiesOfClass(WanderingVisitorEntity.class, searchBox, e -> true);
        int villageCount = villageVisitors.size();
        int wanderingCount = wanderingVisitors.size();
        int totalCount = villageCount + wanderingCount;
        villageVisitors.forEach(Entity::discard);
        wanderingVisitors.forEach(Entity::discard);
        MutableComponent message = Component.literal((String)("\u00a7c" + totalCount + "\u00a7f visitor(s) removed within a radius of \u00a7e" + radius + "\u00a7f blocks. (" + villageCount + " visitors, " + wanderingCount + " wandering)"));
        source.sendSuccess(() -> VisitorCommands.lambda$runClearCommand$12((Component)message), true);
        return totalCount;
    }

    private static /* synthetic */ Component lambda$runClearCommand$12(Component message) {
        return message;
    }

    private static /* synthetic */ Component lambda$runCheckCommand$9(Component message) {
        return message;
    }

    private static /* synthetic */ Component lambda$runPopulationCommand$4(Component message) {
        return message;
    }
}

