/*
 * Decompiled with CFR 0.152.
 */
package net.redstonegames.visitingvillagers.entity.ai;

import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.redstonegames.visitingvillagers.entity.custom.WanderingVisitorEntity;

public class DespawnAtNightGoal
extends Goal {
    private final Mob mob;
    private final Level level;
    private final double despawnDistance;
    private final boolean removeLeashedAnimals;
    private int checkCooldown;

    public DespawnAtNightGoal(Mob mob, double despawnDistance, boolean removeLeashedAnimals) {
        this.mob = mob;
        this.level = mob.level();
        this.despawnDistance = despawnDistance * despawnDistance;
        this.removeLeashedAnimals = removeLeashedAnimals;
        this.setFlags(EnumSet.noneOf(Goal.Flag.class));
    }

    public boolean canUse() {
        if (this.checkCooldown-- > 0) {
            return false;
        }
        this.checkCooldown = 40;
        return this.level.isNight() && !this.mob.isPersistenceRequired() && this.isPlayerTooFar();
    }

    public void start() {
        Mob mob;
        if (this.removeLeashedAnimals && (mob = this.mob) instanceof WanderingVisitorEntity) {
            WanderingVisitorEntity wanderingVisitor = (WanderingVisitorEntity)mob;
            wanderingVisitor.removeLeashedAnimals();
        }
        this.mob.discard();
    }

    private boolean isPlayerTooFar() {
        return this.level.getNearestPlayer((Entity)this.mob, -1.0) == null || this.level.getNearestPlayer((Entity)this.mob, -1.0).distanceToSqr((Entity)this.mob) > this.despawnDistance;
    }
}

