/*
 * Decompiled with CFR 0.152.
 */
package net.redstonegames.visitingvillagers.entity.ai;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.redstonegames.visitingvillagers.entity.custom.WanderingVisitorEntity;

public class DespawnWhenPlayerSleepsGoal
extends Goal {
    private final Mob mob;
    private static final double DESPAWN_RADIUS_SQUARED = 576.0;

    public DespawnWhenPlayerSleepsGoal(Mob mob) {
        this.mob = mob;
    }

    public boolean canUse() {
        AbstractVillager villager;
        Mob mob = this.mob;
        if (mob instanceof AbstractVillager && (villager = (AbstractVillager)mob).getTradingPlayer() != null) {
            return false;
        }
        if (this.mob.isPersistenceRequired() || this.mob.level().isClientSide()) {
            return false;
        }
        return this.mob.level().players().stream().anyMatch(player -> player.isSleeping() && this.mob.distanceToSqr((Entity)player) < 576.0);
    }

    public void start() {
        Mob mob = this.mob;
        if (mob instanceof WanderingVisitorEntity) {
            WanderingVisitorEntity wanderingVisitor = (WanderingVisitorEntity)mob;
            wanderingVisitor.removeLeashedAnimals();
        }
        this.mob.discard();
        super.start();
    }
}

