/*
 * Decompiled with CFR 0.152.
 */
package net.redstonegames.visitingvillagers.entity.ai;

import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class GoToPoiGoal
extends Goal {
    private static final double HORIZONTAL_REACH_DISTANCE_SQUARED = 4.0;
    private static final double VERTICAL_REACH_DISTANCE = 2.0;
    protected final PathfinderMob mob;
    private final Predicate<Holder<PoiType>> poiTypePredicate;
    private final int searchRadius;
    private final double speed;
    private final int chance;
    private Optional<BlockPos> targetPos = Optional.empty();
    private boolean hasReached;

    public GoToPoiGoal(PathfinderMob mob, double speed, Predicate<Holder<PoiType>> poiTypePredicate, int searchRadius, int chance) {
        this.mob = mob;
        this.speed = speed;
        this.poiTypePredicate = poiTypePredicate;
        this.searchRadius = searchRadius;
        this.chance = chance;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean canUse() {
        if (!this.mob.getNavigation().isDone()) {
            return false;
        }
        if (this.mob.getRandom().nextInt(this.chance) != 0) {
            return false;
        }
        this.findTarget();
        return this.targetPos.isPresent();
    }

    private void findTarget() {
        ServerLevel world = (ServerLevel)this.mob.level();
        PoiManager poiManager = world.getPoiManager();
        List possibleTargets = poiManager.findAll(this.poiTypePredicate, pos -> true, this.mob.blockPosition(), this.searchRadius, PoiManager.Occupancy.ANY).map(BlockPos::immutable).collect(Collectors.toList());
        this.targetPos = !possibleTargets.isEmpty() ? Optional.of((BlockPos)possibleTargets.get(this.mob.getRandom().nextInt(possibleTargets.size()))) : Optional.empty();
    }

    public void start() {
        this.hasReached = false;
        this.targetPos.ifPresent(target -> this.mob.getNavigation().moveTo((double)target.getX() + 0.5, (double)target.getY(), (double)target.getZ() + 0.5, this.speed));
    }

    public boolean canContinueToUse() {
        if (this.targetPos.isEmpty() || this.hasReached) {
            return false;
        }
        if (this.isCloseEnough(this.mob, this.targetPos.get())) {
            this.hasReached = true;
            return false;
        }
        return !this.mob.getNavigation().isDone();
    }

    private boolean isCloseEnough(PathfinderMob mob, BlockPos target) {
        Vec3 mobPos = mob.position();
        Vec3 targetCenter = Vec3.atCenterOf((Vec3i)target);
        double dx = mobPos.x - targetCenter.x;
        double dy = mobPos.y - targetCenter.y;
        double dz = mobPos.z - targetCenter.z;
        double horizontalDistanceSq = dx * dx + dz * dz;
        return horizontalDistanceSq < 4.0 && Math.abs(dy) < 2.0;
    }

    public void stop() {
        Level level = this.mob.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)level;
            if (this.hasReached) {
                serverWorld.sendParticles((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, this.mob.getX(), this.mob.getY() + (double)this.mob.getBbHeight() + 0.5, this.mob.getZ(), 5, 0.3, 0.3, 0.3, 0.0);
            } else if (this.targetPos.isPresent() && this.mob.getRandom().nextFloat() < 0.5f) {
                serverWorld.sendParticles((ParticleOptions)ParticleTypes.ANGRY_VILLAGER, this.mob.getX(), this.mob.getY() + (double)this.mob.getBbHeight() + 0.5, this.mob.getZ(), 1, 0.3, 0.3, 0.3, 0.0);
            }
        }
        this.mob.getNavigation().stop();
        this.targetPos = Optional.empty();
        this.hasReached = false;
    }
}

