/*
 * Decompiled with CFR 0.152.
 */
package net.redstonegames.visitingvillagers.entity.ai;

import java.util.ArrayList;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.ai.goal.Goal;
import net.redstonegames.visitingvillagers.entity.custom.VisitorEntity;
import net.redstonegames.visitingvillagers.util.ModTags;

public class GoToTaggedBlockGoal
extends Goal {
    private static final double REACH_DISTANCE_SQUARED = 4.0;
    private final VisitorEntity mob;
    private final double speed;
    private BlockPos targetPos;

    public GoToTaggedBlockGoal(VisitorEntity mob, double speed) {
        this.mob = mob;
        this.speed = speed;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        if (this.mob.getNavigation().isDone()) {
            return this.mob.getRandom().nextInt(120) == 0;
        }
        return false;
    }

    public void start() {
        this.findRandomTaggedBlock();
        if (this.targetPos != null) {
            this.mob.getNavigation().moveTo((double)this.targetPos.getX(), (double)this.targetPos.getY(), (double)this.targetPos.getZ(), this.speed);
        }
    }

    public boolean canContinueToUse() {
        if (this.targetPos == null) {
            return false;
        }
        double distanceSq = this.mob.distanceToSqr((double)this.targetPos.getX() + 0.5, this.targetPos.getY(), (double)this.targetPos.getZ() + 0.5);
        if (distanceSq < 4.0) {
            return false;
        }
        return !this.mob.getNavigation().isDone();
    }

    public void stop() {
        this.targetPos = null;
    }

    private void findRandomTaggedBlock() {
        this.targetPos = null;
        int searchRadius = 48;
        ArrayList<BlockPos> validTargets = new ArrayList<BlockPos>();
        for (BlockPos pos : BlockPos.betweenClosed((BlockPos)this.mob.blockPosition().offset(-searchRadius, -5, -searchRadius), (BlockPos)this.mob.blockPosition().offset(searchRadius, 5, searchRadius))) {
            if (!this.mob.level().getBlockState(pos).is(ModTags.Blocks.VISITOR_PREFERRED_BLOCKS)) continue;
            validTargets.add(pos.above());
        }
        if (!validTargets.isEmpty()) {
            this.targetPos = (BlockPos)validTargets.get(this.mob.getRandom().nextInt(validTargets.size()));
        }
    }
}

