/*
 * Decompiled with CFR 0.152.
 */
package net.redstonegames.visitingvillagers.entity.ai;

import java.util.ArrayList;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class JumpToBlockGoal
extends Goal {
    private final Mob mob;
    private final int maxJumpHeight;
    private final int horizontalRange;
    private BlockPos targetPos;
    private int prepareToJumpTicks;
    private static final int START_CHANCE = 150;
    private static final int PREPARE_TIME = 20;

    public JumpToBlockGoal(Mob mob, int maxJumpHeight, int horizontalRange) {
        this.mob = mob;
        this.maxJumpHeight = maxJumpHeight;
        this.horizontalRange = horizontalRange;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        if (!this.mob.onGround()) {
            return false;
        }
        if (this.mob.getRandom().nextInt(150) != 0) {
            return false;
        }
        this.findTargetBlock();
        return this.targetPos != null;
    }

    public boolean canContinueToUse() {
        return this.prepareToJumpTicks > 0 && this.targetPos != null;
    }

    public void start() {
        this.prepareToJumpTicks = 20;
        this.mob.getNavigation().stop();
    }

    public void stop() {
        this.prepareToJumpTicks = 0;
        this.targetPos = null;
    }

    public void tick() {
        this.mob.getLookControl().setLookAt((double)this.targetPos.getX(), (double)this.targetPos.getY(), (double)this.targetPos.getZ());
        --this.prepareToJumpTicks;
        if (this.prepareToJumpTicks == 0) {
            Vec3 targetVec = Vec3.atBottomCenterOf((Vec3i)this.targetPos);
            Vec3 mobPos = this.mob.position();
            Vec3 jumpVec = new Vec3(targetVec.x - mobPos.x, 0.0, targetVec.z - mobPos.z);
            if (jumpVec.lengthSqr() > 1.0E-7) {
                jumpVec = jumpVec.normalize().scale(0.8);
            }
            this.mob.setDeltaMovement(jumpVec.x, 0.6, jumpVec.z);
            this.mob.playSound(SoundEvents.GOAT_STEP, 1.0f, 1.0f);
        }
    }

    private void findTargetBlock() {
        Level level = this.mob.level();
        BlockPos mobPos = this.mob.blockPosition();
        ArrayList<BlockPos> possibleTargets = new ArrayList<BlockPos>();
        for (int y = 0; y <= this.maxJumpHeight; ++y) {
            for (int x = -this.horizontalRange; x <= this.horizontalRange; ++x) {
                for (int z = -this.horizontalRange; z <= this.horizontalRange; ++z) {
                    BlockPos currentPos = mobPos.offset(x, y, z);
                    if (!level.getBlockState(currentPos).isFaceSturdy((BlockGetter)level, currentPos, Direction.UP) || !level.isEmptyBlock(currentPos.above()) || !level.isEmptyBlock(currentPos.above(2))) continue;
                    possibleTargets.add(currentPos);
                }
            }
        }
        this.targetPos = !possibleTargets.isEmpty() ? (BlockPos)possibleTargets.get(this.mob.getRandom().nextInt(possibleTargets.size())) : null;
    }
}

