/*
 * Decompiled with CFR 0.152.
 */
package net.redstonegames.visitingvillagers.entity.ai;

import java.util.EnumSet;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.redstonegames.visitingvillagers.entity.custom.BabyVisitorEntity;

public class PlayWithOthersGoal
extends Goal {
    private final BabyVisitorEntity mob;
    private final double speed;
    private BabyVisitorEntity target;
    private int playTicks;
    private static final int START_CHANCE = 400;
    private static final int PLAY_DURATION_TICKS = 200;
    private static final double MAX_DISTANCE_SQUARED = 256.0;

    public PlayWithOthersGoal(BabyVisitorEntity mob, double speed) {
        this.mob = mob;
        this.speed = speed;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        if (!this.mob.isBaby()) {
            return false;
        }
        if (this.mob.getRandom().nextInt(400) != 0) {
            return false;
        }
        this.findPlaymate();
        return this.target != null;
    }

    public boolean canContinueToUse() {
        return this.target != null && this.target.isAlive() && this.playTicks > 0 && this.mob.distanceToSqr((Entity)this.target) < 256.0;
    }

    public void start() {
        this.playTicks = 200;
    }

    public void tick() {
        --this.playTicks;
        this.mob.getLookControl().setLookAt((Entity)this.target, 10.0f, (float)this.mob.getMaxHeadXRot());
        this.mob.getNavigation().moveTo((Entity)this.target, this.speed);
    }

    public void stop() {
        this.target = null;
        this.mob.getNavigation().stop();
    }

    private void findPlaymate() {
        List others;
        List list = this.mob.level().getEntitiesOfClass(BabyVisitorEntity.class, this.mob.getBoundingBox().inflate(16.0, 4.0, 16.0));
        if (!list.isEmpty() && !(others = list.stream().filter(entity -> entity != this.mob).collect(Collectors.toList())).isEmpty()) {
            this.target = (BabyVisitorEntity)((Object)others.get(this.mob.getRandom().nextInt(others.size())));
        }
    }

    public BabyVisitorEntity getTarget() {
        return this.target;
    }
}

