/*
 * Decompiled with CFR 0.152.
 */
package net.redstonegames.visitingvillagers.entity.client;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.redstonegames.visitingvillagers.entity.client.ModModelLayers;
import net.redstonegames.visitingvillagers.entity.client.VisitorModel;
import net.redstonegames.visitingvillagers.entity.custom.VisitorEntity;
import net.redstonegames.visitingvillagers.entity.variant.VisitorVariant;

public class VisitorRenderer
extends MobRenderer<VisitorEntity, VisitorModel<VisitorEntity>> {
    private static final List<ResourceLocation> GENERIC_TEXTURES = Arrays.asList(ResourceLocation.fromNamespaceAndPath((String)"visitingvillagers", (String)"textures/entity/visitor/red_npc.png"), ResourceLocation.fromNamespaceAndPath((String)"visitingvillagers", (String)"textures/entity/visitor/red_npc1.png"), ResourceLocation.fromNamespaceAndPath((String)"visitingvillagers", (String)"textures/entity/visitor/red_npc2.png"), ResourceLocation.fromNamespaceAndPath((String)"visitingvillagers", (String)"textures/entity/visitor/red_npc3.png"), ResourceLocation.fromNamespaceAndPath((String)"visitingvillagers", (String)"textures/entity/visitor/red_npc4.png"), ResourceLocation.fromNamespaceAndPath((String)"visitingvillagers", (String)"textures/entity/visitor/red_npc6.png"), ResourceLocation.fromNamespaceAndPath((String)"visitingvillagers", (String)"textures/entity/visitor/red_npc7.png"));
    private static final Map<VisitorVariant, ResourceLocation> LOCATION_BY_VARIANT = (Map)Util.make((Object)Maps.newEnumMap(VisitorVariant.class), map -> {
        map.put(VisitorVariant.TEXTURE0, ResourceLocation.fromNamespaceAndPath((String)"visitingvillagers", (String)"textures/entity/visitor/miner.png"));
        map.put(VisitorVariant.TEXTURE1, ResourceLocation.fromNamespaceAndPath((String)"visitingvillagers", (String)"textures/entity/visitor/beekeeper.png"));
        map.put(VisitorVariant.TEXTURE2, ResourceLocation.fromNamespaceAndPath((String)"visitingvillagers", (String)"textures/entity/visitor/lumberjack.png"));
        map.put(VisitorVariant.TEXTURE3, ResourceLocation.fromNamespaceAndPath((String)"visitingvillagers", (String)"textures/entity/visitor/pillager.png"));
        map.put(VisitorVariant.TEXTURE4, ResourceLocation.fromNamespaceAndPath((String)"visitingvillagers", (String)"textures/entity/visitor/glassworker.png"));
        map.put(VisitorVariant.TEXTURE5, ResourceLocation.fromNamespaceAndPath((String)"visitingvillagers", (String)"textures/entity/visitor/railwright.png"));
        map.put(VisitorVariant.TEXTURE6, ResourceLocation.fromNamespaceAndPath((String)"visitingvillagers", (String)"textures/entity/visitor/relic.png"));
        map.put(VisitorVariant.TEXTURE7, ResourceLocation.fromNamespaceAndPath((String)"visitingvillagers", (String)"textures/entity/visitor/piglin_trader.png"));
        map.put(VisitorVariant.TEXTURE8, ResourceLocation.fromNamespaceAndPath((String)"visitingvillagers", (String)"textures/entity/visitor/beach.png"));
        map.put(VisitorVariant.TEXTURE9, ResourceLocation.fromNamespaceAndPath((String)"visitingvillagers", (String)"textures/entity/visitor/enchantsmith.png"));
        map.put(VisitorVariant.TEXTURE10, ResourceLocation.fromNamespaceAndPath((String)"visitingvillagers", (String)"textures/entity/visitor/redstoneer.png"));
        map.put(VisitorVariant.TEXTURE11, ResourceLocation.fromNamespaceAndPath((String)"visitingvillagers", (String)"textures/entity/visitor/firework.png"));
        map.put(VisitorVariant.TEXTURE12, ResourceLocation.fromNamespaceAndPath((String)"visitingvillagers", (String)"textures/entity/visitor/mushroom.png"));
    });

    public VisitorRenderer(EntityRendererProvider.Context pContext) {
        super(pContext, new VisitorModel(pContext.bakeLayer(ModModelLayers.VISITOR)), 0.5f);
    }

    public ResourceLocation getTextureLocation(VisitorEntity entity) {
        if (entity.getVariant() == VisitorVariant.DEFAULT) {
            int size = GENERIC_TEXTURES.size();
            int index = Math.abs(entity.getId()) % size;
            return GENERIC_TEXTURES.get(index);
        }
        return LOCATION_BY_VARIANT.get((Object)entity.getVariant());
    }

    public void render(VisitorEntity pEntity, float pEntityYaw, float pPartialTicks, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight) {
        pPoseStack.pushPose();
        pPoseStack.scale(0.9375f, 0.9375f, 0.9375f);
        super.render((LivingEntity)pEntity, pEntityYaw, pPartialTicks, pPoseStack, pBuffer, pPackedLight);
        pPoseStack.popPose();
    }
}

