/*
 * Decompiled with CFR 0.152.
 */
package net.redstonegames.visitingvillagers.entity.custom;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveThroughVillageGoal;
import net.minecraft.world.entity.ai.goal.OpenDoorGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.redstonegames.visitingvillagers.entity.ai.DespawnAtNightGoal;
import net.redstonegames.visitingvillagers.entity.ai.DespawnWhenPlayerSleepsGoal;
import net.redstonegames.visitingvillagers.entity.ai.JumpToBlockGoal;
import net.redstonegames.visitingvillagers.entity.ai.PlayWithOthersGoal;
import net.redstonegames.visitingvillagers.entity.custom.VisitorEntity;
import net.redstonegames.visitingvillagers.entity.variant.BabyVisitorVariant;
import org.jetbrains.annotations.Nullable;

public class BabyVisitorEntity
extends VisitorEntity {
    private static final EntityDataAccessor<Integer> BABY_DATA_ID_TYPE_VARIANT = SynchedEntityData.defineId(BabyVisitorEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public BabyVisitorEntity(EntityType<? extends AbstractVillager> entityType, Level level) {
        super(entityType, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return VisitorEntity.createAttributes();
    }

    @Override
    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, Zombie.class, 15.0f, 1.4, 1.6));
        this.goalSelector.addGoal(1, (Goal)new PanicGoal((PathfinderMob)this, 1.6));
        this.goalSelector.addGoal(2, (Goal)new DespawnWhenPlayerSleepsGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new MoveThroughVillageGoal((PathfinderMob)this, 1.6, false, 4, () -> false));
        this.goalSelector.addGoal(2, (Goal)new PlayWithOthersGoal(this, 1.6));
        this.goalSelector.addGoal(2, (Goal)new JumpToBlockGoal((Mob)this, 3, 5));
        this.goalSelector.addGoal(4, (Goal)new OpenDoorGoal((Mob)this, true));
        this.goalSelector.addGoal(4, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.1));
        this.goalSelector.addGoal(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 4.0f));
        this.goalSelector.addGoal(6, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 4.0f));
        this.goalSelector.addGoal(9, (Goal)new DespawnAtNightGoal((Mob)this, 16.0, false));
    }

    public boolean isBaby() {
        return true;
    }

    @Override
    protected void updateTrades() {
    }

    @Override
    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel world, AgeableMob entity) {
        return null;
    }

    public void setAge(int age) {
    }

    @Override
    protected SoundEvent getAmbientSound() {
        return SoundEvents.VILLAGER_AMBIENT;
    }

    @Override
    protected SoundEvent getHurtSound(DamageSource source) {
        return SoundEvents.VILLAGER_HURT;
    }

    @Override
    protected SoundEvent getDeathSound() {
        return SoundEvents.VILLAGER_DEATH;
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
        pBuilder.define(BABY_DATA_ID_TYPE_VARIANT, (Object)0);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        nbt.putInt("BabyVariant", this.getBabyTypeVariant());
    }

    @Override
    public void readAdditionalSaveData(CompoundTag nbt) {
        super.readAdditionalSaveData(nbt);
        this.entityData.set(BABY_DATA_ID_TYPE_VARIANT, (Object)nbt.getInt("BabyVariant"));
    }

    @Override
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType spawnReason, @Nullable SpawnGroupData entityData) {
        BabyVisitorVariant variant = BabyVisitorVariant.getRandomVariant(this.random);
        this.setBabyVariant(variant);
        return super.finalizeSpawn(world, difficulty, spawnReason, entityData);
    }

    public BabyVisitorVariant getBabyVariant() {
        return BabyVisitorVariant.byId(this.getBabyTypeVariant() & 0xFF);
    }

    private int getBabyTypeVariant() {
        return (Integer)this.entityData.get(BABY_DATA_ID_TYPE_VARIANT);
    }

    private void setBabyVariant(BabyVisitorVariant variant) {
        this.entityData.set(BABY_DATA_ID_TYPE_VARIANT, (Object)(variant.getId() & 0xFF));
    }
}

