/*
 * Decompiled with CFR 0.152.
 */
package net.redstonegames.visitingvillagers.entity.custom;

import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.LookAtTradingPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveBackToVillageGoal;
import net.minecraft.world.entity.ai.goal.OpenDoorGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.TradeWithPlayerGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.redstonegames.visitingvillagers.entity.ModEntities;
import net.redstonegames.visitingvillagers.entity.ai.DespawnAtNightGoal;
import net.redstonegames.visitingvillagers.entity.ai.DespawnWhenPlayerSleepsGoal;
import net.redstonegames.visitingvillagers.entity.ai.GoToPoiGoal;
import net.redstonegames.visitingvillagers.entity.variant.VisitorVariant;
import net.redstonegames.visitingvillagers.sound.ModSounds;
import net.redstonegames.visitingvillagers.util.ModTags;
import net.redstonegames.visitingvillagers.util.VisitorTrades;

public class VisitorEntity
extends AbstractVillager {
    private int pricePenalty = 0;
    private PanicGoal panicGoal;
    private static final EntityDataAccessor<Integer> DATA_ID_TYPE_VARIANT = SynchedEntityData.defineId(VisitorEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public VisitorEntity(EntityType<? extends AbstractVillager> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        ((GroundPathNavigation)this.getNavigation()).setCanOpenDoors(true);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(0, (Goal)new LookAtTradingPlayerGoal((AbstractVillager)this));
        this.goalSelector.addGoal(1, (Goal)new TradeWithPlayerGoal((AbstractVillager)this));
        this.goalSelector.addGoal(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, Zombie.class, 15.0f, 1.2, 1.6));
        this.panicGoal = new PanicGoal((PathfinderMob)this, 1.8);
        this.goalSelector.addGoal(1, (Goal)this.panicGoal);
        this.goalSelector.addGoal(2, (Goal)new DespawnWhenPlayerSleepsGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new OpenDoorGoal((Mob)this, true));
        this.goalSelector.addGoal(3, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.9));
        this.goalSelector.addGoal(4, (Goal)new GoToPoiGoal((PathfinderMob)this, 1.2, poiType -> poiType.containsTag(ModTags.PointOfInterestTypes.VISITOR_PREFERRED_POIS), 32, 150));
        this.goalSelector.addGoal(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.goalSelector.addGoal(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 4.0f));
        this.goalSelector.addGoal(6, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 4.0f));
        this.goalSelector.addGoal(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(9, (Goal)new DespawnAtNightGoal((Mob)this, 24.0, false));
        this.goalSelector.addGoal(15, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.4, 150));
        this.goalSelector.addGoal(15, (Goal)new MoveBackToVillageGoal((PathfinderMob)this, 1.2, false));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 15.0).add(Attributes.MOVEMENT_SPEED, (double)0.2f).add(Attributes.ARMOR, 0.5);
    }

    public InteractionResult mobInteract(Player pPlayer, InteractionHand pHand) {
        ItemStack itemStack = pPlayer.getItemInHand(pHand);
        if (!itemStack.is(Items.VILLAGER_SPAWN_EGG) && this.isAlive() && this.getTradingPlayer() == null && !this.isBaby()) {
            if (pHand == InteractionHand.MAIN_HAND) {
                pPlayer.awardStat(Stats.TALKED_TO_VILLAGER);
            }
            if (!this.level().isClientSide()) {
                if (this.getOffers().isEmpty()) {
                    this.playCelebrateSound();
                } else {
                    this.setTradingPlayer(pPlayer);
                    this.openTradingScreen(pPlayer, this.getDisplayName(), 1);
                }
            }
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
        }
        return super.mobInteract(pPlayer, pHand);
    }

    public void playCelebrateSound() {
        this.setUnhappyCounter(40);
        if (!this.level().isClientSide()) {
            this.playSound(this.getTradeUpdatedSound(false), this.getSoundVolume(), this.getVoicePitch());
        }
    }

    public void tick() {
        super.tick();
        if (this.getUnhappyCounter() > 0) {
            this.setUnhappyCounter(this.getUnhappyCounter() - 1);
        }
    }

    protected void updateTrades() {
        VisitorVariant variant = this.getVariant();
        Map<Integer, VillagerTrades.ItemListing[]> tradesForVariant = VisitorTrades.VARIANT_TRADES.get((Object)variant);
        if (tradesForVariant == null || tradesForVariant.isEmpty()) {
            return;
        }
        VillagerTrades.ItemListing[] level1Trades = tradesForVariant.get(1);
        VillagerTrades.ItemListing[] level2Trades = tradesForVariant.get(2);
        MerchantOffers offers = this.getOffers();
        if (level1Trades != null) {
            this.addOffersFromItemListings(offers, level1Trades, 4);
        }
        if (level2Trades != null) {
            this.addOffersFromItemListings(offers, level2Trades, 3);
        }
        if (this.pricePenalty > 0) {
            for (MerchantOffer offer : offers) {
                offer.addToSpecialPriceDiff(this.pricePenalty);
            }
        }
    }

    protected void rewardTradeXp(MerchantOffer pOffer) {
        if (pOffer.shouldRewardExp()) {
            int i = 3 + this.random.nextInt(4);
            this.level().addFreshEntity((Entity)new ExperienceOrb(this.level(), this.getX(), this.getY() + 0.5, this.getZ(), i));
        }
    }

    public boolean hurt(DamageSource pSource, float pAmount) {
        boolean damaged = super.hurt(pSource, pAmount);
        if (damaged && !this.level().isClientSide && pSource.getEntity() instanceof Player) {
            this.alertNearbyVisitors();
            if (this.pricePenalty < 10) {
                ++this.pricePenalty;
                this.offers = null;
            }
        }
        return damaged;
    }

    public Component getDisplayName() {
        VisitorVariant variant = this.getVariant();
        return switch (variant) {
            default -> throw new MatchException(null, null);
            case VisitorVariant.TEXTURE0 -> Component.translatable((String)"entity.visitingvillagers.visitor.miner");
            case VisitorVariant.TEXTURE1 -> Component.translatable((String)"entity.visitingvillagers.visitor.beekeeper");
            case VisitorVariant.TEXTURE2 -> Component.translatable((String)"entity.visitingvillagers.visitor.lumberjack");
            case VisitorVariant.TEXTURE3 -> Component.translatable((String)"entity.visitingvillagers.visitor.good_pillager");
            case VisitorVariant.TEXTURE4 -> Component.translatable((String)"entity.visitingvillagers.visitor.glassworker");
            case VisitorVariant.TEXTURE5 -> Component.translatable((String)"entity.visitingvillagers.visitor.railwright");
            case VisitorVariant.TEXTURE6 -> Component.translatable((String)"entity.visitingvillagers.visitor.relic_scavenger");
            case VisitorVariant.TEXTURE7 -> Component.translatable((String)"entity.visitingvillagers.visitor.piglin_trader");
            case VisitorVariant.TEXTURE8 -> Component.translatable((String)"entity.visitingvillagers.visitor.beachcomber");
            case VisitorVariant.TEXTURE9 -> Component.translatable((String)"entity.visitingvillagers.visitor.enchantsmith");
            case VisitorVariant.TEXTURE10 -> Component.translatable((String)"entity.visitingvillagers.visitor.redstone_engineer");
            case VisitorVariant.TEXTURE11 -> Component.translatable((String)"entity.visitingvillagers.visitor.pyrotechnic");
            case VisitorVariant.TEXTURE12 -> Component.translatable((String)"entity.visitingvillagers.visitor.mycologist");
            case VisitorVariant.DEFAULT -> Component.translatable((String)"entity.visitingvillagers.visitor");
        };
    }

    public boolean showProgressBar() {
        return false;
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel pLevel, AgeableMob pOtherParent) {
        return (AgeableMob)((EntityType)ModEntities.VISITOR.get()).create((Level)pLevel);
    }

    protected SoundEvent getAmbientSound() {
        if (this.getVariant() == VisitorVariant.TEXTURE7) {
            return this.getTradingPlayer() != null ? SoundEvents.PIGLIN_ADMIRING_ITEM : SoundEvents.PIGLIN_AMBIENT;
        }
        if (this.getVariant() == VisitorVariant.TEXTURE3) {
            return SoundEvents.PILLAGER_AMBIENT;
        }
        return this.getTradingPlayer() != null ? SoundEvents.VILLAGER_TRADE : SoundEvents.VILLAGER_AMBIENT;
    }

    protected SoundEvent getHurtSound(DamageSource pSource) {
        if (this.getVariant() == VisitorVariant.TEXTURE7) {
            return SoundEvents.PIGLIN_HURT;
        }
        if (this.getVariant() == VisitorVariant.TEXTURE3) {
            return SoundEvents.PILLAGER_HURT;
        }
        return SoundEvents.VILLAGER_HURT;
    }

    protected SoundEvent getDeathSound() {
        if (this.getVariant() == VisitorVariant.TEXTURE7) {
            return SoundEvents.PIGLIN_DEATH;
        }
        if (this.getVariant() == VisitorVariant.TEXTURE3) {
            return SoundEvents.PILLAGER_DEATH;
        }
        return SoundEvents.VILLAGER_DEATH;
    }

    protected SoundEvent getTradeUpdatedSound(boolean pGetYesSound) {
        if (pGetYesSound) {
            if (this.getVariant() == VisitorVariant.TEXTURE7) {
                return (SoundEvent)ModSounds.ENTITY_VISITOR_PIGLIN_YES.get();
            }
            if (this.getVariant() == VisitorVariant.TEXTURE3) {
                return (SoundEvent)ModSounds.ENTITY_VISITOR_PILLAGER_YES.get();
            }
            return SoundEvents.VILLAGER_YES;
        }
        if (this.getVariant() == VisitorVariant.TEXTURE7) {
            return (SoundEvent)ModSounds.ENTITY_VISITOR_PIGLIN_NO.get();
        }
        if (this.getVariant() == VisitorVariant.TEXTURE3) {
            return (SoundEvent)ModSounds.ENTITY_VISITOR_PILLAGER_NO.get();
        }
        return SoundEvents.VILLAGER_NO;
    }

    public boolean isPersistenceRequired() {
        return false;
    }

    public boolean removeWhenFarAway(double pDistanceToClosestPlayer) {
        return pDistanceToClosestPlayer > 16384.0;
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
        pBuilder.define(DATA_ID_TYPE_VARIANT, (Object)0);
    }

    public void addAdditionalSaveData(CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
        pCompound.putInt("Variant", this.getTypeVariant());
        pCompound.putInt("PricePenalty", this.pricePenalty);
    }

    public void readAdditionalSaveData(CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
        this.entityData.set(DATA_ID_TYPE_VARIANT, (Object)pCompound.getInt("Variant"));
        this.pricePenalty = pCompound.getInt("PricePenalty");
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData) {
        VisitorVariant variant = VisitorVariant.getRandomVariant(this.random);
        this.setVariant(variant);
        return super.finalizeSpawn(pLevel, pDifficulty, pReason, pSpawnData);
    }

    public VisitorVariant getVariant() {
        return VisitorVariant.byId(this.getTypeVariant());
    }

    private int getTypeVariant() {
        return (Integer)this.entityData.get(DATA_ID_TYPE_VARIANT);
    }

    private void setVariant(VisitorVariant variant) {
        this.entityData.set(DATA_ID_TYPE_VARIANT, (Object)(variant.getId() & 0xFF));
    }

    public void startPanic() {
        if (this.panicGoal != null) {
            this.panicGoal.start();
        }
    }

    private void alertNearbyVisitors() {
        double alertRadius = 12.0;
        List nearbyVisitors = this.level().getEntitiesOfClass(VisitorEntity.class, this.getBoundingBox().inflate(alertRadius), visitor -> visitor != this);
        for (VisitorEntity visitor2 : nearbyVisitors) {
            visitor2.startPanic();
        }
    }
}

