/*
 * Decompiled with CFR 0.152.
 */
package net.redstonegames.visitingvillagers.entity.custom;

import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.LookAtTradingPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveBackToVillageGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TradeWithPlayerGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.AABB;
import net.redstonegames.visitingvillagers.entity.ai.DespawnAtDayGoal;
import net.redstonegames.visitingvillagers.entity.ai.DespawnAtNightGoal;
import net.redstonegames.visitingvillagers.entity.ai.DespawnWhenPlayerSleepsGoal;
import net.redstonegames.visitingvillagers.entity.variant.WanderingVisitorVariant;
import net.redstonegames.visitingvillagers.util.ModTags;
import net.redstonegames.visitingvillagers.util.WanderingVisitorTrades;
import org.jetbrains.annotations.Nullable;

public class WanderingVisitorEntity
extends AbstractVillager {
    private int leashDelay = 0;
    private int pricePenalty = 0;
    private static final EntityDataAccessor<Integer> DATA_ID_TYPE_VARIANT = SynchedEntityData.defineId(WanderingVisitorEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public WanderingVisitorEntity(EntityType<? extends AbstractVillager> entityType, Level level) {
        super(entityType, level);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(0, (Goal)new LookAtTradingPlayerGoal((AbstractVillager)this));
        this.goalSelector.addGoal(1, (Goal)new TradeWithPlayerGoal((AbstractVillager)this));
        this.goalSelector.addGoal(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, Zombie.class, 15.0f, 1.2, 1.6));
        this.goalSelector.addGoal(1, (Goal)new PanicGoal((PathfinderMob)this, 1.6));
        this.goalSelector.addGoal(2, (Goal)new DespawnWhenPlayerSleepsGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new MoveBackToVillageGoal((PathfinderMob)this, 1.2, false));
        this.goalSelector.addGoal(3, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.1));
        this.goalSelector.addGoal(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 4.0f));
        this.goalSelector.addGoal(6, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 4.0f));
        this.goalSelector.addGoal(9, (Goal)new DespawnAtDayGoal((Mob)this, 64.0, true));
        this.goalSelector.addGoal(9, (Goal)new DespawnAtNightGoal((Mob)this, 24.0, true));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 15.0).add(Attributes.MOVEMENT_SPEED, (double)0.2f).add(Attributes.ARMOR, 0.5);
    }

    public boolean hurt(DamageSource pSource, float pAmount) {
        boolean damaged = super.hurt(pSource, pAmount);
        if (damaged && !this.level().isClientSide && pSource.getEntity() instanceof Player && this.pricePenalty < 10) {
            ++this.pricePenalty;
            this.offers = null;
        }
        return damaged;
    }

    public InteractionResult mobInteract(Player pPlayer, InteractionHand pHand) {
        ItemStack itemStack = pPlayer.getItemInHand(pHand);
        if (!itemStack.is(Items.VILLAGER_SPAWN_EGG) && this.isAlive() && this.getTradingPlayer() == null) {
            if (pHand == InteractionHand.MAIN_HAND) {
                pPlayer.awardStat(Stats.TALKED_TO_VILLAGER);
            }
            if (!this.level().isClientSide() && !this.getOffers().isEmpty()) {
                this.setTradingPlayer(pPlayer);
                this.openTradingScreen(pPlayer, this.getDisplayName(), 1);
            }
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
        }
        return super.mobInteract(pPlayer, pHand);
    }

    protected void updateTrades() {
        WanderingVisitorVariant variant = this.getVariant();
        Map<Integer, VillagerTrades.ItemListing[]> tradesForVariant = WanderingVisitorTrades.VARIANT_TRADES.get((Object)variant);
        if (tradesForVariant == null) {
            tradesForVariant = WanderingVisitorTrades.VARIANT_TRADES.get((Object)WanderingVisitorVariant.DEFAULT);
        }
        if (tradesForVariant == null) {
            return;
        }
        VillagerTrades.ItemListing[] factoriesLevel1 = tradesForVariant.get(1);
        VillagerTrades.ItemListing[] factoriesLevel2 = tradesForVariant.get(2);
        if (factoriesLevel1 == null && factoriesLevel2 == null) {
            return;
        }
        MerchantOffers merchantoffers = this.getOffers();
        int buysToSelect = 4;
        int sellsToSelect = 4;
        if (variant == WanderingVisitorVariant.TEXTURE7) {
            buysToSelect = 6;
            sellsToSelect = 6;
        }
        if (factoriesLevel1 != null) {
            this.addOffersFromItemListings(merchantoffers, factoriesLevel1, buysToSelect);
        }
        if (factoriesLevel2 != null) {
            this.addOffersFromItemListings(merchantoffers, factoriesLevel2, sellsToSelect);
        }
        if (this.pricePenalty > 0) {
            for (MerchantOffer offer : merchantoffers) {
                offer.addToSpecialPriceDiff(this.pricePenalty);
            }
        }
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide && this.leashDelay > 0) {
            --this.leashDelay;
            if (this.leashDelay == 0) {
                this.spawnAnimals((ServerLevel)this.level());
            }
        }
    }

    protected void rewardTradeXp(MerchantOffer pOffer) {
        if (pOffer.shouldRewardExp()) {
            int i = 3 + this.random.nextInt(4);
            this.level().addFreshEntity((Entity)new ExperienceOrb(this.level(), this.getX(), this.getY() + 0.5, this.getZ(), i));
        }
    }

    public Component getDisplayName() {
        WanderingVisitorVariant variant = this.getVariant();
        return switch (variant) {
            default -> throw new MatchException(null, null);
            case WanderingVisitorVariant.DEFAULT -> Component.translatable((String)"entity.visitingvillagers.wandering_visitor.plains");
            case WanderingVisitorVariant.TEXTURE1 -> Component.translatable((String)"entity.visitingvillagers.wandering_visitor.forest");
            case WanderingVisitorVariant.TEXTURE2 -> Component.translatable((String)"entity.visitingvillagers.wandering_visitor.cave");
            case WanderingVisitorVariant.TEXTURE3 -> Component.translatable((String)"entity.visitingvillagers.wandering_visitor.mountain");
            case WanderingVisitorVariant.TEXTURE4 -> Component.translatable((String)"entity.visitingvillagers.wandering_visitor.snow");
            case WanderingVisitorVariant.TEXTURE5 -> Component.translatable((String)"entity.visitingvillagers.wandering_visitor.swamp");
            case WanderingVisitorVariant.TEXTURE6 -> Component.translatable((String)"entity.visitingvillagers.wandering_visitor.desert");
            case WanderingVisitorVariant.TEXTURE7 -> Component.translatable((String)"entity.visitingvillagers.wandering_visitor.plus");
        };
    }

    public boolean showProgressBar() {
        return false;
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel pLevel, AgeableMob pOtherParent) {
        return null;
    }

    public boolean isBaby() {
        return false;
    }

    protected SoundEvent getAmbientSound() {
        return this.getTradingPlayer() != null ? SoundEvents.WANDERING_TRADER_TRADE : SoundEvents.WANDERING_TRADER_AMBIENT;
    }

    protected SoundEvent getHurtSound(DamageSource pSource) {
        return SoundEvents.WANDERING_TRADER_HURT;
    }

    protected SoundEvent getTradeUpdatedSound(boolean pGetYesSound) {
        return pGetYesSound ? SoundEvents.WANDERING_TRADER_YES : SoundEvents.WANDERING_TRADER_NO;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.WANDERING_TRADER_DEATH;
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
        pBuilder.define(DATA_ID_TYPE_VARIANT, (Object)0);
    }

    public void addAdditionalSaveData(CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
        pCompound.putInt("Variant", this.getTypeVariant());
        pCompound.putInt("PricePenalty", this.pricePenalty);
    }

    public void readAdditionalSaveData(CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
        this.entityData.set(DATA_ID_TYPE_VARIANT, (Object)pCompound.getInt("Variant"));
        this.pricePenalty = pCompound.getInt("PricePenalty");
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData) {
        WanderingVisitorVariant variant = WanderingVisitorVariant.values()[this.random.nextInt(WanderingVisitorVariant.values().length)];
        this.setVariant(variant);
        this.leashDelay = 10;
        return super.finalizeSpawn(pLevel, pDifficulty, pReason, pSpawnData);
    }

    private void spawnLeashedAnimal(ServerLevel world, DifficultyInstance difficulty, EntityType<? extends Animal> type, @Nullable BlockPos existingAnimalPos) {
        BlockPos spawnPos = this.findLeashedAnimalPos((LevelAccessor)world, this.blockPosition(), 3, existingAnimalPos);
        Animal animal = (Animal)type.create((Level)world);
        if (animal != null) {
            animal.moveTo(spawnPos, 1.0f, 0.0f);
            animal.finalizeSpawn((ServerLevelAccessor)world, difficulty, MobSpawnType.EVENT, null);
            world.addFreshEntityWithPassengers((Entity)animal);
            animal.setLeashedTo((Entity)this, true);
        }
    }

    private void spawnAnimals(ServerLevel world) {
        DifficultyInstance difficulty = world.getCurrentDifficultyAt(this.blockPosition());
        WanderingVisitorVariant variant = this.getVariant();
        switch (variant) {
            case DEFAULT: {
                this.spawnLeashedAnimal(world, difficulty, (EntityType<? extends Animal>)EntityType.SHEEP, null);
                this.spawnLeashedAnimal(world, difficulty, (EntityType<? extends Animal>)EntityType.SHEEP, this.blockPosition());
                break;
            }
            case TEXTURE1: {
                this.spawnLeashedAnimal(world, difficulty, (EntityType<? extends Animal>)EntityType.FOX, null);
                break;
            }
            case TEXTURE2: {
                this.spawnLeashedAnimal(world, difficulty, (EntityType<? extends Animal>)EntityType.LLAMA, null);
                this.spawnLeashedAnimal(world, difficulty, (EntityType<? extends Animal>)EntityType.LLAMA, this.blockPosition());
                break;
            }
            case TEXTURE3: {
                this.spawnLeashedAnimal(world, difficulty, (EntityType<? extends Animal>)EntityType.GOAT, null);
                this.spawnLeashedAnimal(world, difficulty, (EntityType<? extends Animal>)EntityType.GOAT, this.blockPosition());
                break;
            }
            case TEXTURE4: {
                this.spawnLeashedAnimal(world, difficulty, (EntityType<? extends Animal>)EntityType.HORSE, null);
                break;
            }
            case TEXTURE5: {
                this.spawnLeashedAnimal(world, difficulty, (EntityType<? extends Animal>)EntityType.FROG, null);
                this.spawnLeashedAnimal(world, difficulty, (EntityType<? extends Animal>)EntityType.FROG, this.blockPosition());
                break;
            }
            case TEXTURE6: {
                this.spawnLeashedAnimal(world, difficulty, (EntityType<? extends Animal>)EntityType.CAMEL, null);
                break;
            }
            case TEXTURE7: {
                this.spawnLeashedAnimal(world, difficulty, (EntityType<? extends Animal>)EntityType.HORSE, null);
                this.spawnLeashedAnimal(world, difficulty, (EntityType<? extends Animal>)EntityType.HORSE, this.blockPosition());
            }
        }
    }

    public WanderingVisitorVariant getVariant() {
        return WanderingVisitorVariant.byId(this.getTypeVariant() & 0xFF);
    }

    private int getTypeVariant() {
        return (Integer)this.entityData.get(DATA_ID_TYPE_VARIANT);
    }

    private void setVariant(WanderingVisitorVariant variant) {
        this.entityData.set(DATA_ID_TYPE_VARIANT, (Object)(variant.getId() & 0xFF));
    }

    private BlockPos findLeashedAnimalPos(LevelAccessor world, BlockPos pos, int range, @Nullable BlockPos existingAnimalPos) {
        BlockPos blockPos = pos;
        for (int i = 0; i < 10; ++i) {
            int z;
            int x = this.random.nextInt(range * 2) - range;
            BlockPos testPos = blockPos.offset(x, 0, z = this.random.nextInt(range * 2) - range);
            if (!world.getBlockState(testPos).isAir() || existingAnimalPos != null && testPos.equals((Object)existingAnimalPos)) continue;
            return testPos;
        }
        return blockPos;
    }

    public static boolean checkSpawnRules(EntityType<? extends WanderingVisitorEntity> type, LevelAccessor world, MobSpawnType reason, BlockPos pos, RandomSource random) {
        return world.getBlockState(pos.below()).is(ModTags.Blocks.VISITORS_SPAWNABLE_ON) && Mob.checkMobSpawnRules(type, (LevelAccessor)world, (MobSpawnType)reason, (BlockPos)pos, (RandomSource)random);
    }

    public boolean isPersistenceRequired() {
        return false;
    }

    public boolean removeWhenFarAway(double pDistanceToClosestPlayer) {
        return true;
    }

    public void remove(Entity.RemovalReason pReason) {
        this.removeLeashedAnimals();
        super.remove(pReason);
    }

    public void removeLeashedAnimals() {
        if (this.level().isClientSide) {
            return;
        }
        AABB searchBox = this.getBoundingBox().inflate(16.0);
        List nearbyAnimals = this.level().getEntitiesOfClass(Mob.class, searchBox, animal -> animal.isLeashed() && this.equals(animal.getLeashHolder()));
        for (Mob animal2 : nearbyAnimals) {
            animal2.discard();
        }
    }
}

