/*
 * Decompiled with CFR 0.152.
 */
package net.redstonegames.visitingvillagers.event;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.redstonegames.visitingvillagers.entity.ModEntities;
import net.redstonegames.visitingvillagers.entity.custom.BabyVisitorEntity;
import net.redstonegames.visitingvillagers.entity.custom.VisitorEntity;
import net.redstonegames.visitingvillagers.entity.custom.WanderingVisitorEntity;
import net.redstonegames.visitingvillagers.util.ModTags;

@Mod.EventBusSubscriber(modid="visitingvillagers")
public class CustomSpawnManager {
    private static final boolean DEBUG_MODE = false;
    private static final int SPAWN_CHECK_INTERVAL = 100;
    private static final int DEBUG_MESSAGE_INTERVAL = 400;
    private static int tickCounter = 0;
    private static final int MAX_SPAWNS_PER_CYCLE = 3;
    private static final int MIN_ADULTS_FOR_BABY = 2;
    private static final int ADULTS_PER_BABY_RATIO = 2;
    private static final int BABY_POPULATION_BONUS = 3;
    private static final int MAX_WANDERING_VISITORS = 2;

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            if (++tickCounter % 100 != 0) {
                return;
            }
            for (ServerPlayer player : event.getServer().getPlayerList().getPlayers()) {
                boolean canSpawnWandering;
                ServerLevel level = player.serverLevel();
                BlockPos playerPos = player.blockPosition();
                long daytime = level.getDayTime() % 24000L;
                AABB searchBox = new AABB(playerPos).inflate(128.0);
                List villagers = level.getEntitiesOfClass(Villager.class, searchBox, e -> true);
                List golems = level.getEntitiesOfClass(IronGolem.class, searchBox, e -> true);
                List allVisitorNpcs = level.getEntitiesOfClass(VisitorEntity.class, searchBox, e -> true);
                List wanderingVisitors = level.getEntitiesOfClass(WanderingVisitorEntity.class, searchBox, e -> true);
                ArrayList<VisitorEntity> adultNpcs = new ArrayList<VisitorEntity>();
                ArrayList<BabyVisitorEntity> babyNpcs = new ArrayList<BabyVisitorEntity>();
                for (VisitorEntity npc : allVisitorNpcs) {
                    if (npc instanceof BabyVisitorEntity) {
                        babyNpcs.add((BabyVisitorEntity)npc);
                        continue;
                    }
                    adultNpcs.add(npc);
                }
                if (villagers.size() >= 6 && golems.size() >= 1 && adultNpcs.size() < villagers.size() && daytime > 500L && daytime < 12000L) {
                    int npcsToSpawn = Math.min(villagers.size() - adultNpcs.size(), 3);
                    for (int i = 0; i < npcsToSpawn && !villagers.isEmpty(); ++i) {
                        Villager targetVillager = (Villager)villagers.get(level.random.nextInt(villagers.size()));
                        CustomSpawnManager.findSafeSpawnLocation(level, targetVillager.blockPosition(), 10).ifPresent(spawnPos -> ((EntityType)ModEntities.VISITOR.get()).spawn(level, spawnPos, MobSpawnType.EVENT));
                    }
                }
                int babyCap = adultNpcs.size() / 2 + 3;
                if (adultNpcs.size() >= 2 && babyNpcs.size() < babyCap && daytime > 500L && daytime < 12000L) {
                    if (adultNpcs.isEmpty()) break;
                    VisitorEntity targetAdult = (VisitorEntity)((Object)adultNpcs.get(level.random.nextInt(adultNpcs.size())));
                    CustomSpawnManager.findSafeSpawnLocation(level, targetAdult.blockPosition(), 8).ifPresent(spawnPos -> ((EntityType)ModEntities.BABY_VISITOR.get()).spawn(level, spawnPos, MobSpawnType.EVENT));
                }
                boolean bl = canSpawnWandering = villagers.size() >= 6 && golems.size() >= 1 && daytime < 12000L;
                if (canSpawnWandering && wanderingVisitors.isEmpty() && daytime > 1500L && !golems.isEmpty()) {
                    IronGolem targetGolem = (IronGolem)golems.get(level.random.nextInt(golems.size()));
                    CustomSpawnManager.findSafeSpawnLocation(level, targetGolem.blockPosition(), 25).ifPresent(spawnPos -> ((EntityType)ModEntities.WANDERING_VISITOR.get()).spawn(level, spawnPos, MobSpawnType.EVENT));
                }
                if (!canSpawnWandering || wanderingVisitors.size() != 1) continue;
                WanderingVisitorEntity firstVisitor = (WanderingVisitorEntity)((Object)wanderingVisitors.get(0));
                boolean hasLivedLongEnough = firstVisitor.tickCount > 600;
                if (!hasLivedLongEnough || daytime <= 4500L || golems.isEmpty()) continue;
                IronGolem targetGolem = (IronGolem)golems.get(level.random.nextInt(golems.size()));
                CustomSpawnManager.findSafeSpawnLocation(level, targetGolem.blockPosition(), 25).ifPresent(spawnPos -> ((EntityType)ModEntities.WANDERING_VISITOR.get()).spawn(level, spawnPos, MobSpawnType.EVENT));
            }
        }
    }

    private static Optional<BlockPos> findSafeSpawnLocation(ServerLevel level, BlockPos center, int radius) {
        for (int i = 0; i < 10; ++i) {
            int z;
            int x = center.getX() + level.random.nextInt(radius * 2) - radius;
            BlockPos topPos = level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, new BlockPos(x, 0, z = center.getZ() + level.random.nextInt(radius * 2) - radius));
            if (level.getNearestPlayer((double)topPos.getX(), (double)topPos.getY(), (double)topPos.getZ(), 24.0, false) != null || !level.getBlockState(topPos.below()).is(ModTags.Blocks.VISITORS_SPAWNABLE_ON) || !level.isEmptyBlock(topPos) || !level.isEmptyBlock(topPos.above())) continue;
            return Optional.of(topPos);
        }
        return Optional.empty();
    }
}

