/*
 * Decompiled with CFR 0.152.
 */
package net.redstonegames.visitingvillagers.util;

import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.item.trading.ItemCost;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;

public class RandomEnchantedBookFactory
implements VillagerTrades.ItemListing {
    private final int experience;

    public RandomEnchantedBookFactory(int experience) {
        this.experience = experience;
    }

    @Nullable
    public MerchantOffer getOffer(Entity trader, RandomSource rand) {
        Registry enchantmentRegistry = trader.level().registryAccess().registryOrThrow(Registries.ENCHANTMENT);
        List validEnchantments = enchantmentRegistry.holders().filter(holder -> holder.is(EnchantmentTags.TRADEABLE)).collect(Collectors.toList());
        if (validEnchantments.isEmpty()) {
            return null;
        }
        Holder randomEnchantmentHolder = (Holder)validEnchantments.get(rand.nextInt(validEnchantments.size()));
        int level = rand.nextInt(((Enchantment)randomEnchantmentHolder.value()).getMaxLevel()) + 1;
        ItemStack enchantedBook = EnchantedBookItem.createForEnchantment((EnchantmentInstance)new EnchantmentInstance(randomEnchantmentHolder, level));
        int price = 2 + rand.nextInt(5 + level * 10) + 3 * level;
        if (randomEnchantmentHolder.is(EnchantmentTags.DOUBLE_TRADE_PRICE)) {
            price *= 2;
        }
        if (price > 64) {
            price = 64;
        }
        return new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, price), enchantedBook, 1, this.experience, 0.2f);
    }
}

