/*
 * Decompiled with CFR 0.152.
 */
package net.redstonegames.visitingvillagers.util;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import javax.annotation.Nullable;
import net.minecraft.core.component.DataComponents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.FireworkExplosion;
import net.minecraft.world.item.trading.ItemCost;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;

public class RandomFireworkStarFactory
implements VillagerTrades.ItemListing {
    private final int price;
    private final int maxUses;
    private final int experience;

    public RandomFireworkStarFactory(int price, int maxUses, int experience) {
        this.price = price;
        this.maxUses = maxUses;
        this.experience = experience;
    }

    @Nullable
    public MerchantOffer getOffer(Entity trader, RandomSource rand) {
        FireworkExplosion.Shape shape = FireworkExplosion.Shape.values()[rand.nextInt(FireworkExplosion.Shape.values().length)];
        IntArrayList colors = new IntArrayList(new int[]{DyeColor.values()[rand.nextInt(DyeColor.values().length)].getFireworkColor()});
        boolean hasTrail = rand.nextFloat() < 0.3f;
        boolean hasFlicker = rand.nextFloat() < 0.3f;
        FireworkExplosion fireworkExplosion = new FireworkExplosion(shape, (IntList)colors, (IntList)new IntArrayList(), hasTrail, hasFlicker);
        ItemStack fireworkStarStack = new ItemStack((ItemLike)Items.FIREWORK_STAR);
        fireworkStarStack.set(DataComponents.FIREWORK_EXPLOSION, (Object)fireworkExplosion);
        return new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, this.price), fireworkStarStack, this.maxUses, this.experience, 0.05f);
    }
}

