/*
 * Decompiled with CFR 0.152.
 */
package net.redstonegames.visitingvillagers.util;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.component.DataComponents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.FireworkExplosion;
import net.minecraft.world.item.component.Fireworks;
import net.minecraft.world.item.trading.ItemCost;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;

public class RandomRocketFactory
implements VillagerTrades.ItemListing {
    private final int baseEmeraldCost;
    private final int maxUses;
    private final int experience;

    public RandomRocketFactory(int baseEmeraldCost, int maxUses, int experience) {
        this.baseEmeraldCost = baseEmeraldCost;
        this.maxUses = maxUses;
        this.experience = experience;
    }

    @Nullable
    public MerchantOffer getOffer(Entity trader, RandomSource rand) {
        int finalPrice = this.baseEmeraldCost;
        int flightDuration = rand.nextInt(3) + 1;
        finalPrice += flightDuration - 1;
        DyeColor dyeColor = DyeColor.values()[rand.nextInt(DyeColor.values().length)];
        IntArrayList colors = new IntArrayList(new int[]{dyeColor.getFireworkColor()});
        FireworkExplosion.Shape shape = FireworkExplosion.Shape.values()[rand.nextInt(FireworkExplosion.Shape.values().length)];
        switch (shape) {
            case LARGE_BALL: 
            case STAR: 
            case BURST: {
                finalPrice += 2;
                break;
            }
            case CREEPER: {
                finalPrice += 3;
            }
        }
        boolean hasTrail = false;
        if (rand.nextBoolean()) {
            hasTrail = true;
            finalPrice += 2;
        }
        boolean hasFlicker = false;
        if (rand.nextBoolean()) {
            hasFlicker = true;
            finalPrice += 2;
        }
        FireworkExplosion explosion = new FireworkExplosion(shape, (IntList)colors, (IntList)new IntArrayList(), hasTrail, hasFlicker);
        Fireworks fireworks = new Fireworks(flightDuration, List.of(explosion));
        ItemStack rocket = new ItemStack((ItemLike)Items.FIREWORK_ROCKET, 1);
        rocket.set(DataComponents.FIREWORKS, (Object)fireworks);
        return new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, finalPrice), rocket, this.maxUses, this.experience, 0.05f);
    }
}

