/*
 * Decompiled with CFR 0.152.
 */
package net.redstonegames.visitingvillagers.util;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.SuspiciousStewEffects;
import net.minecraft.world.item.trading.ItemCost;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;

public class RandomSuspiciousStewFactory
implements VillagerTrades.ItemListing {
    private final int price;
    private final int maxUses;
    private final int experience;
    private static final List<Holder<MobEffect>> STEW_EFFECTS = List.of(MobEffects.REGENERATION, MobEffects.JUMP, MobEffects.FIRE_RESISTANCE, MobEffects.SATURATION, MobEffects.NIGHT_VISION, MobEffects.MOVEMENT_SPEED);

    public RandomSuspiciousStewFactory(int price, int maxUses, int experience) {
        this.price = price;
        this.maxUses = maxUses;
        this.experience = experience;
    }

    @Nullable
    public MerchantOffer getOffer(Entity trader, RandomSource rand) {
        ItemStack stewStack = new ItemStack((ItemLike)Items.SUSPICIOUS_STEW);
        Holder<MobEffect> randomEffect = STEW_EFFECTS.get(rand.nextInt(STEW_EFFECTS.size()));
        int duration = (rand.nextInt(10) + 8) * 20;
        SuspiciousStewEffects.Entry effectEntry = new SuspiciousStewEffects.Entry(randomEffect, duration);
        stewStack.set(DataComponents.SUSPICIOUS_STEW_EFFECTS, (Object)new SuspiciousStewEffects(List.of(effectEntry)));
        return new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, this.price), stewStack, this.maxUses, this.experience, 0.05f);
    }
}

