/*
 * Decompiled with CFR 0.152.
 */
package net.redstonegames.visitingvillagers.util;

import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.component.Fireworks;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.item.trading.ItemCost;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.redstonegames.visitingvillagers.entity.variant.VisitorVariant;
import net.redstonegames.visitingvillagers.util.RandomEnchantedBookFactory;
import net.redstonegames.visitingvillagers.util.RandomFireworkStarFactory;
import net.redstonegames.visitingvillagers.util.RandomRocketFactory;
import net.redstonegames.visitingvillagers.util.RandomSuspiciousStewFactory;

public class VisitorTrades {
    public static final Map<VisitorVariant, Map<Integer, VillagerTrades.ItemListing[]>> VARIANT_TRADES = ImmutableMap.builder().put((Object)VisitorVariant.TEXTURE0, VisitorTrades.buildMinerTrades()).put((Object)VisitorVariant.TEXTURE1, VisitorTrades.buildBeekeeperTrades()).put((Object)VisitorVariant.TEXTURE2, VisitorTrades.buildLumberjackTrades()).put((Object)VisitorVariant.TEXTURE3, VisitorTrades.buildGoodPillagerTrades()).put((Object)VisitorVariant.TEXTURE4, VisitorTrades.buildGlassworkerTrades()).put((Object)VisitorVariant.TEXTURE5, VisitorTrades.buildRailwrightTrades()).put((Object)VisitorVariant.TEXTURE6, VisitorTrades.buildRelicScavengerTrades()).put((Object)VisitorVariant.TEXTURE7, VisitorTrades.buildPiglinTraderTrades()).put((Object)VisitorVariant.TEXTURE8, VisitorTrades.buildBeachcomberTrades()).put((Object)VisitorVariant.TEXTURE9, VisitorTrades.buildEnchantsmithTrades()).put((Object)VisitorVariant.TEXTURE10, VisitorTrades.buildRedstoneEngineerTrades()).put((Object)VisitorVariant.TEXTURE11, VisitorTrades.buildPyrotechnicTrades()).put((Object)VisitorVariant.TEXTURE12, VisitorTrades.buildMycologistTrades()).build();

    private static Map<Integer, VillagerTrades.ItemListing[]> buildMinerTrades() {
        return ImmutableMap.builder().put((Object)1, (Object)new VillagerTrades.ItemListing[]{(trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.COAL, 10), new ItemStack((ItemLike)Items.EMERALD, 1), 5, 5, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.RAW_COPPER, 10), new ItemStack((ItemLike)Items.EMERALD, 1), 5, 7, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.COPPER_INGOT, 8), new ItemStack((ItemLike)Items.EMERALD, 1), 5, 8, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.RAW_IRON, 1), new ItemStack((ItemLike)Items.EMERALD, 1), 5, 10, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.IRON_INGOT, 1), new ItemStack((ItemLike)Items.EMERALD, 2), 5, 12, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.RAW_GOLD, 1), new ItemStack((ItemLike)Items.EMERALD, 1), 5, 8, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.GOLD_INGOT, 1), new ItemStack((ItemLike)Items.EMERALD, 2), 5, 10, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.DIAMOND, 1), new ItemStack((ItemLike)Items.EMERALD, 8), 5, 20, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.REDSTONE, 8), new ItemStack((ItemLike)Items.EMERALD, 1), 5, 4, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.LAPIS_LAZULI, 5), new ItemStack((ItemLike)Items.EMERALD, 1), 5, 20, 0.05f)}).put((Object)2, (Object)new VillagerTrades.ItemListing[]{(trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 1), new ItemStack((ItemLike)Items.COAL, 8), 5, 2, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 1), new ItemStack((ItemLike)Items.RAW_COPPER, 7), 5, 3, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 1), new ItemStack((ItemLike)Items.COPPER_INGOT, 6), 5, 4, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 2), new ItemStack((ItemLike)Items.RAW_IRON, 1), 5, 5, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 1), new ItemStack((ItemLike)Items.COPPER_INGOT, 6), 5, 4, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 2), new ItemStack((ItemLike)Items.RAW_IRON, 1), 5, 5, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 3), new ItemStack((ItemLike)Items.IRON_INGOT, 1), 5, 7, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 2), new ItemStack((ItemLike)Items.RAW_GOLD, 1), 5, 8, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 3), new ItemStack((ItemLike)Items.GOLD_INGOT, 1), 5, 10, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 10), new ItemStack((ItemLike)Items.DIAMOND, 1), 5, 15, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 1), new ItemStack((ItemLike)Items.STONE_PICKAXE, 1), 10, 4, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 3), new ItemStack((ItemLike)Items.IRON_PICKAXE, 1), 5, 8, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 1), new ItemStack((ItemLike)Items.TORCH, 10), 10, 2, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 1), new ItemStack((ItemLike)Items.REDSTONE, 6), 5, 4, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 1), new ItemStack((ItemLike)Items.LAPIS_LAZULI, 3), 5, 15, 0.05f)}).build();
    }

    private static Map<Integer, VillagerTrades.ItemListing[]> buildBeekeeperTrades() {
        return ImmutableMap.builder().put((Object)1, (Object)new VillagerTrades.ItemListing[]{(trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.GLASS_BOTTLE, 4), new ItemStack((ItemLike)Items.EMERALD, 1), 5, 2, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.HONEYCOMB, 3), new ItemStack((ItemLike)Items.EMERALD, 1), 5, 3, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.HONEY_BOTTLE, 2), new ItemStack((ItemLike)Items.EMERALD, 1), 5, 4, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.HONEYCOMB_BLOCK, 1), new ItemStack((ItemLike)Items.EMERALD, 1), 3, 5, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.HONEY_BLOCK, 1), new ItemStack((ItemLike)Items.EMERALD, 2), 3, 6, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.BEEHIVE, 1), new ItemStack((ItemLike)Items.EMERALD, 4), 3, 8, 0.05f)}).put((Object)2, (Object)new VillagerTrades.ItemListing[]{(trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 1), new ItemStack((ItemLike)Items.GLASS_BOTTLE, 3), 5, 2, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 1), new ItemStack((ItemLike)Items.HONEYCOMB, 2), 5, 3, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 1), new ItemStack((ItemLike)Items.HONEY_BOTTLE, 1), 5, 4, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 2), new ItemStack((ItemLike)Items.HONEYCOMB_BLOCK, 1), 3, 5, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 3), new ItemStack((ItemLike)Items.HONEY_BLOCK, 1), 3, 6, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 5), new ItemStack((ItemLike)Items.BEEHIVE, 1), 3, 8, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 8), new ItemStack((ItemLike)Items.BEE_NEST, 1), 3, 10, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 5), new ItemStack((ItemLike)Items.BEE_SPAWN_EGG, 1), 2, 15, 0.05f)}).build();
    }

    private static Map<Integer, VillagerTrades.ItemListing[]> buildLumberjackTrades() {
        return ImmutableMap.builder().put((Object)1, (Object)new VillagerTrades.ItemListing[]{(trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.OAK_LOG, 8), new ItemStack((ItemLike)Items.EMERALD, 1), 5, 3, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.SPRUCE_LOG, 8), new ItemStack((ItemLike)Items.EMERALD, 1), 5, 3, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.BIRCH_LOG, 8), new ItemStack((ItemLike)Items.EMERALD, 1), 5, 3, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.JUNGLE_LOG, 8), new ItemStack((ItemLike)Items.EMERALD, 1), 5, 3, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.ACACIA_LOG, 8), new ItemStack((ItemLike)Items.EMERALD, 1), 5, 3, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.DARK_OAK_LOG, 8), new ItemStack((ItemLike)Items.EMERALD, 1), 5, 3, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.MANGROVE_LOG, 8), new ItemStack((ItemLike)Items.EMERALD, 1), 5, 3, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.CHERRY_LOG, 8), new ItemStack((ItemLike)Items.EMERALD, 1), 5, 3, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.OAK_SAPLING, 1), new ItemStack((ItemLike)Items.EMERALD, 1), 5, 6, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.BIRCH_SAPLING, 1), new ItemStack((ItemLike)Items.EMERALD, 1), 5, 6, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.ACACIA_SAPLING, 1), new ItemStack((ItemLike)Items.EMERALD, 1), 5, 6, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.CHERRY_SAPLING, 1), new ItemStack((ItemLike)Items.EMERALD, 1), 5, 6, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.JUNGLE_SAPLING, 1), new ItemStack((ItemLike)Items.EMERALD, 1), 5, 6, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.SPRUCE_SAPLING, 1), new ItemStack((ItemLike)Items.EMERALD, 1), 5, 6, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.DARK_OAK_SAPLING, 1), new ItemStack((ItemLike)Items.EMERALD, 1), 5, 6, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.MANGROVE_PROPAGULE, 1), new ItemStack((ItemLike)Items.EMERALD, 1), 5, 6, 0.05f)}).put((Object)2, (Object)new VillagerTrades.ItemListing[]{(trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 1), new ItemStack((ItemLike)Items.OAK_LOG, 5), 5, 2, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 1), new ItemStack((ItemLike)Items.SPRUCE_LOG, 5), 5, 2, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 1), new ItemStack((ItemLike)Items.STONE_AXE, 1), 10, 4, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 3), new ItemStack((ItemLike)Items.IRON_AXE, 1), 5, 8, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 1), new ItemStack((ItemLike)Items.BIRCH_LOG, 5), 5, 2, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 1), new ItemStack((ItemLike)Items.JUNGLE_LOG, 5), 5, 2, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 1), new ItemStack((ItemLike)Items.ACACIA_LOG, 5), 5, 2, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 1), new ItemStack((ItemLike)Items.DARK_OAK_LOG, 5), 5, 2, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 1), new ItemStack((ItemLike)Items.MANGROVE_LOG, 5), 5, 2, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 1), new ItemStack((ItemLike)Items.CHERRY_LOG, 5), 5, 2, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 3), new ItemStack((ItemLike)Items.OAK_SAPLING, 1), 5, 5, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 3), new ItemStack((ItemLike)Items.BIRCH_SAPLING, 1), 5, 5, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 3), new ItemStack((ItemLike)Items.ACACIA_SAPLING, 1), 5, 5, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 3), new ItemStack((ItemLike)Items.CHERRY_SAPLING, 1), 5, 5, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 3), new ItemStack((ItemLike)Items.JUNGLE_SAPLING, 1), 5, 5, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 3), new ItemStack((ItemLike)Items.SPRUCE_SAPLING, 1), 5, 5, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 3), new ItemStack((ItemLike)Items.DARK_OAK_SAPLING, 1), 5, 5, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 3), new ItemStack((ItemLike)Items.MANGROVE_PROPAGULE, 1), 5, 5, 0.05f)}).build();
    }

    private static Map<Integer, VillagerTrades.ItemListing[]> buildGoodPillagerTrades() {
        return ImmutableMap.builder().put((Object)1, (Object)new VillagerTrades.ItemListing[]{(trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.CARROT, 12), new ItemStack((ItemLike)Items.EMERALD, 1), 5, 2, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.POTATO, 12), new ItemStack((ItemLike)Items.EMERALD, 1), 5, 2, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.ARROW, 10), new ItemStack((ItemLike)Items.EMERALD, 1), 5, 2, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.STRING, 15), new ItemStack((ItemLike)Items.EMERALD, 1), 5, 3, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.IRON_INGOT, 1), new ItemStack((ItemLike)Items.EMERALD, 2), 5, 7, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.CROSSBOW, 1), new ItemStack((ItemLike)Items.EMERALD, 4), 1, 5, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.TRIPWIRE_HOOK, 1), new ItemStack((ItemLike)Items.EMERALD, 2), 3, 5, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.GOAT_HORN, 1), new ItemStack((ItemLike)Items.EMERALD, 2), 1, 20, 0.05f)}).put((Object)2, (Object)new VillagerTrades.ItemListing[]{(trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 1), new ItemStack((ItemLike)Items.ARROW, 8), 3, 2, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 1), new ItemStack((ItemLike)Items.STRING, 10), 5, 3, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 5), new ItemStack((ItemLike)Items.CROSSBOW, 1), 3, 8, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 3), new ItemStack((ItemLike)Items.TRIPWIRE_HOOK, 1), 3, 5, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 5), new ItemStack((ItemLike)Items.EXPERIENCE_BOTTLE, 1), 2, 10, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 3), new ItemStack((ItemLike)Items.IRON_INGOT, 1), 5, 7, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 3), new ItemStack((ItemLike)Items.GOAT_HORN, 1), 1, 20, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 5), new ItemStack((ItemLike)Items.ALLAY_SPAWN_EGG, 1), 1, 20, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 12), new ItemStack((ItemLike)Items.SENTRY_ARMOR_TRIM_SMITHING_TEMPLATE, 1), 1, 20, 0.05f)}).build();
    }

    private static Map<Integer, VillagerTrades.ItemListing[]> buildGlassworkerTrades() {
        return ImmutableMap.builder().put((Object)1, (Object)new VillagerTrades.ItemListing[]{(trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.SAND, 10), new ItemStack((ItemLike)Items.EMERALD, 1), 6, 2, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.WHITE_DYE, 12), new ItemStack((ItemLike)Items.EMERALD, 1), 10, 4, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.LIGHT_GRAY_DYE, 12), new ItemStack((ItemLike)Items.EMERALD, 1), 10, 4, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.GRAY_DYE, 12), new ItemStack((ItemLike)Items.EMERALD, 1), 10, 4, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.BLACK_DYE, 12), new ItemStack((ItemLike)Items.EMERALD, 1), 10, 4, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.BROWN_DYE, 12), new ItemStack((ItemLike)Items.EMERALD, 1), 10, 4, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.RED_DYE, 12), new ItemStack((ItemLike)Items.EMERALD, 1), 10, 4, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.ORANGE_DYE, 12), new ItemStack((ItemLike)Items.EMERALD, 1), 10, 4, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.YELLOW_DYE, 12), new ItemStack((ItemLike)Items.EMERALD, 1), 10, 4, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.LIME_DYE, 12), new ItemStack((ItemLike)Items.EMERALD, 1), 10, 4, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.GREEN_DYE, 12), new ItemStack((ItemLike)Items.EMERALD, 1), 10, 4, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.CYAN_DYE, 12), new ItemStack((ItemLike)Items.EMERALD, 1), 10, 4, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.LIGHT_BLUE_DYE, 12), new ItemStack((ItemLike)Items.EMERALD, 1), 10, 4, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.BLUE_DYE, 12), new ItemStack((ItemLike)Items.EMERALD, 1), 10, 4, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.PURPLE_DYE, 12), new ItemStack((ItemLike)Items.EMERALD, 1), 10, 4, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.MAGENTA_DYE, 12), new ItemStack((ItemLike)Items.EMERALD, 1), 10, 4, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.PINK_DYE, 12), new ItemStack((ItemLike)Items.EMERALD, 1), 10, 4, 0.05f)}).put((Object)2, (Object)new VillagerTrades.ItemListing[]{(trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 1), new ItemStack((ItemLike)Items.GLASS, 4), 5, 2, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 1), new ItemStack((ItemLike)Items.GLASS_PANE, 10), 5, 3, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 1), new ItemStack((ItemLike)Items.WHITE_STAINED_GLASS_PANE, 10), 5, 3, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 1), new ItemStack((ItemLike)Items.LIGHT_GRAY_STAINED_GLASS_PANE, 10), 5, 3, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 1), new ItemStack((ItemLike)Items.GRAY_STAINED_GLASS_PANE, 10), 5, 3, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 1), new ItemStack((ItemLike)Items.BLACK_STAINED_GLASS_PANE, 10), 5, 3, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 1), new ItemStack((ItemLike)Items.BROWN_STAINED_GLASS_PANE, 10), 5, 3, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 1), new ItemStack((ItemLike)Items.RED_STAINED_GLASS_PANE, 10), 5, 3, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 1), new ItemStack((ItemLike)Items.ORANGE_STAINED_GLASS_PANE, 10), 5, 3, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 1), new ItemStack((ItemLike)Items.YELLOW_STAINED_GLASS_PANE, 10), 5, 3, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 1), new ItemStack((ItemLike)Items.LIME_STAINED_GLASS_PANE, 10), 5, 3, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 1), new ItemStack((ItemLike)Items.GREEN_STAINED_GLASS_PANE, 10), 5, 3, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 1), new ItemStack((ItemLike)Items.CYAN_STAINED_GLASS_PANE, 10), 5, 3, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 1), new ItemStack((ItemLike)Items.LIGHT_BLUE_STAINED_GLASS_PANE, 10), 5, 3, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 1), new ItemStack((ItemLike)Items.BLUE_STAINED_GLASS_PANE, 10), 5, 3, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 1), new ItemStack((ItemLike)Items.PURPLE_STAINED_GLASS_PANE, 10), 5, 3, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 1), new ItemStack((ItemLike)Items.MAGENTA_STAINED_GLASS_PANE, 10), 5, 3, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 1), new ItemStack((ItemLike)Items.PINK_STAINED_GLASS_PANE, 10), 5, 3, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 1), new ItemStack((ItemLike)Items.TINTED_GLASS, 3), 5, 6, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 1), new ItemStack((ItemLike)Items.WHITE_STAINED_GLASS, 3), 5, 6, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 1), new ItemStack((ItemLike)Items.LIGHT_GRAY_STAINED_GLASS, 3), 5, 6, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 1), new ItemStack((ItemLike)Items.GRAY_STAINED_GLASS, 3), 5, 6, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 1), new ItemStack((ItemLike)Items.BLACK_STAINED_GLASS, 3), 5, 6, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 1), new ItemStack((ItemLike)Items.BROWN_STAINED_GLASS, 3), 5, 6, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 1), new ItemStack((ItemLike)Items.RED_STAINED_GLASS, 3), 5, 6, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 1), new ItemStack((ItemLike)Items.ORANGE_STAINED_GLASS, 3), 5, 6, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 1), new ItemStack((ItemLike)Items.YELLOW_STAINED_GLASS, 3), 5, 6, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 1), new ItemStack((ItemLike)Items.LIME_STAINED_GLASS, 3), 5, 6, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 1), new ItemStack((ItemLike)Items.GREEN_STAINED_GLASS, 3), 5, 6, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 1), new ItemStack((ItemLike)Items.CYAN_STAINED_GLASS, 3), 5, 6, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 1), new ItemStack((ItemLike)Items.LIGHT_BLUE_STAINED_GLASS, 3), 5, 6, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 1), new ItemStack((ItemLike)Items.BLUE_STAINED_GLASS, 3), 5, 6, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 1), new ItemStack((ItemLike)Items.PURPLE_STAINED_GLASS, 3), 5, 6, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 1), new ItemStack((ItemLike)Items.MAGENTA_STAINED_GLASS, 3), 5, 6, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 1), new ItemStack((ItemLike)Items.PINK_STAINED_GLASS, 3), 5, 6, 0.05f)}).build();
    }

    private static Map<Integer, VillagerTrades.ItemListing[]> buildRailwrightTrades() {
        return ImmutableMap.builder().put((Object)1, (Object)new VillagerTrades.ItemListing[]{(trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.IRON_INGOT, 4), new ItemStack((ItemLike)Items.EMERALD, 1), 12, 3, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.STICK, 16), new ItemStack((ItemLike)Items.EMERALD, 1), 12, 1, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.GOLD_INGOT, 3), new ItemStack((ItemLike)Items.EMERALD, 1), 10, 6, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.REDSTONE, 12), new ItemStack((ItemLike)Items.EMERALD, 1), 12, 2, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.MINECART, 1), new ItemStack((ItemLike)Items.EMERALD, 1), 8, 7, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.HOPPER, 1), new ItemStack((ItemLike)Items.EMERALD, 1), 5, 10, 0.05f)}).put((Object)2, (Object)new VillagerTrades.ItemListing[]{(trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 1), new ItemStack((ItemLike)Items.REDSTONE, 10), 6, 5, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 1), new ItemStack((ItemLike)Items.POWERED_RAIL, 3), 6, 5, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 1), new ItemStack((ItemLike)Items.DETECTOR_RAIL, 3), 6, 5, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 1), new ItemStack((ItemLike)Items.ACTIVATOR_RAIL, 3), 6, 5, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 3), new ItemStack((ItemLike)Items.MINECART, 1), 8, 7, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 3), new ItemStack((ItemLike)Items.HOPPER, 1), 5, 10, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 6), new ItemStack((ItemLike)Items.HOPPER_MINECART, 1), 3, 12, 0.05f)}).build();
    }

    private static Map<Integer, VillagerTrades.ItemListing[]> buildRelicScavengerTrades() {
        return ImmutableMap.builder().put((Object)1, (Object)new VillagerTrades.ItemListing[]{(trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.IRON_SHOVEL, 1), new ItemStack((ItemLike)Items.EMERALD, 1), 5, 5, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.BRUSH, 1), new ItemStack((ItemLike)Items.EMERALD, 2), 4, 8, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.TORCH, 10), new ItemStack((ItemLike)Items.EMERALD, 1), 8, 3, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.IRON_INGOT, 3), new ItemStack((ItemLike)Items.EMERALD, 1), 8, 4, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.IRON_PICKAXE, 1), new ItemStack((ItemLike)Items.EMERALD, 2), 8, 4, 0.05f)}).put((Object)2, (Object)new VillagerTrades.ItemListing[]{(trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 3), new ItemStack((ItemLike)Items.ANGLER_POTTERY_SHERD, 1), 2, 10, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 3), new ItemStack((ItemLike)Items.ARCHER_POTTERY_SHERD, 1), 2, 10, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 3), new ItemStack((ItemLike)Items.ARMS_UP_POTTERY_SHERD, 1), 2, 10, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 3), new ItemStack((ItemLike)Items.BLADE_POTTERY_SHERD, 1), 2, 10, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 3), new ItemStack((ItemLike)Items.BREWER_POTTERY_SHERD, 1), 2, 10, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 3), new ItemStack((ItemLike)Items.BURN_POTTERY_SHERD, 1), 2, 10, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 3), new ItemStack((ItemLike)Items.DANGER_POTTERY_SHERD, 1), 2, 10, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 3), new ItemStack((ItemLike)Items.EXPLORER_POTTERY_SHERD, 1), 2, 10, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 3), new ItemStack((ItemLike)Items.FRIEND_POTTERY_SHERD, 1), 2, 10, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 3), new ItemStack((ItemLike)Items.HEART_POTTERY_SHERD, 1), 2, 10, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 3), new ItemStack((ItemLike)Items.HEARTBREAK_POTTERY_SHERD, 1), 2, 10, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 3), new ItemStack((ItemLike)Items.HOWL_POTTERY_SHERD, 1), 2, 10, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 3), new ItemStack((ItemLike)Items.MINER_POTTERY_SHERD, 1), 2, 10, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 3), new ItemStack((ItemLike)Items.MOURNER_POTTERY_SHERD, 1), 2, 10, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 3), new ItemStack((ItemLike)Items.PLENTY_POTTERY_SHERD, 1), 2, 10, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 3), new ItemStack((ItemLike)Items.PRIZE_POTTERY_SHERD, 1), 2, 10, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 3), new ItemStack((ItemLike)Items.SHEAF_POTTERY_SHERD, 1), 2, 10, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 3), new ItemStack((ItemLike)Items.SHELTER_POTTERY_SHERD, 1), 2, 10, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 3), new ItemStack((ItemLike)Items.SKULL_POTTERY_SHERD, 1), 2, 10, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 3), new ItemStack((ItemLike)Items.SNORT_POTTERY_SHERD, 1), 2, 10, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 1), new ItemStack((ItemLike)Items.CLAY_BALL, 6), 10, 2, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 1), new ItemStack((ItemLike)Items.BRICK, 5), 10, 3, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 1), new ItemStack((ItemLike)Items.FLOWER_POT, 1), 12, 5, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 3), new ItemStack((ItemLike)Items.OAK_HANGING_SIGN, 1), 5, 8, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 1), new ItemStack((ItemLike)Items.BROWN_CANDLE, 1), 10, 4, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 1), new ItemStack((ItemLike)Items.GOLD_NUGGET, 5), 12, 6, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 12), new ItemStack((ItemLike)Items.SENTRY_ARMOR_TRIM_SMITHING_TEMPLATE, 1), 1, 15, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 12), new ItemStack((ItemLike)Items.DUNE_ARMOR_TRIM_SMITHING_TEMPLATE, 1), 1, 15, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 12), new ItemStack((ItemLike)Items.COAST_ARMOR_TRIM_SMITHING_TEMPLATE, 1), 1, 15, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 12), new ItemStack((ItemLike)Items.WILD_ARMOR_TRIM_SMITHING_TEMPLATE, 1), 1, 15, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 12), new ItemStack((ItemLike)Items.WARD_ARMOR_TRIM_SMITHING_TEMPLATE, 1), 1, 15, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 12), new ItemStack((ItemLike)Items.EYE_ARMOR_TRIM_SMITHING_TEMPLATE, 1), 1, 15, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 12), new ItemStack((ItemLike)Items.VEX_ARMOR_TRIM_SMITHING_TEMPLATE, 1), 1, 15, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 12), new ItemStack((ItemLike)Items.TIDE_ARMOR_TRIM_SMITHING_TEMPLATE, 1), 1, 15, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 12), new ItemStack((ItemLike)Items.SNOUT_ARMOR_TRIM_SMITHING_TEMPLATE, 1), 1, 15, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 12), new ItemStack((ItemLike)Items.RIB_ARMOR_TRIM_SMITHING_TEMPLATE, 1), 1, 15, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 12), new ItemStack((ItemLike)Items.SPIRE_ARMOR_TRIM_SMITHING_TEMPLATE, 1), 1, 15, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 12), new ItemStack((ItemLike)Items.WAYFINDER_ARMOR_TRIM_SMITHING_TEMPLATE, 1), 1, 15, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 12), new ItemStack((ItemLike)Items.SHAPER_ARMOR_TRIM_SMITHING_TEMPLATE, 1), 1, 15, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 12), new ItemStack((ItemLike)Items.SILENCE_ARMOR_TRIM_SMITHING_TEMPLATE, 1), 1, 15, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 12), new ItemStack((ItemLike)Items.RAISER_ARMOR_TRIM_SMITHING_TEMPLATE, 1), 1, 15, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 12), new ItemStack((ItemLike)Items.HOST_ARMOR_TRIM_SMITHING_TEMPLATE, 1), 1, 15, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 3), new ItemStack((ItemLike)Items.BRUSH, 1), 4, 8, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 15), new ItemStack((ItemLike)Items.MUSIC_DISC_RELIC, 1), 1, 20, 0.05f)}).build();
    }

    private static Map<Integer, VillagerTrades.ItemListing[]> buildPiglinTraderTrades() {
        return ImmutableMap.builder().put((Object)1, (Object)new VillagerTrades.ItemListing[]{(trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.RAW_GOLD, 8), new ItemStack((ItemLike)Items.EMERALD, 1), 5, 5, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.GOLD_NUGGET, 10), new ItemStack((ItemLike)Items.EMERALD, 1), 5, 2, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.COOKED_PORKCHOP, 5), new ItemStack((ItemLike)Items.EMERALD, 1), 8, 4, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.GOLDEN_CARROT, 3), new ItemStack((ItemLike)Items.EMERALD, 1), 1, 10, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.GLISTERING_MELON_SLICE, 3), new ItemStack((ItemLike)Items.EMERALD, 1), 1, 10, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.GOLDEN_APPLE, 1), new ItemStack((ItemLike)Items.EMERALD, 7), 3, 12, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.ENCHANTED_GOLDEN_APPLE, 1), new ItemStack((ItemLike)Items.EMERALD, 20), 1, 25, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.GOLDEN_HELMET, 1), new ItemStack((ItemLike)Items.EMERALD, 4), 4, 8, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.GOLDEN_CHESTPLATE, 1), new ItemStack((ItemLike)Items.EMERALD, 5), 4, 8, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.GOLDEN_LEGGINGS, 1), new ItemStack((ItemLike)Items.EMERALD, 5), 4, 8, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.GOLDEN_BOOTS, 1), new ItemStack((ItemLike)Items.EMERALD, 3), 4, 8, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.GOLDEN_SWORD, 1), new ItemStack((ItemLike)Items.EMERALD, 2), 5, 6, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.GOLDEN_PICKAXE, 1), new ItemStack((ItemLike)Items.EMERALD, 2), 5, 6, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.GOLDEN_AXE, 1), new ItemStack((ItemLike)Items.EMERALD, 2), 5, 6, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.GOLDEN_SHOVEL, 1), new ItemStack((ItemLike)Items.EMERALD, 1), 5, 6, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.GOLDEN_HOE, 1), new ItemStack((ItemLike)Items.EMERALD, 1), 5, 6, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.GOLDEN_HORSE_ARMOR, 1), new ItemStack((ItemLike)Items.EMERALD, 6), 2, 15, 0.05f)}).put((Object)2, (Object)new VillagerTrades.ItemListing[]{(trader, rand) -> {
            Registry enchantmentRegistry = trader.level().registryAccess().registryOrThrow(Registries.ENCHANTMENT);
            Holder.Reference soulSpeedHolder = enchantmentRegistry.getHolderOrThrow(Enchantments.SOUL_SPEED);
            ItemStack book = new ItemStack((ItemLike)Items.ENCHANTED_BOOK);
            ItemEnchantments.Mutable mutableEnchantments = new ItemEnchantments.Mutable(ItemEnchantments.EMPTY);
            mutableEnchantments.set((Holder)soulSpeedHolder, ((Enchantment)soulSpeedHolder.value()).getMaxLevel());
            book.set(DataComponents.STORED_ENCHANTMENTS, (Object)mutableEnchantments.toImmutable());
            return new MerchantOffer(new ItemCost((ItemLike)Items.GOLD_INGOT, 12), book, 3, 15, 0.05f);
        }, (trader, rand) -> {
            Registry enchantmentRegistry = trader.level().registryAccess().registryOrThrow(Registries.ENCHANTMENT);
            Holder.Reference soulSpeedHolder = enchantmentRegistry.getHolderOrThrow(Enchantments.SOUL_SPEED);
            ItemStack sellStack = new ItemStack((ItemLike)Items.IRON_BOOTS, 1);
            sellStack.enchant((Holder)soulSpeedHolder, ((Enchantment)soulSpeedHolder.value()).getMaxLevel());
            return new MerchantOffer(new ItemCost((ItemLike)Items.GOLD_INGOT, 10), sellStack, 3, 15, 0.05f);
        }, (trader, rand) -> {
            ItemStack sellStack = PotionContents.createItemStack((Item)Items.SPLASH_POTION, (Holder)Potions.FIRE_RESISTANCE);
            return new MerchantOffer(new ItemCost((ItemLike)Items.GOLD_INGOT, 4), sellStack, 5, 8, 0.05f);
        }, (trader, rand) -> {
            ItemStack sellStack = PotionContents.createItemStack((Item)Items.POTION, (Holder)Potions.FIRE_RESISTANCE);
            return new MerchantOffer(new ItemCost((ItemLike)Items.GOLD_INGOT, 3), sellStack, 5, 8, 0.05f);
        }, (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.GOLD_INGOT, 5), new ItemStack((ItemLike)Items.GHAST_TEAR, 1), 4, 10, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.GOLD_INGOT, 1), new ItemStack((ItemLike)Items.IRON_NUGGET, 9), 10, 3, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.GOLD_INGOT, 3), new ItemStack((ItemLike)Items.ENDER_PEARL, 1), 5, 8, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.GOLD_INGOT, 1), new ItemStack((ItemLike)Items.QUARTZ, 8), 10, 4, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.GOLD_INGOT, 1), new ItemStack((ItemLike)Items.OBSIDIAN, 2), 8, 6, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.GOLD_INGOT, 2), new ItemStack((ItemLike)Items.CRYING_OBSIDIAN, 1), 8, 7, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.GOLD_INGOT, 1), new ItemStack((ItemLike)Items.FIRE_CHARGE, 3), 10, 5, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.GOLD_INGOT, 1), new ItemStack((ItemLike)Items.LEATHER, 4), 10, 3, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.GOLD_INGOT, 1), new ItemStack((ItemLike)Items.NETHER_BRICK, 8), 10, 4, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.GOLD_INGOT, 1), new ItemStack((ItemLike)Items.SPECTRAL_ARROW, 2), 10, 6, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.GOLD_INGOT, 1), new ItemStack((ItemLike)Items.GRAVEL, 8), 10, 1, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.GOLD_INGOT, 1), new ItemStack((ItemLike)Items.BLACKSTONE, 4), 10, 2, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.GOLD_INGOT, 1), new ItemStack((ItemLike)Items.GLISTERING_MELON_SLICE, 1), 10, 4, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.GOLD_INGOT, 12), new ItemStack((ItemLike)Items.GOLDEN_APPLE, 1), 3, 10, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.GOLD_INGOT, 40), new ItemStack((ItemLike)Items.ENCHANTED_GOLDEN_APPLE, 1), 1, 20, 0.2f)}).build();
    }

    private static Map<Integer, VillagerTrades.ItemListing[]> buildBeachcomberTrades() {
        return ImmutableMap.builder().put((Object)1, (Object)new VillagerTrades.ItemListing[]{(trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.SAND, 6), new ItemStack((ItemLike)Items.EMERALD, 1), 10, 2, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.KELP, 12), new ItemStack((ItemLike)Items.EMERALD, 1), 8, 3, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.DRIED_KELP, 10), new ItemStack((ItemLike)Items.EMERALD, 1), 8, 3, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.SUGAR_CANE, 6), new ItemStack((ItemLike)Items.EMERALD, 1), 10, 2, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.TROPICAL_FISH, 3), new ItemStack((ItemLike)Items.EMERALD, 1), 6, 5, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.NAUTILUS_SHELL, 1), new ItemStack((ItemLike)Items.EMERALD, 2), 5, 10, 0.05f)}).put((Object)2, (Object)new VillagerTrades.ItemListing[]{(trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 1), new ItemStack((ItemLike)Items.TROPICAL_FISH, 2), 10, 2, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 1), new ItemStack((ItemLike)Items.SAND, 4), 10, 2, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 1), new ItemStack((ItemLike)Items.SANDSTONE, 4), 10, 3, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 1), new ItemStack((ItemLike)Items.KELP, 10), 8, 4, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 1), new ItemStack((ItemLike)Items.DRIED_KELP_BLOCK, 1), 8, 4, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 1), new ItemStack((ItemLike)Items.SEA_PICKLE, 2), 8, 4, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 1), new ItemStack((ItemLike)Items.SUGAR_CANE, 5), 10, 2, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 4), new ItemStack((ItemLike)Items.NAUTILUS_SHELL, 1), 3, 10, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 25), new ItemStack((ItemLike)Items.HEART_OF_THE_SEA, 1), 1, 20, 0.2f)}).build();
    }

    private static Map<Integer, VillagerTrades.ItemListing[]> buildEnchantsmithTrades() {
        return ImmutableMap.builder().put((Object)1, (Object)new VillagerTrades.ItemListing[]{new RandomEnchantedBookFactory(2), new RandomEnchantedBookFactory(5), new RandomEnchantedBookFactory(10), new RandomEnchantedBookFactory(10)}).put((Object)2, (Object)new VillagerTrades.ItemListing[]{new RandomEnchantedBookFactory(2), new RandomEnchantedBookFactory(5), new RandomEnchantedBookFactory(10), new RandomEnchantedBookFactory(10)}).build();
    }

    private static Map<Integer, VillagerTrades.ItemListing[]> buildRedstoneEngineerTrades() {
        return ImmutableMap.builder().put((Object)1, (Object)new VillagerTrades.ItemListing[]{(trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.REDSTONE, 10), new ItemStack((ItemLike)Items.EMERALD, 1), 8, 2, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.COBBLESTONE, 16), new ItemStack((ItemLike)Items.EMERALD, 1), 10, 1, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.SLIME_BALL, 2), new ItemStack((ItemLike)Items.EMERALD, 1), 6, 6, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.PISTON, 1), new ItemStack((ItemLike)Items.EMERALD, 2), 6, 5, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.OBSERVER, 1), new ItemStack((ItemLike)Items.EMERALD, 3), 5, 7, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.REDSTONE_LAMP, 1), new ItemStack((ItemLike)Items.EMERALD, 2), 5, 6, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.REPEATER, 1), new ItemStack((ItemLike)Items.EMERALD, 1), 6, 5, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.LEVER, 4), new ItemStack((ItemLike)Items.EMERALD, 1), 10, 2, 0.05f)}).put((Object)2, (Object)new VillagerTrades.ItemListing[]{(trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 1), new ItemStack((ItemLike)Items.REDSTONE, 8), 8, 2, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 1), new ItemStack((ItemLike)Items.REDSTONE_TORCH, 2), 8, 3, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 2), new ItemStack((ItemLike)Items.REPEATER, 1), 6, 5, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 3), new ItemStack((ItemLike)Items.COMPARATOR, 1), 5, 6, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 3), new ItemStack((ItemLike)Items.PISTON, 1), 6, 5, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 5), new ItemStack((ItemLike)Items.STICKY_PISTON, 1), 5, 8, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 4), new ItemStack((ItemLike)Items.OBSERVER, 1), 5, 7, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 2), new ItemStack((ItemLike)Items.DROPPER, 1), 6, 4, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 4), new ItemStack((ItemLike)Items.DISPENSER, 1), 4, 7, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 2), new ItemStack((ItemLike)Items.REDSTONE_BLOCK, 1), 6, 4, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 3), new ItemStack((ItemLike)Items.REDSTONE_LAMP, 1), 5, 6, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 4), new ItemStack((ItemLike)Items.SLIME_BLOCK, 1), 4, 8, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 1), new ItemStack((ItemLike)Items.LEVER, 2), 10, 2, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 1), new ItemStack((ItemLike)Items.STONE_BUTTON, 4), 10, 1, 0.05f)}).build();
    }

    private static Map<Integer, VillagerTrades.ItemListing[]> buildPyrotechnicTrades() {
        return ImmutableMap.builder().put((Object)1, (Object)new VillagerTrades.ItemListing[]{(trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.GUNPOWDER, 5), new ItemStack((ItemLike)Items.EMERALD, 1), 10, 2, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.WHITE_DYE, 12), new ItemStack((ItemLike)Items.EMERALD, 1), 8, 3, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.LIGHT_GRAY_DYE, 12), new ItemStack((ItemLike)Items.EMERALD, 1), 8, 3, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.GRAY_DYE, 12), new ItemStack((ItemLike)Items.EMERALD, 1), 8, 3, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.BLACK_DYE, 12), new ItemStack((ItemLike)Items.EMERALD, 1), 8, 3, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.BROWN_DYE, 12), new ItemStack((ItemLike)Items.EMERALD, 1), 8, 3, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.RED_DYE, 12), new ItemStack((ItemLike)Items.EMERALD, 1), 8, 3, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.ORANGE_DYE, 12), new ItemStack((ItemLike)Items.EMERALD, 1), 8, 3, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.YELLOW_DYE, 12), new ItemStack((ItemLike)Items.EMERALD, 1), 8, 3, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.LIME_DYE, 12), new ItemStack((ItemLike)Items.EMERALD, 1), 8, 3, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.GREEN_DYE, 12), new ItemStack((ItemLike)Items.EMERALD, 1), 8, 3, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.CYAN_DYE, 12), new ItemStack((ItemLike)Items.EMERALD, 1), 8, 3, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.LIGHT_BLUE_DYE, 12), new ItemStack((ItemLike)Items.EMERALD, 1), 8, 3, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.BLUE_DYE, 12), new ItemStack((ItemLike)Items.EMERALD, 1), 8, 3, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.PURPLE_DYE, 12), new ItemStack((ItemLike)Items.EMERALD, 1), 8, 3, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.MAGENTA_DYE, 12), new ItemStack((ItemLike)Items.EMERALD, 1), 8, 3, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.PINK_DYE, 12), new ItemStack((ItemLike)Items.EMERALD, 1), 8, 3, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.GLOWSTONE_DUST, 3), new ItemStack((ItemLike)Items.EMERALD, 1), 6, 5, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.DIAMOND, 1), new ItemStack((ItemLike)Items.EMERALD, 10), 3, 10, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.FEATHER, 4), new ItemStack((ItemLike)Items.EMERALD, 1), 6, 4, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.GOLD_NUGGET, 2), new ItemStack((ItemLike)Items.EMERALD, 1), 6, 6, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.CREEPER_HEAD, 1), new ItemStack((ItemLike)Items.EMERALD, 25), 2, 15, 0.05f)}).put((Object)2, (Object)new VillagerTrades.ItemListing[]{(trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 1), new ItemStack((ItemLike)Items.PAPER, 5), 10, 1, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 2), new ItemStack((ItemLike)Items.FLINT_AND_STEEL, 1), 3, 5, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 4), new ItemStack((ItemLike)Items.TNT, 1), 5, 8, 0.05f), (trader, rand) -> {
            ItemStack rocket = new ItemStack((ItemLike)Items.FIREWORK_ROCKET, 3);
            rocket.set(DataComponents.FIREWORKS, (Object)new Fireworks(1, Collections.emptyList()));
            return new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 1), rocket, 8, 3, 0.05f);
        }, (trader, rand) -> {
            ItemStack rocket = new ItemStack((ItemLike)Items.FIREWORK_ROCKET, 2);
            rocket.set(DataComponents.FIREWORKS, (Object)new Fireworks(2, Collections.emptyList()));
            return new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 1), rocket, 8, 4, 0.05f);
        }, (trader, rand) -> {
            ItemStack rocket = new ItemStack((ItemLike)Items.FIREWORK_ROCKET, 1);
            rocket.set(DataComponents.FIREWORKS, (Object)new Fireworks(3, Collections.emptyList()));
            return new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 1), rocket, 8, 5, 0.05f);
        }, new RandomFireworkStarFactory(1, 12, 5), new RandomFireworkStarFactory(1, 12, 5), new RandomRocketFactory(3, 8, 10), new RandomRocketFactory(3, 8, 10)}).build();
    }

    private static Map<Integer, VillagerTrades.ItemListing[]> buildMycologistTrades() {
        return ImmutableMap.builder().put((Object)1, (Object)new VillagerTrades.ItemListing[]{(trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.BOWL, 4), new ItemStack((ItemLike)Items.EMERALD, 1), 8, 2, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.BONE_MEAL, 15), new ItemStack((ItemLike)Items.EMERALD, 1), 5, 4, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.RED_MUSHROOM, 8), new ItemStack((ItemLike)Items.EMERALD, 1), 8, 2, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.BROWN_MUSHROOM, 8), new ItemStack((ItemLike)Items.EMERALD, 1), 8, 2, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.DANDELION, 10), new ItemStack((ItemLike)Items.EMERALD, 1), 8, 3, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.POPPY, 10), new ItemStack((ItemLike)Items.EMERALD, 1), 8, 3, 0.05f)}).put((Object)2, (Object)new VillagerTrades.ItemListing[]{(trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 1), new ItemStack((ItemLike)Items.RED_MUSHROOM, 5), 5, 2, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 1), new ItemStack((ItemLike)Items.BROWN_MUSHROOM, 5), 5, 2, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 1), new ItemStack((ItemLike)Items.MYCELIUM, 2), 3, 5, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 1), new ItemStack((ItemLike)Items.RED_MUSHROOM_BLOCK, 1), 4, 4, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 1), new ItemStack((ItemLike)Items.BROWN_MUSHROOM_BLOCK, 1), 4, 4, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 1), new ItemStack((ItemLike)Items.MUSHROOM_STEM, 2), 4, 4, 0.05f), (trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 1), new ItemStack((ItemLike)Items.MUSHROOM_STEW, 1), 8, 3, 0.05f), new RandomSuspiciousStewFactory(3, 2, 8)}).build();
    }
}

