/*
 * Decompiled with CFR 0.152.
 */
package net.redstonegames.visitingvillagers.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.redstonegames.visitingvillagers.entity.ModEntities;
import net.redstonegames.visitingvillagers.entity.custom.BabyVisitorEntity;
import net.redstonegames.visitingvillagers.entity.custom.VisitorEntity;
import net.redstonegames.visitingvillagers.entity.custom.WanderingVisitorEntity;
import net.redstonegames.visitingvillagers.util.ModTags;

@Mod.EventBusSubscriber(modid="visitingvillagers")
public class VisitorCommands {
    @SubscribeEvent
    public static void onCommandsRegister(RegisterCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"visitors").then(Commands.m_82127_((String)"check").executes(VisitorCommands::runCheckCommand))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"clear").requires(source -> source.m_6761_(2))).then(Commands.m_82129_((String)"radius", (ArgumentType)IntegerArgumentType.integer((int)1, (int)512)).executes(context -> VisitorCommands.runClearCommand((CommandContext<CommandSourceStack>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"radius")))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"population").requires(source -> source.m_6761_(2))).then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1, (int)250)).then(Commands.m_82129_((String)"radius", (ArgumentType)IntegerArgumentType.integer((int)10, (int)500)).executes(context -> VisitorCommands.runPopulationCommand((CommandContext<CommandSourceStack>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"amount"), IntegerArgumentType.getInteger((CommandContext)context, (String)"radius")))))));
    }

    private static int runPopulationCommand(CommandContext<CommandSourceStack> context, int amount, int radius) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ServerPlayer player = source.m_81375_();
        ServerLevel level = player.m_284548_();
        Random random = new Random();
        int visitorsSpawned = 0;
        int maxTriesPerVisitor = 10;
        block0: for (int i = 0; i < amount; ++i) {
            for (int tryNum = 0; tryNum < maxTriesPerVisitor; ++tryNum) {
                double z;
                int y;
                double angle = random.nextDouble() * 2.0 * Math.PI;
                double distance = Math.sqrt(random.nextDouble()) * (double)radius;
                double x = player.m_20185_() + distance * Math.cos(angle);
                BlockPos groundPos = new BlockPos((int)x, (y = level.m_6924_(Heightmap.Types.WORLD_SURFACE, (int)x, (int)(z = player.m_20189_() + distance * Math.sin(angle)))) - 1, (int)z);
                if (!level.m_8055_(groundPos).m_204336_(ModTags.Blocks.VISITORS_SPAWNABLE_ON)) continue;
                BlockPos spawnPos = groundPos.m_7494_();
                VisitorEntity visitor = (VisitorEntity)((EntityType)ModEntities.VISITOR.get()).m_20615_((Level)level);
                if (visitor == null) continue;
                visitor.m_7678_((double)spawnPos.m_123341_() + 0.5, spawnPos.m_123342_(), (double)spawnPos.m_123343_() + 0.5, random.nextFloat() * 360.0f, 0.0f);
                visitor.m_6518_((ServerLevelAccessor)level, level.m_6436_(spawnPos), MobSpawnType.COMMAND, null, null);
                level.m_7967_((Entity)visitor);
                ++visitorsSpawned;
                continue block0;
            }
        }
        MutableComponent message = Component.m_237113_((String)("\u00a7a" + visitorsSpawned + "\u00a7f visitor(s) spawned on valid blocks within a radius of \u00a7e" + radius + "\u00a7f blocks."));
        source.m_288197_(() -> VisitorCommands.lambda$runPopulationCommand$4((Component)message), true);
        return visitorsSpawned;
    }

    private static int runCheckCommand(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ServerPlayer player = source.m_81375_();
        ServerLevel level = player.m_284548_();
        AABB searchBox = new AABB(player.m_20183_()).m_82400_(128.0);
        List villagers = level.m_6443_(Villager.class, searchBox, e -> true);
        List golems = level.m_6443_(IronGolem.class, searchBox, e -> true);
        List allVisitors = level.m_6443_(VisitorEntity.class, searchBox, e -> true);
        List wanderingVisitors = level.m_6443_(WanderingVisitorEntity.class, searchBox, e -> true);
        ArrayList<VisitorEntity> adultVisitors = new ArrayList<VisitorEntity>();
        ArrayList<BabyVisitorEntity> babyVisitors = new ArrayList<BabyVisitorEntity>();
        for (VisitorEntity visitor : allVisitors) {
            if (visitor instanceof BabyVisitorEntity) {
                babyVisitors.add((BabyVisitorEntity)visitor);
                continue;
            }
            adultVisitors.add(visitor);
        }
        MutableComponent message = Component.m_237113_((String)(" \u00a7bVisitor: \u00a7e" + adultVisitors.size() + "\u00a7f \u00a7aVillager: \u00a7e" + villagers.size() + "\u00a7f \u00a7bBaby: \u00a7e" + babyVisitors.size() + "\u00a7f \u00a7aGolem: \u00a7e" + golems.size() + "\u00a7f \u00a7bWander: \u00a7e" + wanderingVisitors.size() + "\u00a7f"));
        source.m_288197_(() -> VisitorCommands.lambda$runCheckCommand$9((Component)message), false);
        return 1;
    }

    private static int runClearCommand(CommandContext<CommandSourceStack> context, int radius) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ServerPlayer player = source.m_81375_();
        ServerLevel level = player.m_284548_();
        AABB searchBox = new AABB(player.m_20183_()).m_82400_((double)radius);
        List villageVisitors = level.m_6443_(VisitorEntity.class, searchBox, e -> true);
        List wanderingVisitors = level.m_6443_(WanderingVisitorEntity.class, searchBox, e -> true);
        int villageCount = villageVisitors.size();
        int wanderingCount = wanderingVisitors.size();
        int totalCount = villageCount + wanderingCount;
        villageVisitors.forEach(Entity::m_146870_);
        wanderingVisitors.forEach(Entity::m_146870_);
        MutableComponent message = Component.m_237113_((String)("\u00a7c" + totalCount + "\u00a7f visitor(s) removed within a radius of \u00a7e" + radius + "\u00a7f blocks. (" + villageCount + " visitors, " + wanderingCount + " wandering)"));
        source.m_288197_(() -> VisitorCommands.lambda$runClearCommand$12((Component)message), true);
        return totalCount;
    }

    private static /* synthetic */ Component lambda$runClearCommand$12(Component message) {
        return message;
    }

    private static /* synthetic */ Component lambda$runCheckCommand$9(Component message) {
        return message;
    }

    private static /* synthetic */ Component lambda$runPopulationCommand$4(Component message) {
        return message;
    }
}

