/*
 * Decompiled with CFR 0.152.
 */
package net.redstonegames.visitingvillagers.entity.ai;

import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.redstonegames.visitingvillagers.entity.custom.WanderingVisitorEntity;

public class DespawnAtNightGoal
extends Goal {
    private final Mob mob;
    private final Level level;
    private final double despawnDistance;
    private final boolean removeLeashedAnimals;
    private int checkCooldown;

    public DespawnAtNightGoal(Mob mob, double despawnDistance, boolean removeLeashedAnimals) {
        this.mob = mob;
        this.level = mob.m_9236_();
        this.despawnDistance = despawnDistance * despawnDistance;
        this.removeLeashedAnimals = removeLeashedAnimals;
        this.m_7021_(EnumSet.noneOf(Goal.Flag.class));
    }

    public boolean m_8036_() {
        if (this.checkCooldown-- > 0) {
            return false;
        }
        this.checkCooldown = 40;
        return this.level.m_46462_() && !this.mob.m_21532_() && this.isPlayerTooFar();
    }

    public void m_8056_() {
        Mob mob;
        if (this.removeLeashedAnimals && (mob = this.mob) instanceof WanderingVisitorEntity) {
            WanderingVisitorEntity wanderingVisitor = (WanderingVisitorEntity)mob;
            wanderingVisitor.removeLeashedAnimals();
        }
        this.mob.m_146870_();
    }

    private boolean isPlayerTooFar() {
        return this.level.m_45930_((Entity)this.mob, -1.0) == null || this.level.m_45930_((Entity)this.mob, -1.0).m_20280_((Entity)this.mob) > this.despawnDistance;
    }
}

