/*
 * Decompiled with CFR 0.152.
 */
package net.redstonegames.visitingvillagers.entity.ai;

import java.util.ArrayList;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.redstonegames.visitingvillagers.entity.custom.VisitorEntity;
import net.redstonegames.visitingvillagers.util.ModTags;

public class FindTaggedBlockGoal
extends Goal {
    private final VisitorEntity visitor;
    private final int searchRadius;
    private final int chance;

    public FindTaggedBlockGoal(VisitorEntity visitor, int searchRadius, int chance) {
        this.visitor = visitor;
        this.searchRadius = searchRadius;
        this.chance = chance;
        this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (this.visitor.getTaggedBlockTarget() != null) {
            return false;
        }
        return this.visitor.m_217043_().m_188503_(this.chance) == 0;
    }

    public boolean m_8045_() {
        return false;
    }

    public void m_8056_() {
        BlockPos target = this.findRandomTaggedBlock();
        if (target != null) {
            this.visitor.setTaggedBlockTarget(target);
        } else {
            Level level = this.visitor.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (this.visitor.m_217043_().m_188501_() < 0.9f) {
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123792_, this.visitor.m_20185_(), this.visitor.m_20186_() + (double)this.visitor.m_20192_() + 0.5, this.visitor.m_20189_(), 1, 0.1, 0.1, 0.1, 0.0);
                }
            }
        }
    }

    private BlockPos findRandomTaggedBlock() {
        ArrayList<BlockPos> validTargets = new ArrayList<BlockPos>();
        int verticalRange = 5;
        for (int y = -verticalRange; y <= verticalRange; ++y) {
            for (int x = -this.searchRadius; x <= this.searchRadius; ++x) {
                for (int z = -this.searchRadius; z <= this.searchRadius; ++z) {
                    BlockPos currentPos = this.visitor.m_20183_().m_7918_(x, y, z);
                    if (!this.visitor.m_9236_().m_8055_(currentPos).m_204336_(ModTags.Blocks.VISITOR_PREFERRED_BLOCKS)) continue;
                    validTargets.add(currentPos);
                }
            }
        }
        if (!validTargets.isEmpty()) {
            return (BlockPos)validTargets.get(this.visitor.m_217043_().m_188503_(validTargets.size()));
        }
        return null;
    }
}

