/*
 * Decompiled with CFR 0.152.
 */
package net.redstonegames.visitingvillagers.entity.ai;

import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class GoToPoiGoal
extends Goal {
    private static final double HORIZONTAL_REACH_DISTANCE_SQUARED = 4.0;
    private static final double VERTICAL_REACH_DISTANCE = 2.0;
    protected final PathfinderMob mob;
    private final Predicate<Holder<PoiType>> poiTypePredicate;
    private final int searchRadius;
    private final double speed;
    private final int chance;
    private Optional<BlockPos> targetPos = Optional.empty();
    private boolean hasReached;

    public GoToPoiGoal(PathfinderMob mob, double speed, Predicate<Holder<PoiType>> poiTypePredicate, int searchRadius, int chance) {
        this.mob = mob;
        this.speed = speed;
        this.poiTypePredicate = poiTypePredicate;
        this.searchRadius = searchRadius;
        this.chance = chance;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        if (!this.mob.m_21573_().m_26571_()) {
            return false;
        }
        if (this.mob.m_217043_().m_188503_(this.chance) != 0) {
            return false;
        }
        this.findTarget();
        return this.targetPos.isPresent();
    }

    private void findTarget() {
        ServerLevel world = (ServerLevel)this.mob.m_9236_();
        PoiManager poiManager = world.m_8904_();
        List possibleTargets = poiManager.m_27138_(this.poiTypePredicate, pos -> true, this.mob.m_20183_(), this.searchRadius, PoiManager.Occupancy.ANY).map(BlockPos::m_7949_).collect(Collectors.toList());
        this.targetPos = !possibleTargets.isEmpty() ? Optional.of((BlockPos)possibleTargets.get(this.mob.m_217043_().m_188503_(possibleTargets.size()))) : Optional.empty();
    }

    public void m_8056_() {
        this.hasReached = false;
        this.targetPos.ifPresent(target -> this.mob.m_21573_().m_26519_((double)target.m_123341_() + 0.5, (double)target.m_123342_(), (double)target.m_123343_() + 0.5, this.speed));
    }

    public boolean m_8045_() {
        if (this.targetPos.isEmpty() || this.hasReached) {
            return false;
        }
        if (this.isCloseEnough(this.mob, this.targetPos.get())) {
            this.hasReached = true;
            return false;
        }
        return !this.mob.m_21573_().m_26571_();
    }

    private boolean isCloseEnough(PathfinderMob mob, BlockPos target) {
        Vec3 mobPos = mob.m_20182_();
        Vec3 targetCenter = Vec3.m_82512_((Vec3i)target);
        double dx = mobPos.f_82479_ - targetCenter.f_82479_;
        double dy = mobPos.f_82480_ - targetCenter.f_82480_;
        double dz = mobPos.f_82481_ - targetCenter.f_82481_;
        double horizontalDistanceSq = dx * dx + dz * dz;
        return horizontalDistanceSq < 4.0 && Math.abs(dy) < 2.0;
    }

    public void m_8041_() {
        Level level = this.mob.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)level;
            if (this.hasReached) {
                serverWorld.m_8767_((ParticleOptions)ParticleTypes.f_123748_, this.mob.m_20185_(), this.mob.m_20186_() + (double)this.mob.m_20206_() + 0.5, this.mob.m_20189_(), 5, 0.3, 0.3, 0.3, 0.0);
            } else if (this.targetPos.isPresent() && this.mob.m_217043_().m_188501_() < 0.5f) {
                serverWorld.m_8767_((ParticleOptions)ParticleTypes.f_123792_, this.mob.m_20185_(), this.mob.m_20186_() + (double)this.mob.m_20206_() + 0.5, this.mob.m_20189_(), 1, 0.3, 0.3, 0.3, 0.0);
            }
        }
        this.mob.m_21573_().m_26573_();
        this.targetPos = Optional.empty();
        this.hasReached = false;
    }
}

