/*
 * Decompiled with CFR 0.152.
 */
package net.redstonegames.visitingvillagers.entity.ai;

import java.util.ArrayList;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.redstonegames.visitingvillagers.entity.custom.VisitorEntity;
import net.redstonegames.visitingvillagers.util.ModTags;

public class GoToTaggedBlockGoal
extends Goal {
    private static final double HORIZONTAL_REACH_DISTANCE_SQUARED = 1.0;
    private static final double VERTICAL_REACH_DISTANCE = 2.0;
    private final VisitorEntity mob;
    private final double speed;
    private BlockPos targetPos;
    private boolean hasReached;

    public GoToTaggedBlockGoal(VisitorEntity mob, double speed) {
        this.mob = mob;
        this.speed = speed;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (this.mob.m_21573_().m_26571_()) {
            return this.mob.m_217043_().m_188503_(120) == 0;
        }
        return false;
    }

    public void m_8056_() {
        this.hasReached = false;
        this.findRandomTaggedBlock();
        if (this.targetPos != null) {
            this.mob.m_21573_().m_26519_((double)this.targetPos.m_123341_() + 0.5, (double)this.targetPos.m_123342_(), (double)this.targetPos.m_123343_() + 0.5, this.speed);
        }
    }

    public boolean m_8045_() {
        return this.targetPos != null && !this.hasReached && !this.mob.m_21573_().m_26571_();
    }

    public void m_8041_() {
        Level level;
        boolean wasSuccessful = false;
        if (this.targetPos != null && (level = this.mob.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)level;
            double dx = this.mob.m_20185_() - ((double)this.targetPos.m_123341_() + 0.5);
            double dz = this.mob.m_20189_() - ((double)this.targetPos.m_123343_() + 0.5);
            double horizontalDistanceSq = dx * dx + dz * dz;
            double verticalDistance = Math.abs(this.mob.m_20186_() - (double)this.targetPos.m_123342_());
            if (horizontalDistanceSq <= 1.0 && verticalDistance <= 2.0) {
                wasSuccessful = true;
            }
            if (wasSuccessful) {
                serverWorld.m_8767_((ParticleOptions)ParticleTypes.f_123748_, this.mob.m_20185_(), this.mob.m_20186_() + (double)this.mob.m_20206_() + 0.5, this.mob.m_20189_(), 5, 0.3, 0.3, 0.3, 0.0);
            } else {
                serverWorld.m_8767_((ParticleOptions)ParticleTypes.f_123792_, this.mob.m_20185_(), this.mob.m_20186_() + (double)this.mob.m_20206_() + 0.5, this.mob.m_20189_(), 1, 0.1, 0.1, 0.1, 0.0);
            }
        }
        this.targetPos = null;
        this.hasReached = false;
        this.mob.m_21573_().m_26573_();
    }

    private void findRandomTaggedBlock() {
        this.targetPos = null;
        ArrayList<BlockPos> validTargets = new ArrayList<BlockPos>();
        int maxTargetsToFind = 5;
        int searchRadius = 48;
        BlockPos mobPos = this.mob.m_20183_();
        for (int r = 0; r < searchRadius; ++r) {
            for (int x = -r; x <= r; ++x) {
                for (int z = -r; z <= r; ++z) {
                    if (Math.abs(x) != r && Math.abs(z) != r) continue;
                    for (int y = -5; y <= 5; ++y) {
                        BlockPos currentPos = mobPos.m_7918_(x, y, z);
                        if (!this.mob.m_9236_().m_8055_(currentPos).m_204336_(ModTags.Blocks.VISITOR_PREFERRED_BLOCKS)) continue;
                        validTargets.add(currentPos);
                        if (validTargets.size() == maxTargetsToFind) break;
                    }
                    if (validTargets.size() == maxTargetsToFind) break;
                }
                if (validTargets.size() == maxTargetsToFind) break;
            }
            if (validTargets.size() == maxTargetsToFind) break;
        }
        if (!validTargets.isEmpty()) {
            this.targetPos = (BlockPos)validTargets.get(this.mob.m_217043_().m_188503_(validTargets.size()));
        }
    }
}

