/*
 * Decompiled with CFR 0.152.
 */
package net.redstonegames.visitingvillagers.entity.ai;

import java.util.ArrayList;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class JumpToBlockGoal
extends Goal {
    private final Mob mob;
    private final int maxJumpHeight;
    private final int horizontalRange;
    private BlockPos targetPos;
    private int prepareToJumpTicks;
    private static final int START_CHANCE = 150;
    private static final int PREPARE_TIME = 20;

    public JumpToBlockGoal(Mob mob, int maxJumpHeight, int horizontalRange) {
        this.mob = mob;
        this.maxJumpHeight = maxJumpHeight;
        this.horizontalRange = horizontalRange;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (!this.mob.m_20096_()) {
            return false;
        }
        if (this.mob.m_217043_().m_188503_(150) != 0) {
            return false;
        }
        this.findTargetBlock();
        return this.targetPos != null;
    }

    public boolean m_8045_() {
        return this.prepareToJumpTicks > 0 && this.targetPos != null;
    }

    public void m_8056_() {
        this.prepareToJumpTicks = 20;
        this.mob.m_21573_().m_26573_();
    }

    public void m_8041_() {
        this.prepareToJumpTicks = 0;
        this.targetPos = null;
    }

    public void m_8037_() {
        this.mob.m_21563_().m_24946_((double)this.targetPos.m_123341_(), (double)this.targetPos.m_123342_(), (double)this.targetPos.m_123343_());
        --this.prepareToJumpTicks;
        if (this.prepareToJumpTicks == 0) {
            Vec3 targetVec = Vec3.m_82539_((Vec3i)this.targetPos);
            Vec3 mobPos = this.mob.m_20182_();
            Vec3 jumpVec = new Vec3(targetVec.f_82479_ - mobPos.f_82479_, 0.0, targetVec.f_82481_ - mobPos.f_82481_);
            if (jumpVec.m_82556_() > 1.0E-7) {
                jumpVec = jumpVec.m_82541_().m_82490_(0.8);
            }
            this.mob.m_20334_(jumpVec.f_82479_, 0.6, jumpVec.f_82481_);
            this.mob.m_5496_(SoundEvents.f_144151_, 1.0f, 1.0f);
        }
    }

    private void findTargetBlock() {
        Level level = this.mob.m_9236_();
        BlockPos mobPos = this.mob.m_20183_();
        ArrayList<BlockPos> possibleTargets = new ArrayList<BlockPos>();
        for (int y = 0; y <= this.maxJumpHeight; ++y) {
            for (int x = -this.horizontalRange; x <= this.horizontalRange; ++x) {
                for (int z = -this.horizontalRange; z <= this.horizontalRange; ++z) {
                    BlockPos currentPos = mobPos.m_7918_(x, y, z);
                    if (!level.m_8055_(currentPos).m_60783_((BlockGetter)level, currentPos, Direction.UP) || !level.m_46859_(currentPos.m_7494_()) || !level.m_46859_(currentPos.m_6630_(2))) continue;
                    possibleTargets.add(currentPos);
                }
            }
        }
        this.targetPos = !possibleTargets.isEmpty() ? (BlockPos)possibleTargets.get(this.mob.m_217043_().m_188503_(possibleTargets.size())) : null;
    }
}

