/*
 * Decompiled with CFR 0.152.
 */
package net.redstonegames.visitingvillagers.entity.client;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Mob;
import net.redstonegames.visitingvillagers.entity.client.ModModelLayers;
import net.redstonegames.visitingvillagers.entity.client.VisitorModel;
import net.redstonegames.visitingvillagers.entity.custom.VisitorEntity;
import net.redstonegames.visitingvillagers.entity.variant.VisitorVariant;

public class VisitorRenderer
extends MobRenderer<VisitorEntity, VisitorModel<VisitorEntity>> {
    private static final List<ResourceLocation> GENERIC_TEXTURES = Arrays.asList(new ResourceLocation("visitingvillagers", "textures/entity/visitor/red_npc.png"), new ResourceLocation("visitingvillagers", "textures/entity/visitor/red_npc1.png"), new ResourceLocation("visitingvillagers", "textures/entity/visitor/red_npc2.png"), new ResourceLocation("visitingvillagers", "textures/entity/visitor/red_npc3.png"), new ResourceLocation("visitingvillagers", "textures/entity/visitor/red_npc4.png"), new ResourceLocation("visitingvillagers", "textures/entity/visitor/red_npc6.png"), new ResourceLocation("visitingvillagers", "textures/entity/visitor/red_npc7.png"));
    private static final Map<VisitorVariant, ResourceLocation> LOCATION_BY_VARIANT = (Map)Util.m_137469_((Object)Maps.newEnumMap(VisitorVariant.class), map -> {
        map.put(VisitorVariant.TEXTURE0, new ResourceLocation("visitingvillagers", "textures/entity/visitor/miner.png"));
        map.put(VisitorVariant.TEXTURE1, new ResourceLocation("visitingvillagers", "textures/entity/visitor/beekeeper.png"));
        map.put(VisitorVariant.TEXTURE2, new ResourceLocation("visitingvillagers", "textures/entity/visitor/lumberjack.png"));
        map.put(VisitorVariant.TEXTURE3, new ResourceLocation("visitingvillagers", "textures/entity/visitor/pillager.png"));
        map.put(VisitorVariant.TEXTURE4, new ResourceLocation("visitingvillagers", "textures/entity/visitor/glassworker.png"));
        map.put(VisitorVariant.TEXTURE5, new ResourceLocation("visitingvillagers", "textures/entity/visitor/railwright.png"));
        map.put(VisitorVariant.TEXTURE6, new ResourceLocation("visitingvillagers", "textures/entity/visitor/relic.png"));
        map.put(VisitorVariant.TEXTURE7, new ResourceLocation("visitingvillagers", "textures/entity/visitor/piglin_trader.png"));
        map.put(VisitorVariant.TEXTURE8, new ResourceLocation("visitingvillagers", "textures/entity/visitor/beach.png"));
        map.put(VisitorVariant.TEXTURE9, new ResourceLocation("visitingvillagers", "textures/entity/visitor/enchantsmith.png"));
        map.put(VisitorVariant.TEXTURE10, new ResourceLocation("visitingvillagers", "textures/entity/visitor/redstoneer.png"));
        map.put(VisitorVariant.TEXTURE11, new ResourceLocation("visitingvillagers", "textures/entity/visitor/firework.png"));
        map.put(VisitorVariant.TEXTURE12, new ResourceLocation("visitingvillagers", "textures/entity/visitor/mushroom.png"));
    });

    public VisitorRenderer(EntityRendererProvider.Context pContext) {
        super(pContext, new VisitorModel(pContext.m_174023_(ModModelLayers.VISITOR)), 0.5f);
    }

    public ResourceLocation getTextureLocation(VisitorEntity entity) {
        if (entity.getVariant() == VisitorVariant.DEFAULT) {
            int size = GENERIC_TEXTURES.size();
            int index = Math.abs(entity.m_19879_()) % size;
            return GENERIC_TEXTURES.get(index);
        }
        return LOCATION_BY_VARIANT.get((Object)entity.getVariant());
    }

    public void render(VisitorEntity pEntity, float pEntityYaw, float pPartialTicks, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight) {
        pPoseStack.m_85836_();
        pPoseStack.m_85841_(0.9375f, 0.9375f, 0.9375f);
        super.m_7392_((Mob)pEntity, pEntityYaw, pPartialTicks, pPoseStack, pBuffer, pPackedLight);
        pPoseStack.m_85849_();
    }
}

