/*
 * Decompiled with CFR 0.152.
 */
package net.redstonegames.visitingvillagers.entity.custom;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveThroughVillageGoal;
import net.minecraft.world.entity.ai.goal.OpenDoorGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.redstonegames.visitingvillagers.entity.ai.DespawnAtNightGoal;
import net.redstonegames.visitingvillagers.entity.ai.DespawnWhenPlayerSleepsGoal;
import net.redstonegames.visitingvillagers.entity.ai.JumpToBlockGoal;
import net.redstonegames.visitingvillagers.entity.ai.PlayWithOthersGoal;
import net.redstonegames.visitingvillagers.entity.custom.VisitorEntity;
import net.redstonegames.visitingvillagers.entity.variant.BabyVisitorVariant;
import org.jetbrains.annotations.Nullable;

public class BabyVisitorEntity
extends VisitorEntity {
    private static final EntityDataAccessor<Integer> BABY_DATA_ID_TYPE_VARIANT = SynchedEntityData.m_135353_(BabyVisitorEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public BabyVisitorEntity(EntityType<? extends AbstractVillager> entityType, Level level) {
        super(entityType, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return VisitorEntity.createAttributes();
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, Zombie.class, 15.0f, 1.4, 1.6));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.6));
        this.f_21345_.m_25352_(2, (Goal)new DespawnWhenPlayerSleepsGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new MoveThroughVillageGoal((PathfinderMob)this, 1.6, false, 4, () -> false));
        this.f_21345_.m_25352_(2, (Goal)new PlayWithOthersGoal(this, 1.6));
        this.f_21345_.m_25352_(2, (Goal)new JumpToBlockGoal((Mob)this, 3, 5));
        this.f_21345_.m_25352_(4, (Goal)new OpenDoorGoal((Mob)this, true));
        this.f_21345_.m_25352_(4, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.1));
        this.f_21345_.m_25352_(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 4.0f));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 4.0f));
        this.f_21345_.m_25352_(9, (Goal)new DespawnAtNightGoal((Mob)this, 16.0, false));
    }

    public boolean m_6162_() {
        return true;
    }

    @Override
    protected void m_7604_() {
    }

    @Override
    @Nullable
    public AgeableMob m_142606_(ServerLevel world, AgeableMob entity) {
        return null;
    }

    public void m_146762_(int age) {
    }

    @Override
    protected SoundEvent m_7515_() {
        return SoundEvents.f_12503_;
    }

    @Override
    protected SoundEvent m_7975_(DamageSource source) {
        return SoundEvents.f_12506_;
    }

    @Override
    protected SoundEvent m_5592_() {
        return SoundEvents.f_12505_;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(BABY_DATA_ID_TYPE_VARIANT, (Object)0);
    }

    @Override
    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128405_("BabyVariant", this.getBabyTypeVariant());
    }

    @Override
    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.f_19804_.m_135381_(BABY_DATA_ID_TYPE_VARIANT, (Object)nbt.m_128451_("BabyVariant"));
    }

    @Override
    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType spawnReason, @Nullable SpawnGroupData entityData, @Nullable CompoundTag entityNbt) {
        BabyVisitorVariant variant = BabyVisitorVariant.getRandomVariant(this.f_19796_);
        this.setBabyVariant(variant);
        return super.m_6518_(world, difficulty, spawnReason, entityData, entityNbt);
    }

    public BabyVisitorVariant getBabyVariant() {
        return BabyVisitorVariant.byId(this.getBabyTypeVariant() & 0xFF);
    }

    private int getBabyTypeVariant() {
        return (Integer)this.f_19804_.m_135370_(BABY_DATA_ID_TYPE_VARIANT);
    }

    private void setBabyVariant(BabyVisitorVariant variant) {
        this.f_19804_.m_135381_(BABY_DATA_ID_TYPE_VARIANT, (Object)(variant.getId() & 0xFF));
    }
}

