/*
 * Decompiled with CFR 0.152.
 */
package net.redstonegames.visitingvillagers.entity.custom;

import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.LookAtTradingPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveBackToVillageGoal;
import net.minecraft.world.entity.ai.goal.OpenDoorGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.TradeWithPlayerGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.redstonegames.visitingvillagers.entity.ModEntities;
import net.redstonegames.visitingvillagers.entity.ai.DespawnAtNightGoal;
import net.redstonegames.visitingvillagers.entity.ai.DespawnWhenPlayerSleepsGoal;
import net.redstonegames.visitingvillagers.entity.ai.GoToPoiGoal;
import net.redstonegames.visitingvillagers.entity.variant.VisitorVariant;
import net.redstonegames.visitingvillagers.sound.ModSounds;
import net.redstonegames.visitingvillagers.util.ModTags;
import net.redstonegames.visitingvillagers.util.VisitorTrades;

public class VisitorEntity
extends AbstractVillager {
    private int pricePenalty = 0;
    private PanicGoal panicGoal;
    @Nullable
    private BlockPos taggedBlockTarget;
    private static final EntityDataAccessor<Integer> DATA_ID_TYPE_VARIANT = SynchedEntityData.m_135353_(VisitorEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public VisitorEntity(EntityType<? extends AbstractVillager> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        ((GroundPathNavigation)this.m_21573_()).m_26477_(true);
    }

    @Nullable
    public BlockPos getTaggedBlockTarget() {
        return this.taggedBlockTarget;
    }

    public void setTaggedBlockTarget(@Nullable BlockPos pos) {
        this.taggedBlockTarget = pos;
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(0, (Goal)new LookAtTradingPlayerGoal((AbstractVillager)this));
        this.f_21345_.m_25352_(1, (Goal)new TradeWithPlayerGoal((AbstractVillager)this));
        this.f_21345_.m_25352_(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, Zombie.class, 15.0f, 1.2, 1.6));
        this.panicGoal = new PanicGoal((PathfinderMob)this, 1.8);
        this.f_21345_.m_25352_(1, (Goal)this.panicGoal);
        this.f_21345_.m_25352_(2, (Goal)new DespawnWhenPlayerSleepsGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new OpenDoorGoal((Mob)this, true));
        this.f_21345_.m_25352_(3, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.9));
        this.f_21345_.m_25352_(4, (Goal)new GoToPoiGoal((PathfinderMob)this, 1.2, poiType -> poiType.containsTag(ModTags.PointOfInterestTypes.VISITOR_PREFERRED_POIS), 32, 150));
        this.f_21345_.m_25352_(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 4.0f));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 4.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(9, (Goal)new DespawnAtNightGoal((Mob)this, 24.0, false));
        this.f_21345_.m_25352_(15, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.4, 150));
        this.f_21345_.m_25352_(15, (Goal)new MoveBackToVillageGoal((PathfinderMob)this, 1.2, false));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 15.0).m_22268_(Attributes.f_22279_, (double)0.2f).m_22268_(Attributes.f_22284_, 0.5);
    }

    public InteractionResult m_6071_(Player pPlayer, InteractionHand pHand) {
        ItemStack itemStack = pPlayer.m_21120_(pHand);
        if (!itemStack.m_150930_(Items.f_42601_) && this.m_6084_() && this.m_7962_() == null && !this.m_6162_()) {
            if (pHand == InteractionHand.MAIN_HAND) {
                pPlayer.m_36220_(Stats.f_12940_);
            }
            if (this.m_6616_().isEmpty()) {
                this.sayNo();
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
            if (!this.m_9236_().f_46443_) {
                this.m_7189_(pPlayer);
                this.m_45301_(pPlayer, this.m_5446_(), 1);
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return super.m_6071_(pPlayer, pHand);
    }

    public void m_8107_() {
        super.m_8107_();
    }

    public void sayNo() {
        this.m_35319_(40);
        if (!this.m_9236_().m_5776_()) {
            this.m_5496_(this.m_6068_(false), this.m_6121_(), this.m_6100_());
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_35303_() > 0) {
            this.m_35319_(this.m_35303_() - 1);
        }
    }

    protected void m_7604_() {
        VisitorVariant variant = this.getVariant();
        Map<Integer, VillagerTrades.ItemListing[]> tradesForVariant = VisitorTrades.VARIANT_TRADES.get((Object)variant);
        if (tradesForVariant == null || tradesForVariant.isEmpty()) {
            return;
        }
        VillagerTrades.ItemListing[] level1Trades = tradesForVariant.get(1);
        VillagerTrades.ItemListing[] level2Trades = tradesForVariant.get(2);
        MerchantOffers offers = this.m_6616_();
        if (level1Trades != null) {
            this.m_35277_(offers, level1Trades, 4);
        }
        if (level2Trades != null) {
            this.m_35277_(offers, level2Trades, 3);
        }
        if (this.pricePenalty > 0) {
            for (MerchantOffer offer : offers) {
                offer.m_45353_(this.pricePenalty);
            }
        }
    }

    protected void m_8058_(MerchantOffer pOffer) {
        if (pOffer.m_45383_()) {
            int i = 3 + this.f_19796_.m_188503_(4);
            this.m_9236_().m_7967_((Entity)new ExperienceOrb(this.m_9236_(), this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), i));
        }
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        boolean damaged = super.m_6469_(pSource, pAmount);
        if (damaged && !this.m_9236_().f_46443_ && pSource.m_7639_() instanceof Player) {
            this.alertNearbyVisitors();
            if (this.pricePenalty < 10) {
                ++this.pricePenalty;
                this.f_35261_ = null;
            }
        }
        return damaged;
    }

    public Component m_5446_() {
        VisitorVariant variant = this.getVariant();
        return switch (variant) {
            default -> throw new IncompatibleClassChangeError();
            case VisitorVariant.TEXTURE0 -> Component.m_237115_((String)"entity.visitingvillagers.visitor.miner");
            case VisitorVariant.TEXTURE1 -> Component.m_237115_((String)"entity.visitingvillagers.visitor.beekeeper");
            case VisitorVariant.TEXTURE2 -> Component.m_237115_((String)"entity.visitingvillagers.visitor.lumberjack");
            case VisitorVariant.TEXTURE3 -> Component.m_237115_((String)"entity.visitingvillagers.visitor.good_pillager");
            case VisitorVariant.TEXTURE4 -> Component.m_237115_((String)"entity.visitingvillagers.visitor.glassworker");
            case VisitorVariant.TEXTURE5 -> Component.m_237115_((String)"entity.visitingvillagers.visitor.railwright");
            case VisitorVariant.TEXTURE6 -> Component.m_237115_((String)"entity.visitingvillagers.visitor.relic_scavenger");
            case VisitorVariant.TEXTURE7 -> Component.m_237115_((String)"entity.visitingvillagers.visitor.piglin_trader");
            case VisitorVariant.TEXTURE8 -> Component.m_237115_((String)"entity.visitingvillagers.visitor.beachcomber");
            case VisitorVariant.TEXTURE9 -> Component.m_237115_((String)"entity.visitingvillagers.visitor.enchantsmith");
            case VisitorVariant.TEXTURE10 -> Component.m_237115_((String)"entity.visitingvillagers.visitor.redstone_engineer");
            case VisitorVariant.TEXTURE11 -> Component.m_237115_((String)"entity.visitingvillagers.visitor.pyrotechnic");
            case VisitorVariant.TEXTURE12 -> Component.m_237115_((String)"entity.visitingvillagers.visitor.mycologist");
            case VisitorVariant.DEFAULT -> Component.m_237115_((String)"entity.visitingvillagers.visitor");
        };
    }

    public boolean m_7826_() {
        return false;
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel pLevel, AgeableMob pOtherParent) {
        return (AgeableMob)((EntityType)ModEntities.VISITOR.get()).m_20615_((Level)pLevel);
    }

    protected SoundEvent m_7515_() {
        if (this.getVariant() == VisitorVariant.TEXTURE7) {
            return this.m_7962_() != null ? SoundEvents.f_12238_ : SoundEvents.f_12239_;
        }
        if (this.getVariant() == VisitorVariant.TEXTURE3) {
            return SoundEvents.f_12307_;
        }
        return this.m_7962_() != null ? SoundEvents.f_12508_ : SoundEvents.f_12503_;
    }

    protected SoundEvent m_7975_(DamageSource pSource) {
        if (this.getVariant() == VisitorVariant.TEXTURE7) {
            return SoundEvents.f_12244_;
        }
        if (this.getVariant() == VisitorVariant.TEXTURE3) {
            return SoundEvents.f_12310_;
        }
        return SoundEvents.f_12506_;
    }

    protected SoundEvent m_5592_() {
        if (this.getVariant() == VisitorVariant.TEXTURE7) {
            return SoundEvents.f_12242_;
        }
        if (this.getVariant() == VisitorVariant.TEXTURE3) {
            return SoundEvents.f_12309_;
        }
        return SoundEvents.f_12505_;
    }

    protected SoundEvent m_6068_(boolean pGetYesSound) {
        if (pGetYesSound) {
            if (this.getVariant() == VisitorVariant.TEXTURE7) {
                return (SoundEvent)ModSounds.ENTITY_VISITOR_PIGLIN_YES.get();
            }
            if (this.getVariant() == VisitorVariant.TEXTURE3) {
                return (SoundEvent)ModSounds.ENTITY_VISITOR_PILLAGER_YES.get();
            }
            return SoundEvents.f_12509_;
        }
        if (this.getVariant() == VisitorVariant.TEXTURE7) {
            return (SoundEvent)ModSounds.ENTITY_VISITOR_PIGLIN_NO.get();
        }
        if (this.getVariant() == VisitorVariant.TEXTURE3) {
            return (SoundEvent)ModSounds.ENTITY_VISITOR_PILLAGER_NO.get();
        }
        return SoundEvents.f_12507_;
    }

    public boolean m_21532_() {
        return false;
    }

    public boolean m_6785_(double pDistanceToClosestPlayer) {
        return pDistanceToClosestPlayer > 16384.0;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_ID_TYPE_VARIANT, (Object)0);
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("Variant", this.getTypeVariant());
        pCompound.m_128405_("PricePenalty", this.pricePenalty);
        if (this.taggedBlockTarget != null) {
            pCompound.m_128365_("TaggedBlockTarget", (Tag)NbtUtils.m_129224_((BlockPos)this.taggedBlockTarget));
        }
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.f_19804_.m_135381_(DATA_ID_TYPE_VARIANT, (Object)pCompound.m_128451_("Variant"));
        this.pricePenalty = pCompound.m_128451_("PricePenalty");
        if (pCompound.m_128441_("TaggedBlockTarget")) {
            this.taggedBlockTarget = NbtUtils.m_129239_((CompoundTag)pCompound.m_128469_("TaggedBlockTarget"));
        }
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        VisitorVariant variant = VisitorVariant.getRandomVariant(this.f_19796_);
        this.setVariant(variant);
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    public VisitorVariant getVariant() {
        return VisitorVariant.byId(this.getTypeVariant());
    }

    private int getTypeVariant() {
        return (Integer)this.f_19804_.m_135370_(DATA_ID_TYPE_VARIANT);
    }

    private void setVariant(VisitorVariant variant) {
        this.f_19804_.m_135381_(DATA_ID_TYPE_VARIANT, (Object)(variant.getId() & 0xFF));
    }

    public void startPanic() {
        if (this.panicGoal != null) {
            this.panicGoal.m_8056_();
        }
    }

    private void alertNearbyVisitors() {
        double alertRadius = 12.0;
        List nearbyVisitors = this.m_9236_().m_6443_(VisitorEntity.class, this.m_20191_().m_82400_(alertRadius), visitor -> visitor != this);
        for (VisitorEntity visitor2 : nearbyVisitors) {
            visitor2.startPanic();
        }
    }
}

