/*
 * Decompiled with CFR 0.152.
 */
package net.redstonegames.visitingvillagers.entity.custom;

import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.LookAtTradingPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveBackToVillageGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TradeWithPlayerGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.AABB;
import net.redstonegames.visitingvillagers.entity.ai.DespawnAtDayGoal;
import net.redstonegames.visitingvillagers.entity.ai.DespawnAtNightGoal;
import net.redstonegames.visitingvillagers.entity.ai.DespawnWhenPlayerSleepsGoal;
import net.redstonegames.visitingvillagers.entity.variant.WanderingVisitorVariant;
import net.redstonegames.visitingvillagers.util.ModTags;
import net.redstonegames.visitingvillagers.util.WanderingVisitorTrades;
import org.jetbrains.annotations.Nullable;

public class WanderingVisitorEntity
extends AbstractVillager {
    private int leashDelay = 0;
    private int pricePenalty = 0;
    private static final EntityDataAccessor<Integer> DATA_ID_TYPE_VARIANT = SynchedEntityData.m_135353_(WanderingVisitorEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public WanderingVisitorEntity(EntityType<? extends AbstractVillager> entityType, Level level) {
        super(entityType, level);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(0, (Goal)new LookAtTradingPlayerGoal((AbstractVillager)this));
        this.f_21345_.m_25352_(1, (Goal)new TradeWithPlayerGoal((AbstractVillager)this));
        this.f_21345_.m_25352_(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, Zombie.class, 15.0f, 1.2, 1.6));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.6));
        this.f_21345_.m_25352_(2, (Goal)new DespawnWhenPlayerSleepsGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new MoveBackToVillageGoal((PathfinderMob)this, 1.2, false));
        this.f_21345_.m_25352_(3, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.1));
        this.f_21345_.m_25352_(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 4.0f));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 4.0f));
        this.f_21345_.m_25352_(9, (Goal)new DespawnAtDayGoal((Mob)this, 64.0, true));
        this.f_21345_.m_25352_(9, (Goal)new DespawnAtNightGoal((Mob)this, 24.0, true));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 15.0).m_22268_(Attributes.f_22279_, (double)0.2f).m_22268_(Attributes.f_22284_, 0.5);
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        boolean damaged = super.m_6469_(pSource, pAmount);
        if (damaged && !this.m_9236_().f_46443_ && pSource.m_7639_() instanceof Player && this.pricePenalty < 10) {
            ++this.pricePenalty;
            this.f_35261_ = null;
        }
        return damaged;
    }

    public InteractionResult m_6071_(Player pPlayer, InteractionHand pHand) {
        ItemStack itemStack = pPlayer.m_21120_(pHand);
        if (!itemStack.m_150930_(Items.f_42601_) && this.m_6084_() && this.m_7962_() == null) {
            if (pHand == InteractionHand.MAIN_HAND) {
                pPlayer.m_36220_(Stats.f_12940_);
            }
            if (this.m_6616_().isEmpty()) {
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
            if (!this.m_9236_().f_46443_) {
                this.m_7189_(pPlayer);
                this.m_45301_(pPlayer, this.m_5446_(), 1);
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return super.m_6071_(pPlayer, pHand);
    }

    protected void m_7604_() {
        WanderingVisitorVariant variant = this.getVariant();
        Map<Integer, VillagerTrades.ItemListing[]> tradesForVariant = WanderingVisitorTrades.VARIANT_TRADES.get((Object)variant);
        if (tradesForVariant == null) {
            tradesForVariant = WanderingVisitorTrades.VARIANT_TRADES.get((Object)WanderingVisitorVariant.DEFAULT);
        }
        if (tradesForVariant == null) {
            return;
        }
        VillagerTrades.ItemListing[] factoriesLevel1 = tradesForVariant.get(1);
        VillagerTrades.ItemListing[] factoriesLevel2 = tradesForVariant.get(2);
        if (factoriesLevel1 == null && factoriesLevel2 == null) {
            return;
        }
        MerchantOffers merchantoffers = this.m_6616_();
        int buysToSelect = 4;
        int sellsToSelect = 4;
        if (variant == WanderingVisitorVariant.TEXTURE7) {
            buysToSelect = 6;
            sellsToSelect = 6;
        }
        if (factoriesLevel1 != null) {
            this.m_35277_(merchantoffers, factoriesLevel1, buysToSelect);
        }
        if (factoriesLevel2 != null) {
            this.m_35277_(merchantoffers, factoriesLevel2, sellsToSelect);
        }
        if (this.pricePenalty > 0) {
            for (MerchantOffer offer : merchantoffers) {
                offer.m_45353_(this.pricePenalty);
            }
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_ && this.leashDelay > 0) {
            --this.leashDelay;
            if (this.leashDelay == 0) {
                this.spawnAnimals((ServerLevel)this.m_9236_());
            }
        }
    }

    protected void m_8058_(MerchantOffer pOffer) {
        if (pOffer.m_45383_()) {
            int i = 3 + this.f_19796_.m_188503_(4);
            this.m_9236_().m_7967_((Entity)new ExperienceOrb(this.m_9236_(), this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), i));
        }
    }

    public Component m_5446_() {
        WanderingVisitorVariant variant = this.getVariant();
        return switch (variant) {
            default -> throw new IncompatibleClassChangeError();
            case WanderingVisitorVariant.DEFAULT -> Component.m_237115_((String)"entity.visitingvillagers.wandering_visitor.plains");
            case WanderingVisitorVariant.TEXTURE1 -> Component.m_237115_((String)"entity.visitingvillagers.wandering_visitor.forest");
            case WanderingVisitorVariant.TEXTURE2 -> Component.m_237115_((String)"entity.visitingvillagers.wandering_visitor.cave");
            case WanderingVisitorVariant.TEXTURE3 -> Component.m_237115_((String)"entity.visitingvillagers.wandering_visitor.mountain");
            case WanderingVisitorVariant.TEXTURE4 -> Component.m_237115_((String)"entity.visitingvillagers.wandering_visitor.snow");
            case WanderingVisitorVariant.TEXTURE5 -> Component.m_237115_((String)"entity.visitingvillagers.wandering_visitor.swamp");
            case WanderingVisitorVariant.TEXTURE6 -> Component.m_237115_((String)"entity.visitingvillagers.wandering_visitor.desert");
            case WanderingVisitorVariant.TEXTURE7 -> Component.m_237115_((String)"entity.visitingvillagers.wandering_visitor.plus");
        };
    }

    public boolean m_7826_() {
        return false;
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel pLevel, AgeableMob pOtherParent) {
        return null;
    }

    public boolean m_6162_() {
        return false;
    }

    protected SoundEvent m_7515_() {
        return this.m_7962_() != null ? SoundEvents.f_12538_ : SoundEvents.f_12582_;
    }

    protected SoundEvent m_7975_(DamageSource pSource) {
        return SoundEvents.f_12587_;
    }

    protected SoundEvent m_6068_(boolean pGetYesSound) {
        return pGetYesSound ? SoundEvents.f_12539_ : SoundEvents.f_12588_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12583_;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_ID_TYPE_VARIANT, (Object)0);
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("Variant", this.getTypeVariant());
        pCompound.m_128405_("PricePenalty", this.pricePenalty);
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.f_19804_.m_135381_(DATA_ID_TYPE_VARIANT, (Object)pCompound.m_128451_("Variant"));
        this.pricePenalty = pCompound.m_128451_("PricePenalty");
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        WanderingVisitorVariant variant = WanderingVisitorVariant.values()[this.f_19796_.m_188503_(WanderingVisitorVariant.values().length)];
        this.setVariant(variant);
        this.leashDelay = 10;
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    private void spawnLeashedAnimal(ServerLevel world, DifficultyInstance difficulty, EntityType<? extends Animal> type, @Nullable BlockPos existingAnimalPos) {
        BlockPos spawnPos = this.findLeashedAnimalPos((LevelAccessor)world, this.m_20183_(), 3, existingAnimalPos);
        Animal animal = (Animal)type.m_20615_((Level)world);
        if (animal != null) {
            animal.m_20035_(spawnPos, 1.0f, 0.0f);
            animal.m_6518_((ServerLevelAccessor)world, difficulty, MobSpawnType.EVENT, null, null);
            world.m_47205_((Entity)animal);
            animal.m_21463_((Entity)this, true);
        }
    }

    private void spawnAnimals(ServerLevel world) {
        DifficultyInstance difficulty = world.m_6436_(this.m_20183_());
        WanderingVisitorVariant variant = this.getVariant();
        switch (variant) {
            case DEFAULT: {
                this.spawnLeashedAnimal(world, difficulty, (EntityType<? extends Animal>)EntityType.f_20520_, null);
                this.spawnLeashedAnimal(world, difficulty, (EntityType<? extends Animal>)EntityType.f_20520_, this.m_20183_());
                break;
            }
            case TEXTURE1: {
                this.spawnLeashedAnimal(world, difficulty, (EntityType<? extends Animal>)EntityType.f_20452_, null);
                break;
            }
            case TEXTURE2: {
                this.spawnLeashedAnimal(world, difficulty, (EntityType<? extends Animal>)EntityType.f_20466_, null);
                this.spawnLeashedAnimal(world, difficulty, (EntityType<? extends Animal>)EntityType.f_20466_, this.m_20183_());
                break;
            }
            case TEXTURE3: {
                this.spawnLeashedAnimal(world, difficulty, (EntityType<? extends Animal>)EntityType.f_147035_, null);
                this.spawnLeashedAnimal(world, difficulty, (EntityType<? extends Animal>)EntityType.f_147035_, this.m_20183_());
                break;
            }
            case TEXTURE4: {
                this.spawnLeashedAnimal(world, difficulty, (EntityType<? extends Animal>)EntityType.f_20457_, null);
                break;
            }
            case TEXTURE5: {
                this.spawnLeashedAnimal(world, difficulty, (EntityType<? extends Animal>)EntityType.f_217012_, null);
                this.spawnLeashedAnimal(world, difficulty, (EntityType<? extends Animal>)EntityType.f_217012_, this.m_20183_());
                break;
            }
            case TEXTURE6: {
                this.spawnLeashedAnimal(world, difficulty, (EntityType<? extends Animal>)EntityType.f_243976_, null);
                break;
            }
            case TEXTURE7: {
                this.spawnLeashedAnimal(world, difficulty, (EntityType<? extends Animal>)EntityType.f_20457_, null);
                this.spawnLeashedAnimal(world, difficulty, (EntityType<? extends Animal>)EntityType.f_20457_, this.m_20183_());
            }
        }
    }

    public WanderingVisitorVariant getVariant() {
        return WanderingVisitorVariant.byId(this.getTypeVariant() & 0xFF);
    }

    private int getTypeVariant() {
        return (Integer)this.f_19804_.m_135370_(DATA_ID_TYPE_VARIANT);
    }

    private void setVariant(WanderingVisitorVariant variant) {
        this.f_19804_.m_135381_(DATA_ID_TYPE_VARIANT, (Object)(variant.getId() & 0xFF));
    }

    private BlockPos findLeashedAnimalPos(LevelAccessor world, BlockPos pos, int range, @Nullable BlockPos existingAnimalPos) {
        BlockPos blockPos = pos;
        for (int i = 0; i < 10; ++i) {
            int z;
            int x = this.f_19796_.m_188503_(range * 2) - range;
            BlockPos testPos = blockPos.m_7918_(x, 0, z = this.f_19796_.m_188503_(range * 2) - range);
            if (!world.m_8055_(testPos).m_60795_() || existingAnimalPos != null && testPos.equals((Object)existingAnimalPos)) continue;
            return testPos;
        }
        return blockPos;
    }

    public static boolean checkSpawnRules(EntityType<? extends WanderingVisitorEntity> type, LevelAccessor world, MobSpawnType reason, BlockPos pos, RandomSource random) {
        return world.m_8055_(pos.m_7495_()).m_204336_(ModTags.Blocks.VISITORS_SPAWNABLE_ON) && Mob.m_217057_(type, (LevelAccessor)world, (MobSpawnType)reason, (BlockPos)pos, (RandomSource)random);
    }

    public boolean m_21532_() {
        return false;
    }

    public boolean m_6785_(double pDistanceToClosestPlayer) {
        return true;
    }

    public void m_142687_(Entity.RemovalReason pReason) {
        this.removeLeashedAnimals();
        super.m_142687_(pReason);
    }

    public void removeLeashedAnimals() {
        if (this.m_9236_().f_46443_) {
            return;
        }
        AABB searchBox = this.m_20191_().m_82400_(16.0);
        List nearbyAnimals = this.m_9236_().m_6443_(Mob.class, searchBox, animal -> animal.m_21523_() && this.equals(animal.m_21524_()));
        for (Mob animal2 : nearbyAnimals) {
            animal2.m_146870_();
        }
    }
}

