/*
 * Decompiled with CFR 0.152.
 */
package net.redstonegames.visitingvillagers.entity.variant;

import java.util.Arrays;
import java.util.Comparator;
import net.minecraft.util.RandomSource;

public enum BabyVisitorVariant {
    DEFAULT(0, 10),
    TEXTURE1(1, 10),
    TEXTURE2(2, 10),
    TEXTURE3(3, 10),
    TEXTURE4(4, 10),
    TEXTURE5(5, 10),
    TEXTURE6(6, 10),
    TEXTURE7(7, 10),
    TEXTURE8(8, 10),
    TEXTURE9(9, 10),
    TEXTURE10(10, 6),
    TEXTURE11(11, 6),
    TEXTURE12(12, 6);

    private static final BabyVisitorVariant[] BY_ID;
    private final int id;
    private final int weight;

    private BabyVisitorVariant(int id, int weight) {
        this.id = id;
        this.weight = weight;
    }

    public int getId() {
        return this.id;
    }

    public int getWeight() {
        return this.weight;
    }

    public static BabyVisitorVariant byId(int id) {
        return BY_ID[id % BY_ID.length];
    }

    public static BabyVisitorVariant getRandomVariant(RandomSource random) {
        int totalWeight = 0;
        for (BabyVisitorVariant variant : BabyVisitorVariant.values()) {
            totalWeight += variant.getWeight();
        }
        int randomWeight = random.m_188503_(totalWeight);
        for (BabyVisitorVariant variant : BabyVisitorVariant.values()) {
            if ((randomWeight -= variant.getWeight()) >= 0) continue;
            return variant;
        }
        return DEFAULT;
    }

    static {
        BY_ID = (BabyVisitorVariant[])Arrays.stream(BabyVisitorVariant.values()).sorted(Comparator.comparingInt(BabyVisitorVariant::getId)).toArray(BabyVisitorVariant[]::new);
    }
}

