/*
 * Decompiled with CFR 0.152.
 */
package net.redstonegames.visitingvillagers.entity.variant;

import java.util.Arrays;
import java.util.Comparator;
import net.minecraft.util.RandomSource;

public enum VisitorVariant {
    TEXTURE0(0, 10),
    TEXTURE1(1, 10),
    TEXTURE2(2, 10),
    TEXTURE3(3, 3),
    TEXTURE4(4, 8),
    TEXTURE5(5, 6),
    TEXTURE6(6, 6),
    TEXTURE7(7, 3),
    TEXTURE8(8, 8),
    TEXTURE9(9, 1),
    TEXTURE10(10, 8),
    TEXTURE11(11, 6),
    TEXTURE12(12, 6),
    DEFAULT(13, 40);

    private static final VisitorVariant[] BY_ID;
    private final int id;
    private final int weight;

    private VisitorVariant(int id, int weight) {
        this.id = id;
        this.weight = weight;
    }

    public int getId() {
        return this.id;
    }

    public int getWeight() {
        return this.weight;
    }

    public static VisitorVariant byId(int id) {
        int index = id % BY_ID.length;
        if (index < 0) {
            index += BY_ID.length;
        }
        return BY_ID[index];
    }

    public static VisitorVariant getRandomVariant(RandomSource random) {
        int totalWeight = 0;
        for (VisitorVariant variant : VisitorVariant.values()) {
            totalWeight += variant.getWeight();
        }
        int randomWeight = random.m_188503_(totalWeight);
        for (VisitorVariant variant : VisitorVariant.values()) {
            if ((randomWeight -= variant.getWeight()) >= 0) continue;
            return variant;
        }
        return TEXTURE0;
    }

    static {
        BY_ID = (VisitorVariant[])Arrays.stream(VisitorVariant.values()).sorted(Comparator.comparingInt(VisitorVariant::getId)).toArray(VisitorVariant[]::new);
    }
}

